/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.Util;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.web.wizards.AttrDialog;
import org.netbeans.modules.web.wizards.AttrTableModel;
import org.netbeans.modules.web.wizards.BrowseFolders;
import org.netbeans.modules.web.wizards.TagInfoPanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class TagHandlerPanelGUI
extends JPanel
implements ListSelectionListener {
    private TagInfoPanel panel;
    private TemplateWizard wiz;
    private Project proj;
    private SourceGroup[] folders;
    private String target;
    private FileObject tldFo;
    private Set tagValues;
    private JLabel attrLabel;
    private JTable attrTable;
    private JLabel bodyContentLb;
    private JButton browseButton;
    private ButtonGroup buttonGroup1;
    private JTextField classTextField;
    private JButton deleteButton;
    private JLabel descriptionLabel;
    private JButton editButton;
    private JRadioButton emptyButton;
    private JCheckBox jCheckBox1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JTextField nameTextField;
    private JButton newButton;
    private JRadioButton scriptlessButton;
    private JLabel tagClassLabel;
    private JLabel tagNameLabel;
    private JRadioButton tegdependentButton;
    private JLabel tldFileLabel;
    private JTextField tldTextField;

    public TagHandlerPanelGUI(TemplateWizard wiz, final TagInfoPanel panel, Project proj, SourceGroup[] folders) {
        this.initComponents();
        this.wiz = wiz;
        this.panel = panel;
        this.proj = proj;
        this.folders = folders;
        this.attrTable.setModel(new AttrTableModel(new String[]{"attrName", "attrType", "attrRequired", "attrRtexprvalue"}));
        this.attrTable.setSelectionMode(0);
        this.attrTable.setIntercellSpacing(new Dimension(6, 6));
        this.attrTable.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.setName(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_configure_TLD"));
        this.attrTable.getSelectionModel().addListSelectionListener(this);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent evt) {
                panel.fireChangeEvent();
            }

            public void insertUpdate(DocumentEvent evt) {
                panel.fireChangeEvent();
            }

            public void changedUpdate(DocumentEvent evt) {
                panel.fireChangeEvent();
            }
        });
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.tldTextField = new JTextField();
        this.browseButton = new JButton();
        this.tldFileLabel = new JLabel();
        this.tagNameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.tagClassLabel = new JLabel();
        this.classTextField = new JTextField();
        this.jPanel1 = new JPanel();
        this.emptyButton = new JRadioButton();
        this.scriptlessButton = new JRadioButton();
        this.tegdependentButton = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.attrLabel = new JLabel();
        this.jPanel3 = new JPanel();
        this.newButton = new JButton();
        this.editButton = new JButton();
        this.deleteButton = new JButton();
        this.bodyContentLb = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.descriptionLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.attrTable = new JTable();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TagHandlerPanel2"));
        this.tldTextField.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tldTextField, gridBagConstraints);
        this.tldTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TLDFile"));
        this.browseButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_Browse_Mnemonic").charAt(0));
        this.browseButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TagHandlerPanelGUI.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 12, 6);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_Browse"));
        this.tldFileLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_TLDName_mnem").charAt(0));
        this.tldFileLabel.setLabelFor(this.tldTextField);
        this.tldFileLabel.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_tldFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tldFileLabel, gridBagConstraints);
        this.tagNameLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_TagName_mnem").charAt(0));
        this.tagNameLabel.setLabelFor(this.nameTextField);
        this.tagNameLabel.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_tagName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.tagNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.nameTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TagName"));
        this.tagClassLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_ClassName_mnem").charAt(0));
        this.tagClassLabel.setLabelFor(this.classTextField);
        this.tagClassLabel.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_tagHandlerClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.tagClassLabel, gridBagConstraints);
        this.classTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.classTextField, gridBagConstraints);
        this.classTextField.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TagClass"));
        this.buttonGroup1.add(this.emptyButton);
        this.emptyButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_TagEmpty_mnem").charAt(0));
        this.emptyButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"OPT_emptyBodyContent"));
        this.jPanel1.add(this.emptyButton);
        this.emptyButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TagEmpty"));
        this.buttonGroup1.add(this.scriptlessButton);
        this.scriptlessButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_TagScriptless_mnem").charAt(0));
        this.scriptlessButton.setSelected(true);
        this.scriptlessButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"OPT_scriptlessBodyContent"));
        this.jPanel1.add(this.scriptlessButton);
        this.scriptlessButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TagScriptless"));
        this.buttonGroup1.add(this.tegdependentButton);
        this.tegdependentButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_TagTagdependent_mnem").charAt(0));
        this.tegdependentButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"OPT_tagdependentBodyContent"));
        this.jPanel1.add(this.tegdependentButton);
        this.tegdependentButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_TagTagdependent"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.attrLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_Attribs_mnem").charAt(0));
        this.attrLabel.setLabelFor(this.attrTable);
        this.attrLabel.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"TITLE_attributes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 6, 0);
        this.add((Component)this.attrLabel, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.newButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_new_mnemonic").charAt(0));
        this.newButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_newButton"));
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TagHandlerPanelGUI.this.newButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.newButton, gridBagConstraints);
        this.newButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_newButton"));
        this.editButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_edit_mnemonic").charAt(0));
        this.editButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_editButton"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TagHandlerPanelGUI.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel3.add((Component)this.editButton, gridBagConstraints);
        this.editButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_editButton"));
        this.deleteButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_delete_mnemonic").charAt(0));
        this.deleteButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_deleteButton"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TagHandlerPanelGUI.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel3.add((Component)this.deleteButton, gridBagConstraints);
        this.deleteButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("LBL_deleteButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.bodyContentLb.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"LBL_bodyContent"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.bodyContentLb, gridBagConstraints);
        this.jCheckBox1.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_AddToTLD_mnem").charAt(0));
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"OPT_addToTLD"));
        this.jCheckBox1.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TagHandlerPanelGUI.this.jCheckBox1ItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.jCheckBox1, gridBagConstraints);
        this.jCheckBox1.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("OPT_addToTLD"));
        this.descriptionLabel.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"HINT_tldFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.descriptionLabel, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.attrTable);
        this.attrTable.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/web/wizards/Bundle").getString("A11Y_DESC_AttrTable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int row = this.attrTable.getSelectedRow();
        if (row >= 0) {
            ((AttrTableModel)this.attrTable.getModel()).removeRow(row);
            ((AttrTableModel)this.attrTable.getModel()).fireTableRowsDeleted(row, row);
        }
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        String title = NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"TITLE_attr_add");
        final AttrDialog panel = new AttrDialog();
        final AttrTableModel tableModel = (AttrTableModel)this.attrTable.getModel();
        EditDialog editDialog = new EditDialog(panel, title, true){

            protected String validate() {
                String newAttrName = panel.getAttrName();
                if (newAttrName.length() == 0) {
                    return NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"MSG_attr_no_name");
                }
                if (!TagHandlerPanelGUI.this.isJavaIdentifier(newAttrName)) {
                    return NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"MSG_wrong_attr_name", (Object)newAttrName);
                }
                Object[][] attrs = tableModel.getAttributes();
                for (int i = 0; i < attrs.length; ++i) {
                    if (!newAttrName.equals(attrs[i][0])) continue;
                    return NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"MSG_attr_exists");
                }
                return null;
            }
        };
        editDialog.setValid(false);
        EditDialog.DocListener docListener = new EditDialog.DocListener(editDialog);
        panel.getAttrNameTF().getDocument().addDocumentListener((DocumentListener)docListener);
        Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)editDialog);
        d.getAccessibleContext().setAccessibleDescription(editDialog.getDialogPanel().getAccessibleContext().getAccessibleDescription());
        d.show();
        panel.getAttrNameTF().getDocument().removeDocumentListener((DocumentListener)docListener);
        if (editDialog.getValue().equals(EditDialog.OK_OPTION)) {
            int rowCount = tableModel.getRowCount();
            tableModel.addRow(panel.getAttrName(), panel.getAttrType(), panel.isRequired(), panel.isRtexpr());
            tableModel.fireTableRowsInserted(rowCount, rowCount);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        if (this.browseButton == evt.getSource()) {
            FileObject fo = null;
            if (this.folders != null) {
                fo = BrowseFolders.showDialog(this.folders, TLDDataObject.class, "");
            } else {
                Sources sources = ProjectUtils.getSources((Project)this.proj);
                fo = BrowseFolders.showDialog(sources.getSourceGroups("generic"), DataFolder.class, "");
            }
            if (fo != null) {
                this.tldFo = fo;
                FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wiz);
                WebModule wm = WebModule.getWebModule((FileObject)targetFolder);
                this.tldTextField.setText(FileUtil.getRelativePath((FileObject)(wm == null ? this.proj.getProjectDirectory() : wm.getDocumentBase()), (FileObject)fo));
                try {
                    InputStream is = this.tldFo.getInputStream();
                    this.tagValues = Util.getTagValues(is, new String[]{"tag", "tag-file"}, "name");
                    is.close();
                }
                catch (IOException ex) {
                }
                catch (SAXException ex) {
                    // empty catch block
                }
                this.panel.fireChangeEvent();
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.attrTable.getSelectionModel().isSelectionEmpty()) {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
        }
    }

    private void jCheckBox1ItemStateChanged(ItemEvent evt) {
        if (this.jCheckBox1.isSelected()) {
            this.browseButton.setEnabled(true);
            this.nameTextField.setEnabled(true);
            this.emptyButton.setEnabled(true);
            this.scriptlessButton.setEnabled(true);
            this.tegdependentButton.setEnabled(true);
        } else {
            this.browseButton.setEnabled(false);
            this.nameTextField.setEnabled(false);
            this.emptyButton.setEnabled(false);
            this.scriptlessButton.setEnabled(false);
            this.tegdependentButton.setEnabled(false);
        }
        this.panel.fireChangeEvent();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        String title = NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"TITLE_attr_edit");
        final AttrTableModel tableModel = (AttrTableModel)this.attrTable.getModel();
        final int row = this.attrTable.getSelectedRow();
        String attrName = (String)tableModel.getValueAt(row, 0);
        String attrType = (String)tableModel.getValueAt(row, 1);
        boolean required = (Boolean)tableModel.getValueAt(row, 2);
        boolean rtexpr = (Boolean)tableModel.getValueAt(row, 3);
        final AttrDialog panel = new AttrDialog(attrName, attrType, required, rtexpr);
        EditDialog editDialog = new EditDialog(panel, title, false){

            protected String validate() {
                String newAttrName = panel.getAttrName();
                if (newAttrName.length() == 0) {
                    return NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"MSG_attr_no_name");
                }
                if (!TagHandlerPanelGUI.this.isJavaIdentifier(newAttrName)) {
                    return NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"MSG_wrong_attr_name", (Object)newAttrName);
                }
                Object[][] attrs = tableModel.getAttributes();
                for (int i = 0; i < attrs.length; ++i) {
                    if (i == row || !newAttrName.equals(attrs[i][0])) continue;
                    return NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"MSG_attr_exists");
                }
                return null;
            }
        };
        EditDialog.DocListener docListener = new EditDialog.DocListener(editDialog);
        panel.getAttrNameTF().getDocument().addDocumentListener((DocumentListener)docListener);
        Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)editDialog);
        d.getAccessibleContext().setAccessibleDescription(editDialog.getDialogPanel().getAccessibleContext().getAccessibleDescription());
        d.show();
        panel.getAttrNameTF().getDocument().removeDocumentListener((DocumentListener)docListener);
        if (editDialog.getValue().equals(EditDialog.OK_OPTION)) {
            tableModel.setData(panel.getAttrName(), panel.getAttrType(), panel.isRequired(), panel.isRtexpr(), row);
            tableModel.fireTableRowsUpdated(row, row);
        }
    }

    String getTagName() {
        return this.nameTextField.getText();
    }

    void setTagName(String name) {
        this.nameTextField.setText(name);
    }

    void setClassName(String name) {
        this.classTextField.setText(name);
    }

    FileObject getTLDFile() {
        return this.tldFo;
    }

    Set getTagValues() {
        return this.tagValues;
    }

    boolean isEmpty() {
        return this.emptyButton.isSelected();
    }

    boolean isScriptless() {
        return this.scriptlessButton.isSelected();
    }

    boolean isTegdependent() {
        return this.tegdependentButton.isSelected();
    }

    boolean writeToTLD() {
        return this.jCheckBox1.isSelected();
    }

    Object[][] getAttributes() {
        return ((AttrTableModel)this.attrTable.getModel()).getAttributes();
    }

    void setBodySupport(boolean bodySupport) {
        if (bodySupport) {
            this.scriptlessButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"OPT_jspBodyContent"));
        } else {
            this.scriptlessButton.setText(NbBundle.getMessage(TagHandlerPanelGUI.class, (String)"OPT_scriptlessBodyContent"));
        }
    }

    private boolean isJavaIdentifier(String s) {
        if (s.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

