/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.modeler.ModelerException;
import com.sun.xml.rpc.processor.modeler.rmi.MemberInfo;
import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import com.sun.xml.rpc.processor.modeler.rmi.RmiType;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

public class JavaBean
implements RmiConstants {
    private HashMap members;
    private Class remoteBean;
    ProcessorEnvironment env;

    private void initialize() {
        this.members = new HashMap();
        JavaBean.collectMembers(this.remoteBean, this.members, this.remoteBean);
    }

    private HashMap getMembers() {
        return (HashMap)this.members.clone();
    }

    private JavaBean(ProcessorEnvironment env, Class remoteBean) {
        this.env = env;
        this.remoteBean = remoteBean;
    }

    private static void log(ProcessorEnvironment env, String msg) {
        if (env.verbose()) {
            System.out.println("[JavaBean: " + msg + "]");
        }
    }

    private static JavaBean forType(ProcessorEnvironment env, RmiType type) {
        JavaBean bean = null;
        try {
            String implClassName = type.getClassName();
            URLClassLoader classLoader = env.getClassLoader();
            Class<?> beanClass = classLoader.loadClass(implClassName);
            bean = new JavaBean(env, beanClass);
            bean.initialize();
        }
        catch (ClassNotFoundException e) {
            throw new ModelerException("rmimodeler.nestedRmiModelerError", new LocalizableExceptionAdapter(e));
        }
        return bean;
    }

    private static void collectMembers(Class remoteBean, Map members, Class baseBean) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(remoteBean);
        }
        catch (IntrospectionException e) {
            throw new ModelerException("rmimodeler.invalid.rmi.type:", remoteBean.getName().toString());
        }
        PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
        int i = 0;
        while (i < properties.length) {
            Class<?> propertyType = properties[i].getPropertyType();
            Method readMethod = properties[i].getReadMethod();
            Method writeMethod = properties[i].getWriteMethod();
            if (propertyType != null && readMethod != null && writeMethod != null && readMethod.getParameterTypes().length == 0 && writeMethod.getParameterTypes().length == 1) {
                String propertyName = properties[i].getName();
                RmiType type = RmiType.getRmiType(readMethod.getReturnType());
                if (type == null) {
                    throw new ModelerException("rmimodeler.could.not.resolve.property.type", remoteBean.getName() + ":" + propertyName);
                }
                MemberInfo memInfo = new MemberInfo(propertyName, type, false);
                memInfo.setReadMethod(readMethod.getName());
                memInfo.setWriteMethod(writeMethod.getName());
                if (!writeMethod.getDeclaringClass().equals(baseBean)) {
                    memInfo.setDeclaringClass(writeMethod.getDeclaringClass());
                }
                members.put(propertyName, memInfo);
            }
            ++i;
        }
        if (remoteBean.getSuperclass() != null) {
            JavaBean.collectMembers(remoteBean.getSuperclass(), members, baseBean);
        }
        Class<?>[] interfaces = remoteBean.getInterfaces();
        int i2 = 0;
        while (i2 < interfaces.length) {
            JavaBean.collectMembers(interfaces[i2], members, baseBean);
            ++i2;
        }
    }

    public static Map modelTypeSOAP(ProcessorEnvironment env, RmiType type) {
        JavaBean bean = JavaBean.forType(env, type);
        if (bean == null) {
            return null;
        }
        return bean.getMembers();
    }
}

