/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

public final class ElementIdStack {
    private int[] _values;
    private int _tos;
    private int _nextElementId;
    private static final int INITIAL_SIZE = 32;

    public int getCurrent() {
        return this._values[this._tos - 1];
    }

    public int pop() {
        --this._tos;
        return this._values[this._tos];
    }

    public int pushNext() {
        this.ensureCapacity();
        this._values[this._tos++] = this._nextElementId;
        return this._nextElementId++;
    }

    public ElementIdStack() {
        this(32);
    }

    private void ensureCapacity() {
        if (this._tos >= this._values.length) {
            int[] newValues = new int[this._values.length * 2];
            System.arraycopy(this._values, 0, newValues, 0, this._values.length);
            this._values = newValues;
        }
    }

    public void reset() {
        this._tos = 0;
        this._nextElementId = 1;
    }

    public ElementIdStack(int size) {
        this._values = new int[size];
        this.reset();
    }
}

