/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldStateChange;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.modules.editor.fold.ApiPackageAccessor;
import org.netbeans.modules.editor.fold.FoldHierarchyExecution;
import org.netbeans.modules.editor.fold.FoldOperationImpl;
import org.netbeans.modules.editor.fold.FoldUtilitiesImpl;
import org.netbeans.modules.editor.fold.SpiPackageAccessor;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.openide.ErrorManager;

public final class FoldHierarchyTransactionImpl {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.fold");
    private static final Fold[] EMPTY_FOLDS = new Fold[0];
    private static final FoldStateChange[] EMPTY_FOLD_STATE_CHANGES = new FoldStateChange[0];
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private FoldHierarchyTransaction transaction;
    private boolean committed;
    private FoldHierarchyExecution execution;
    private Fold lastOperationFold;
    private int lastOperationIndex;
    private Fold addFoldBlock;
    private List unblockedFoldLists = new ArrayList(4);
    private int unblockedFoldMaxPriority = -1;
    private Set addedToHierarchySet;
    private Set removedFromHierarchySet;
    private Map fold2StateChange;
    private int affectedStartOffset;
    private int affectedEndOffset;

    public FoldHierarchyTransactionImpl(FoldHierarchyExecution execution) {
        this.execution = execution;
        this.affectedStartOffset = Integer.MAX_VALUE;
        this.affectedEndOffset = -1;
        this.transaction = SpiPackageAccessor.get().createFoldHierarchyTransaction(this);
    }

    public FoldHierarchyTransaction getTransaction() {
        return this.transaction;
    }

    public void commit() {
        this.checkNotCommitted();
        this.committed = true;
        this.execution.clearActiveTransaction();
        if (!this.isEmpty()) {
            FoldStateChange[] stateChanges;
            Fold[] addedFolds;
            Fold[] removedFolds;
            int size;
            if (this.removedFromHierarchySet != null && (size = this.removedFromHierarchySet.size()) != 0) {
                removedFolds = new Fold[size];
                this.removedFromHierarchySet.toArray(removedFolds);
            } else {
                removedFolds = EMPTY_FOLDS;
            }
            if (this.addedToHierarchySet != null && (size = this.addedToHierarchySet.size()) != 0) {
                addedFolds = new Fold[size];
                this.addedToHierarchySet.toArray(addedFolds);
            } else {
                addedFolds = EMPTY_FOLDS;
            }
            if (this.fold2StateChange != null) {
                stateChanges = new FoldStateChange[this.fold2StateChange.size()];
                this.fold2StateChange.values().toArray(stateChanges);
            } else {
                stateChanges = EMPTY_FOLD_STATE_CHANGES;
            }
            for (int i = stateChanges.length - 1; i >= 0; --i) {
                FoldStateChange change = stateChanges[i];
                Fold fold = change.getFold();
                this.updateAffectedOffsets(fold);
                int origOffset = change.getOriginalStartOffset();
                if (origOffset != -1) {
                    this.updateAffectedStartOffset(origOffset);
                }
                if ((origOffset = change.getOriginalEndOffset()) == -1) continue;
                this.updateAffectedEndOffset(origOffset);
            }
            this.execution.createAndFireFoldHierarchyEvent(removedFolds, addedFolds, stateChanges, this.affectedStartOffset, this.affectedEndOffset);
        }
    }

    public void insertUpdate(DocumentEvent evt) {
        if (debug) {
            System.err.println("insertUpdate: offset=" + evt.getOffset() + ", length=" + evt.getLength());
        }
        try {
            this.insertCheckEndOffset(this.execution.getRootFold(), evt);
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void insertCheckEndOffset(Fold fold, DocumentEvent evt) throws BadLocationException {
        int insertEndOffset = evt.getOffset() + evt.getLength();
        int childIndex = FoldUtilitiesImpl.findFoldStartIndex(fold, insertEndOffset, false);
        if (childIndex >= 0) {
            int childFoldEndOffset;
            Fold childFold = fold.getFold(childIndex);
            if (childIndex > 0 && childFold.getStartOffset() == insertEndOffset) {
                childFold = fold.getFold(--childIndex);
            }
            if ((childFoldEndOffset = childFold.getEndOffset()) >= insertEndOffset) {
                this.insertCheckEndOffset(childFold, evt);
                ApiPackageAccessor.get().foldInsertUpdate(childFold, evt);
                if (childFoldEndOffset == insertEndOffset) {
                    this.setEndOffset(childFold, evt.getDocument(), evt.getOffset());
                } else {
                    ApiPackageAccessor api = ApiPackageAccessor.get();
                    if (api.foldIsStartDamaged(childFold) || api.foldIsEndDamaged(childFold)) {
                        this.execution.remove(childFold, this);
                        this.removeDamagedNotify(childFold);
                        if (debug) {
                            System.err.println("insertUpdate: removed damaged " + childFold);
                        }
                    }
                }
            }
        }
    }

    private FoldOperationImpl getOperation(Fold fold) {
        return ApiPackageAccessor.get().foldGetOperation(fold);
    }

    private FoldManager getManager(Fold fold) {
        return this.getOperation(fold).getManager();
    }

    private void setEndOffset(Fold fold, Document doc, int endOffset) throws BadLocationException {
        int origEndOffset = fold.getEndOffset();
        ApiPackageAccessor api = ApiPackageAccessor.get();
        api.foldSetEndOffset(fold, doc, endOffset);
        api.foldStateChangeEndOffsetChanged(this.getFoldStateChange(fold), origEndOffset);
    }

    public void setCollapsed(Fold fold, boolean collapsed) {
        boolean oldCollapsed = fold.isCollapsed();
        if (oldCollapsed != collapsed) {
            ApiPackageAccessor api = ApiPackageAccessor.get();
            api.foldSetCollapsed(fold, collapsed);
            api.foldStateChangeCollapsedChanged(this.getFoldStateChange(fold));
        }
    }

    private void removeDamagedNotify(Fold fold) {
        this.getManager(fold).removeDamagedNotify(fold);
    }

    private void removeEmptyNotify(Fold fold) {
        this.getManager(fold).removeEmptyNotify(fold);
    }

    public void removeUpdate(DocumentEvent evt) {
        if (debug) {
            System.err.println("removeUpdate: offset=" + evt.getOffset());
        }
        this.removeCheckDamaged(this.execution.getRootFold(), evt);
    }

    private void removeCheckDamaged(Fold fold, DocumentEvent evt) {
        ApiPackageAccessor api = ApiPackageAccessor.get();
        int childIndex = FoldUtilitiesImpl.findFoldStartIndex(fold, evt.getOffset(), true);
        if (childIndex >= 0) {
            boolean removed;
            do {
                Fold childFold = fold.getFold(childIndex);
                removed = false;
                if (FoldUtilities.isEmpty(childFold)) {
                    this.removeCheckDamaged(childFold, evt);
                    this.execution.remove(childFold, this);
                    this.getManager(childFold).removeEmptyNotify(childFold);
                    removed = true;
                    if (debug) {
                        System.err.println("insertUpdate: removed empty " + childFold);
                    }
                } else if (api.foldIsStartDamaged(childFold) || api.foldIsEndDamaged(childFold)) {
                    this.removeCheckDamaged(childFold, evt);
                    this.execution.remove(childFold, this);
                    this.getManager(childFold).removeDamagedNotify(childFold);
                    removed = true;
                    if (debug) {
                        System.err.println("insertUpdate: removed damaged " + childFold);
                    }
                } else if (childFold.getFoldCount() > 0) {
                    this.removeCheckDamaged(childFold, evt);
                }
                if (removed) continue;
                if (childFold.isCollapsed() && api.foldIsExpandNecessary(childFold)) {
                    this.setCollapsed(childFold, false);
                }
                api.foldRemoveUpdate(childFold, evt);
            } while (removed && childIndex < fold.getFoldCount());
        }
    }

    private boolean isEmpty() {
        return !(this.fold2StateChange != null && this.fold2StateChange.size() != 0 || this.addedToHierarchySet != null && this.addedToHierarchySet.size() != 0 || this.removedFromHierarchySet != null && this.removedFromHierarchySet.size() != 0);
    }

    public FoldStateChange getFoldStateChange(Fold fold) {
        FoldStateChange change;
        if (this.fold2StateChange == null) {
            this.fold2StateChange = new HashMap();
        }
        if ((change = (FoldStateChange)this.fold2StateChange.get(fold)) == null) {
            change = ApiPackageAccessor.get().createFoldStateChange(fold);
            this.fold2StateChange.put(fold, change);
        }
        return change;
    }

    void removeFold(Fold fold) {
        Fold parent;
        if (debug) {
            System.err.println("removeFold: " + fold);
        }
        if ((parent = fold.getParent()) != null) {
            int index = parent.getFoldIndex(fold);
            this.removeFoldFromHierarchy(parent, index, null);
            this.lastOperationFold = parent;
            this.lastOperationIndex = index;
        } else {
            if (!this.execution.isBlocked(fold)) {
                throw new IllegalStateException("Fold already removed: " + fold);
            }
            this.execution.unmarkBlocked(fold);
            this.unblockBlocked(fold);
        }
        this.processUnblocked();
    }

    void removeAllFolds(Fold[] allBlocked) {
        for (int i = allBlocked.length - 1; i >= 0; --i) {
            this.removeFold(allBlocked[i]);
        }
        this.removeAllChildrenAndSelf(this.execution.getRootFold());
    }

    private void removeAllChildrenAndSelf(Fold fold) {
        int foldCount = fold.getFoldCount();
        if (foldCount > 0) {
            for (int i = foldCount - 1; i >= 0; --i) {
                this.removeAllChildrenAndSelf(fold.getFold(i));
            }
        }
        if (!FoldUtilities.isRootFold(fold)) {
            this.removeFold(fold);
        }
    }

    public void changedUpdate(DocumentEvent evt) {
    }

    boolean addFold(Fold fold) {
        if (debug) {
            System.err.println("addFold: " + fold);
        }
        return this.addFold(fold, null);
    }

    private boolean addFold(Fold fold, Fold parentFold) {
        boolean blocked;
        int[] prevOverlapIndexes;
        Fold nextFold;
        Fold prevFold;
        boolean useLast;
        int index;
        int foldStartOffset = fold.getStartOffset();
        int foldEndOffset = fold.getEndOffset();
        int foldPriority = this.getOperation(fold).getPriority();
        if (parentFold == null) {
            parentFold = this.lastOperationFold;
            if (parentFold == null || foldStartOffset < parentFold.getStartOffset() || foldEndOffset > parentFold.getEndOffset()) {
                parentFold = this.execution.getRootFold();
                index = FoldUtilitiesImpl.findFoldInsertIndex(parentFold, foldStartOffset);
                useLast = false;
            } else {
                index = this.lastOperationIndex;
                useLast = true;
            }
        } else {
            index = FoldUtilitiesImpl.findFoldInsertIndex(parentFold, foldStartOffset);
            useLast = false;
        }
        int foldCount = parentFold.getFoldCount();
        if (useLast && index > foldCount) {
            index = FoldUtilitiesImpl.findFoldInsertIndex(parentFold, foldStartOffset);
            useLast = false;
        }
        if (index > 0) {
            prevFold = parentFold.getFold(index - 1);
            if (useLast && foldStartOffset < prevFold.getStartOffset()) {
                index = FoldUtilitiesImpl.findFoldInsertIndex(parentFold, foldStartOffset);
                useLast = false;
                prevFold = index > 0 ? parentFold.getFold(index - 1) : null;
            }
        } else {
            prevFold = null;
        }
        if (index < foldCount) {
            nextFold = parentFold.getFold(index);
            if (useLast && foldStartOffset >= nextFold.getStartOffset()) {
                index = FoldUtilitiesImpl.findFoldInsertIndex(parentFold, foldStartOffset);
                useLast = false;
                prevFold = index > 0 ? parentFold.getFold(index - 1) : null;
                nextFold = index < foldCount ? parentFold.getFold(index) : null;
            }
        } else {
            nextFold = null;
        }
        if (prevFold != null && foldStartOffset < prevFold.getEndOffset()) {
            if (foldEndOffset <= prevFold.getEndOffset()) {
                return this.addFold(fold, prevFold);
            }
            if (foldPriority > this.getOperation(prevFold).getPriority()) {
                if (prevFold.getFoldCount() > 0) {
                    prevOverlapIndexes = this.inspectOverlap(prevFold, foldStartOffset, foldPriority, 1);
                    blocked = prevOverlapIndexes == null;
                } else {
                    blocked = false;
                    prevOverlapIndexes = EMPTY_INT_ARRAY;
                }
            } else {
                blocked = true;
                this.addFoldBlock = prevFold;
                prevOverlapIndexes = null;
            }
        } else {
            blocked = false;
            prevOverlapIndexes = null;
        }
        if (!blocked) {
            int nextIndex = index;
            int[] nextOverlapIndexes = null;
            if (nextFold != null && foldEndOffset > nextFold.getStartOffset()) {
                if (foldEndOffset >= nextFold.getEndOffset()) {
                    nextIndex = FoldUtilitiesImpl.findFoldStartIndex(parentFold, foldEndOffset, false);
                    nextFold = parentFold.getFold(nextIndex);
                }
                if (foldEndOffset < nextFold.getEndOffset()) {
                    if (foldPriority > this.getOperation(nextFold).getPriority()) {
                        if (nextFold.getFoldCount() > 0) {
                            nextOverlapIndexes = this.inspectOverlap(nextFold, foldEndOffset, foldPriority, 1);
                            if (nextOverlapIndexes == null) {
                                blocked = true;
                            }
                        } else {
                            nextOverlapIndexes = EMPTY_INT_ARRAY;
                        }
                    } else {
                        blocked = true;
                        this.addFoldBlock = nextFold;
                    }
                } else {
                    ++nextIndex;
                }
            }
            if (!blocked) {
                int replaceIndexShift;
                if (prevOverlapIndexes != null) {
                    if (prevOverlapIndexes.length == 0) {
                        replaceIndexShift = 0;
                    } else {
                        replaceIndexShift = this.removeOverlap(prevFold, prevOverlapIndexes, fold);
                        nextIndex += prevFold.getFoldCount();
                    }
                    this.removeFoldFromHierarchy(parentFold, index - 1, fold);
                    index += replaceIndexShift - 1;
                    --nextIndex;
                }
                if (nextOverlapIndexes != null) {
                    replaceIndexShift = nextOverlapIndexes.length == 0 ? 0 : this.removeOverlap(nextFold, nextOverlapIndexes, fold);
                    this.removeFoldFromHierarchy(parentFold, nextIndex, fold);
                    nextIndex += replaceIndexShift;
                }
                ApiPackageAccessor.get().foldExtractToChildren(parentFold, index, nextIndex - index, fold);
                this.updateAffectedOffsets(fold);
                this.markFoldAddedToHierarchy(fold);
                this.processUnblocked();
            }
        }
        if (blocked) {
            this.execution.markBlocked(fold, this.addFoldBlock);
            this.addFoldBlock = null;
        }
        this.lastOperationFold = parentFold;
        this.lastOperationIndex = index + 1;
        return !blocked;
    }

    private int[] inspectOverlap(Fold fold, int offset, int priority, int level) {
        int[] result;
        Fold indexFold;
        int index = FoldUtilitiesImpl.findFoldStartIndex(fold, offset, false);
        if (index >= 0 && FoldUtilities.containsOffset(indexFold = fold.getFold(index), offset)) {
            if (priority > this.getOperation(indexFold).getPriority()) {
                if (indexFold.getFoldCount() > 0) {
                    result = this.inspectOverlap(indexFold, offset, priority, level + 1);
                    if (result != null) {
                        result[level] = index;
                    }
                } else {
                    result = new int[level + 1];
                    result[0] = 1;
                    result[level] = index;
                }
            } else {
                this.addFoldBlock = indexFold;
                result = null;
            }
        } else {
            result = new int[level + 1];
            result[0] = 0;
            result[level] = index;
        }
        return result;
    }

    private int removeOverlap(Fold fold, int[] indexes, Fold block) {
        int indexShift = 0;
        int indexesLengthM1 = indexes.length - 1;
        for (int i = 1; i < indexesLengthM1; ++i) {
            int index = indexes[i] + indexShift;
            this.removeFoldFromHierarchy(fold, index, block);
            indexShift += index;
        }
        int index = indexes[indexesLengthM1] + indexShift;
        if (indexes[0] == 0) {
            ++index;
        } else {
            this.removeFoldFromHierarchy(fold, index, block);
        }
        return index;
    }

    private void removeFoldFromHierarchy(Fold parentFold, int index, Fold block) {
        Fold removedFold = ApiPackageAccessor.get().foldReplaceByChildren(parentFold, index);
        this.updateAffectedOffsets(removedFold);
        this.markFoldRemovedFromHierarchy(removedFold);
        this.unblockBlocked(removedFold);
        if (block != null) {
            this.execution.markBlocked(removedFold, block);
        }
    }

    private void unblockBlocked(Fold block) {
        Set blockedSet = this.execution.unmarkBlock(block);
        if (blockedSet != null) {
            Iterator it = blockedSet.iterator();
            while (it.hasNext()) {
                Fold blocked = (Fold)it.next();
                int priority = this.getOperation(blocked).getPriority();
                while (this.unblockedFoldLists.size() <= priority) {
                    this.unblockedFoldLists.add(new ArrayList(4));
                }
                ((List)this.unblockedFoldLists.get(priority)).add(blocked);
                if (priority <= this.unblockedFoldMaxPriority) continue;
                this.unblockedFoldMaxPriority = priority;
            }
        }
    }

    private void processUnblocked() {
        if (this.unblockedFoldMaxPriority >= 0) {
            for (int priority = this.unblockedFoldMaxPriority; priority >= 0; --priority) {
                List foldList = (List)this.unblockedFoldLists.get(priority);
                Fold rootFold = this.execution.getRootFold();
                for (int i = foldList.size() - 1; i >= 0; --i) {
                    Fold unblocked = (Fold)foldList.remove(i);
                    if (this.execution.isAddedOrBlocked(unblocked)) continue;
                    this.unblockedFoldMaxPriority = -1;
                    this.addFold(unblocked, rootFold);
                    if (this.unblockedFoldMaxPriority >= priority) {
                        throw new IllegalStateException("Folds removed with priority=" + this.unblockedFoldMaxPriority);
                    }
                    if (foldList.size() == i) continue;
                    throw new IllegalStateException("Same priority folds removed");
                }
            }
        }
        this.unblockedFoldMaxPriority = -1;
    }

    private void markFoldAddedToHierarchy(Fold fold) {
        if (this.removedFromHierarchySet == null || !this.removedFromHierarchySet.remove(fold)) {
            if (this.addedToHierarchySet == null) {
                this.addedToHierarchySet = new HashSet();
            }
            this.addedToHierarchySet.add(fold);
        }
    }

    private void markFoldRemovedFromHierarchy(Fold fold) {
        if (this.addedToHierarchySet == null || !this.addedToHierarchySet.remove(fold)) {
            if (this.removedFromHierarchySet == null) {
                this.removedFromHierarchySet = new HashSet();
            }
            this.removedFromHierarchySet.add(fold);
        }
    }

    private void updateAffectedOffsets(Fold fold) {
        this.updateAffectedStartOffset(fold.getStartOffset());
        this.updateAffectedEndOffset(fold.getEndOffset());
    }

    private void updateAffectedStartOffset(int offset) {
        if (offset < this.affectedStartOffset) {
            this.affectedStartOffset = offset;
        }
    }

    private void updateAffectedEndOffset(int offset) {
        if (offset > this.affectedEndOffset) {
            this.affectedEndOffset = offset;
        }
    }

    private void checkNotCommitted() {
        if (this.committed) {
            throw new IllegalStateException("FoldHierarchyChange already committed.");
        }
    }
}

