/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.util;

import com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;

public class ParserPool {
    private Stack parsers;
    private SAXParserFactory factory;
    private int capacity;

    public ParserPool(int capacity) {
        this.capacity = capacity;
        this.factory = new SAXParserFactoryImpl();
        this.factory.setNamespaceAware(true);
        this.parsers = new Stack();
    }

    public synchronized SAXParser get() throws ParserConfigurationException, SAXException {
        try {
            return (SAXParser)this.parsers.pop();
        }
        catch (EmptyStackException e) {
            return this.factory.newSAXParser();
        }
    }

    public synchronized void put(SAXParser parser) {
        if (this.parsers.size() < this.capacity) {
            this.parsers.push(parser);
        }
    }
}

