/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.ResourceImpl;
import org.netbeans.modules.refactoring.CommentElement;
import org.netbeans.modules.refactoring.JavadocElement;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;

public class CommentFinder {
    Element source;
    String text;
    Set allResources = null;
    int minindex = 0;
    int maxindex = Integer.MAX_VALUE;

    public CommentFinder(Element el) {
        this.source = el;
        this.text = this.computeName();
        this.allResources = new HashSet();
        if (((MetadataElement)el).isTransient() || el instanceof Parameter) {
            Feature f = JavaModelUtil.getDeclaringFeature((Element)this.source);
            this.minindex = f.getStartOffset();
            this.maxindex = f.getEndOffset() - 1;
        }
    }

    private String computeName() {
        String id;
        String fullPackageName = null;
        if (this.source instanceof JavaClass) {
            id = ((JavaClass)this.source).getSimpleName();
        } else if (this.source instanceof JavaPackage) {
            fullPackageName = id = ((JavaPackage)this.source).getName();
            int lastDot = id.lastIndexOf(46);
            if (lastDot != -1) {
                id = id.substring(lastDot + 1);
            }
        } else {
            id = this.source instanceof Constructor ? ((JavaClass)((Constructor)this.source).getDeclaringClass()).getSimpleName() : ((NamedElement)this.source).getName();
        }
        return id;
    }

    public Collection searchCommentsInResource(Resource rsc) {
        if (rsc != null && this.allResources.add(rsc)) {
            Collection items = this.searchJavaDocsInResource(rsc);
            if (rsc instanceof ResourceImpl) {
                items.addAll(this.searchInPlainComments((ResourceImpl)rsc));
            }
            return items;
        }
        return Collections.EMPTY_LIST;
    }

    private Collection searchInPlainComments(ResourceImpl rsc) {
        String fullText = rsc.getSourceText();
        if (fullText != null) {
            int fi;
            int offset = 0;
            ArrayList<RefactoringElementImplementation> items = new ArrayList<RefactoringElementImplementation>(1);
            offset = 0;
            while (offset < fullText.length() && (fi = fullText.indexOf(this.text, offset)) != -1) {
                int end;
                offset = fi + 1;
                if (fi < this.minindex || fi > this.maxindex || fi != 0 && Character.isJavaIdentifierPart(fullText.charAt(fi - 1)) || (end = fi + this.text.length()) < fullText.length() && Character.isJavaIdentifierPart(fullText.charAt(end)) || !rsc.isComment(fi)) continue;
                items.add(this.createNewElement((Resource)rsc, fi));
            }
            return items;
        }
        return Collections.EMPTY_LIST;
    }

    private Collection searchJavaDocsInResource(Resource rsc) {
        ArrayList elements = new ArrayList(1);
        Iterator jIt = rsc.getClassifiers().iterator();
        while (jIt.hasNext()) {
            JavaClass jcls = (JavaClass)jIt.next();
            elements.addAll(this.searchText((ClassMember)jcls));
            elements.addAll(this.searchJavaDocsInJavaClass(jcls));
        }
        return elements;
    }

    private Collection searchJavaDocsInJavaClass(JavaClass jcls) {
        Iterator fIt = jcls.getContents().iterator();
        ArrayList elems = new ArrayList();
        while (fIt.hasNext()) {
            ClassMember f = (ClassMember)fIt.next();
            elems.addAll(this.searchText(f));
            if (!(f instanceof JavaClass)) continue;
            elems.addAll(this.searchJavaDocsInJavaClass((JavaClass)f));
        }
        return elems;
    }

    private Collection searchText(ClassMember f) {
        String docText;
        int javadocStart = f.getStartOffset();
        if (javadocStart >= this.minindex && javadocStart <= this.maxindex && (docText = f.getJavadocText()) != null) {
            int fi;
            int offset = 0;
            ArrayList<RefactoringElementImplementation> items = new ArrayList<RefactoringElementImplementation>(1);
            offset = 0;
            while (offset < docText.length() && (fi = docText.indexOf(this.text, offset)) != -1) {
                int end;
                offset = fi + 1;
                if (fi != 0 && Character.isJavaIdentifierPart(docText.charAt(fi - 1)) || (end = fi + this.text.length()) < docText.length() && Character.isJavaIdentifierPart(docText.charAt(end))) continue;
                items.add(this.createNewElement(f, fi));
            }
            return items;
        }
        return Collections.EMPTY_LIST;
    }

    protected RefactoringElementImplementation createNewElement(ClassMember feature, int offset) {
        return new JavadocElement(offset, this.text, feature);
    }

    protected RefactoringElementImplementation createNewElement(Resource rsc, int offset) {
        return new CommentElement(offset, this.text, rsc);
    }
}

