/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.GridBagConstraints;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.welcome.content.BackgroundPainter;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.ComponentDescriptor;
import org.netbeans.modules.welcome.content.DefaultComponentDescriptor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class ContentParser
extends DefaultHandler {
    private static final String ELEM_ROOT = "welcomepage";
    private static final String ELEM_BACKGROUND = "background";
    private static final String ELEM_PANEL = "panel";
    private static final String ELEM_CONSTRAINTS = "constraints";
    private static final String CURRENT_VERSION = "1.0";
    private Map anchors = new HashMap(10);
    private Map fills = new HashMap(4);
    private Map descriptors = new HashMap(5);
    private ArrayList contentIds = new ArrayList(5);
    private String backgroundPainterClassName;
    private ComponentDescriptor currentDescriptor;
    private static final String CONTENT_ROOT_FOLDER = "WelcomePage";

    public ContentParser() {
        this.anchors.put("CENTER", new Integer(10));
        this.anchors.put("WEST", new Integer(17));
        this.anchors.put("NORTH", new Integer(11));
        this.anchors.put("NORTHEAST", new Integer(12));
        this.anchors.put("NORTHEAST", new Integer(12));
        this.anchors.put("EAST", new Integer(13));
        this.anchors.put("SOUTH", new Integer(15));
        this.anchors.put("SOUTHEAST", new Integer(14));
        this.anchors.put("SOUTHWEST", new Integer(16));
        this.fills.put("NONE", new Integer(0));
        this.fills.put("HORIZONTAL", new Integer(2));
        this.fills.put("VERTICAL", new Integer(3));
        this.fills.put("BOTH", new Integer(1));
    }

    public void parse() throws ParserConfigurationException, SAXException, IOException {
        FileObject root = Repository.getDefault().getDefaultFileSystem().findResource(CONTENT_ROOT_FOLDER);
        if (null != root) {
            FileObject[] children = root.getChildren();
            for (int i = 0; i < children.length; ++i) {
                FileObject contentFile = children[i];
                if (!contentFile.canRead() || !contentFile.isData()) continue;
                this.parse(contentFile.getInputStream());
            }
        }
    }

    public void parseLocal() throws ParserConfigurationException, SAXException, IOException {
        String layoutFilePath = BundleSupport.getURL("Layout");
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (null == loader) {
            loader = ClassLoader.getSystemClassLoader();
        }
        this.parse(loader.getResourceAsStream(layoutFilePath));
    }

    private void parse(InputStream input) throws ParserConfigurationException, SAXException, IOException {
        XMLReader reader = XMLUtil.createXMLReader((boolean)false, (boolean)false);
        reader.setContentHandler(this);
        reader.parse(new InputSource(input));
    }

    public ComponentDescriptor[] getContents() {
        ComponentDescriptor[] res = new ComponentDescriptor[this.contentIds.size()];
        int index = 0;
        Iterator i = this.contentIds.iterator();
        while (i.hasNext()) {
            res[index] = (ComponentDescriptor)this.descriptors.get(i.next());
            ++index;
        }
        return res;
    }

    public BackgroundPainter getBackgroundPainter() {
        BackgroundPainter painter = null;
        if (null != this.backgroundPainterClassName) {
            ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (null == loader) {
                loader = ClassLoader.getSystemClassLoader();
            }
            try {
                Class<?> clazz = Class.forName(this.backgroundPainterClassName, true, loader);
                painter = (BackgroundPainter)clazz.newInstance();
            }
            catch (Throwable e) {
                ErrorManager.getDefault().notify(1, e);
            }
        }
        return painter;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(ELEM_ROOT)) {
            String version = attributes.getValue("version");
            if (!CURRENT_VERSION.equals(version)) {
                throw new SAXParseException("Unsupported file version", null);
            }
        } else if (qName.equals(ELEM_BACKGROUND)) {
            this.backgroundPainterClassName = attributes.getValue("class");
        } else if (qName.equals(ELEM_PANEL)) {
            String id = attributes.getValue("id");
            if (null == id) {
                throw new SAXParseException("Required attribute missing: id", null);
            }
            String className = attributes.getValue("class");
            String method = attributes.getValue("method");
            if (null == className && method == null) {
                throw new SAXParseException("Either class or method attribute must be specified", null);
            }
            ComponentDescriptor descriptor = (ComponentDescriptor)this.descriptors.get(id);
            if (null == descriptor) {
                descriptor = new DefaultComponentDescriptor(id);
                this.descriptors.put(id, descriptor);
            }
            descriptor.setClassName(className);
            descriptor.setMethod(method);
            this.currentDescriptor = descriptor;
            if (!this.contentIds.contains(id)) {
                this.contentIds.add(id);
            }
        } else if (qName.equals(ELEM_CONSTRAINTS)) {
            if (null == this.currentDescriptor) {
                throw new SAXParseException("Unexpected element: constraints", null);
            }
            this.currentDescriptor.setConstraints(this.parseConstraints(attributes, this.currentDescriptor.getConstraints()));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals(ELEM_PANEL)) {
            this.currentDescriptor = null;
        }
    }

    private GridBagConstraints parseConstraints(Attributes attrs, GridBagConstraints defaults) {
        Integer intValue;
        String fill;
        Integer intValue2;
        GridBagConstraints res = defaults;
        if (null == res) {
            res = new GridBagConstraints();
        }
        res.gridx = this.parseInt(attrs, "gridx", 0, 100, res.gridx);
        res.gridy = this.parseInt(attrs, "gridy", 0, 100, res.gridy);
        res.gridwidth = this.parseInt(attrs, "gridwidth", 0, 100, res.gridwidth);
        res.gridheight = this.parseInt(attrs, "gridheight", 0, 100, res.gridheight);
        res.weightx = this.parseDouble(attrs, "weightx", 0.0, 1.0, res.weightx);
        res.weighty = this.parseDouble(attrs, "weighty", 0.0, 1.0, res.weighty);
        res.insets.left = this.parseInt(attrs, "insetsleft", 0, 1000, res.insets.left);
        res.insets.right = this.parseInt(attrs, "insetsright", 0, 1000, res.insets.right);
        res.insets.top = this.parseInt(attrs, "insetstop", 0, 1000, res.insets.top);
        res.insets.bottom = this.parseInt(attrs, "insetsbottom", 0, 1000, res.insets.bottom);
        String anchor = attrs.getValue("anchor");
        if (null != anchor && null != (intValue2 = (Integer)this.anchors.get(anchor = anchor.toUpperCase()))) {
            res.anchor = intValue2;
        }
        if (null != (fill = attrs.getValue("fill")) && null != (intValue = (Integer)this.fills.get(fill = fill.toUpperCase()))) {
            res.fill = intValue;
        }
        res.ipadx = this.parseInt(attrs, "padx", 0, 100, res.ipadx);
        res.ipady = this.parseInt(attrs, "pady", 0, 100, res.ipady);
        return res;
    }

    private int parseInt(Attributes attrs, String name, int min, int max, int defaultValue) {
        int res = defaultValue;
        String str = attrs.getValue(name);
        if (null != str) {
            try {
                res = Integer.parseInt(str);
            }
            catch (NumberFormatException nfE) {
                // empty catch block
            }
            if (res < min) {
                res = min;
            }
            if (res > max) {
                res = max;
            }
        }
        return res;
    }

    private double parseDouble(Attributes attrs, String name, double min, double max, double defaultValue) {
        double res = defaultValue;
        String str = attrs.getValue(name);
        if (null != str) {
            try {
                res = Double.parseDouble(str);
            }
            catch (NumberFormatException nfE) {
                // empty catch block
            }
            if (res < min) {
                res = min;
            }
            if (res > max) {
                res = max;
            }
        }
        return res;
    }
}

