/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.netbeans.modules.tasklist.core.filter.OneOfFilterCondition;
import org.netbeans.modules.tasklist.core.filter.Util;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IntegerFilterCondition
extends OneOfFilterCondition {
    public static final int EQUALS = 0;
    public static final int NOTEQUALS = 1;
    public static final int LESSTHAN = 2;
    public static final int LESSOREQUALS = 3;
    public static final int GREATERTHAN = 4;
    public static final int GREATEROREQUALS = 5;
    private static String[] NAME_KEYS = new String[]{"Equals", "NotEquals", "LessThan", "LessEquals", "GreaterThan", "GreaterEquals"};
    private int constant;

    public static IntegerFilterCondition[] createConditions() {
        return new IntegerFilterCondition[]{new IntegerFilterCondition(0), new IntegerFilterCondition(1), new IntegerFilterCondition(2), new IntegerFilterCondition(3), new IntegerFilterCondition(4), new IntegerFilterCondition(5)};
    }

    public IntegerFilterCondition(int id) {
        super(NAME_KEYS, id);
    }

    public IntegerFilterCondition(IntegerFilterCondition rhs) {
        super(rhs);
        this.constant = rhs.constant;
    }

    public Object clone() {
        return new IntegerFilterCondition(this);
    }

    private IntegerFilterCondition() {
        super(NAME_KEYS);
        this.constant = -1;
    }

    public JComponent createConstantComponent() {
        JTextField tf = new JTextField();
        tf.setText(String.valueOf(this.constant));
        tf.setToolTipText(Util.getString("int_desc"));
        return tf;
    }

    public void getConstantFrom(JComponent cmp) {
        JTextField tf = (JTextField)cmp;
        try {
            this.constant = Integer.parseInt(tf.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean isTrue(Object obj) {
        int n = (Integer)obj;
        switch (this.getId()) {
            case 0: {
                return this.constant == n;
            }
            case 1: {
                return this.constant != n;
            }
            case 2: {
                return n < this.constant;
            }
            case 3: {
                return n <= this.constant;
            }
            case 4: {
                return n > this.constant;
            }
            case 5: {
                return n >= this.constant;
            }
        }
        throw new InternalError("wrong id");
    }

    private static class Convertor
    extends OneOfFilterCondition.Convertor {
        private static final String ELEM_INTEGER_CONDITION = "IntegerCondition";
        private static final String ATTR_CONSTANT = "constant";

        public Convertor() {
            super(ELEM_INTEGER_CONDITION, NAME_KEYS);
        }

        public static Convertor create() {
            return new Convertor();
        }

        protected Object readElement(Element element) throws IOException, ClassNotFoundException {
            IntegerFilterCondition cond = new IntegerFilterCondition();
            super.readCondition(element, cond);
            cond.constant = Integer.parseInt(element.getAttribute(ATTR_CONSTANT));
            return cond;
        }

        protected void writeElement(Document document, Element element, Object obj) throws IOException, DOMException {
            IntegerFilterCondition cond = (IntegerFilterCondition)obj;
            super.writeCondition(document, element, cond);
            element.setAttribute(ATTR_CONSTANT, Integer.toString(cond.constant));
        }
    }
}

