/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Caret;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DrawEngine;
import org.netbeans.editor.DrawEngineDocView;
import org.netbeans.editor.DrawEngineLineView;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.view.spi.LockView;

public class BaseTextUI
extends BasicTextUI
implements PropertyChangeListener,
DocumentListener,
SettingsChangeListener {
    private EditorUI editorUI;
    private boolean foldingEnabled;
    private boolean needsRefresh = false;
    int componentID = -1;
    private AbstractDocument lastDocument;
    private static final GetFocusedComponentAction gfcAction = new GetFocusedComponentAction();
    static /* synthetic */ Class class$org$netbeans$editor$DrawEngine$PreinitializedDrawEngine;

    protected String getPropertyPrefix() {
        return "EditorPane";
    }

    public static JTextComponent getFocusedComponent() {
        return gfcAction.getFocusedComponent2();
    }

    protected boolean isRootViewReplaceNecessary() {
        boolean replaceNecessary = false;
        Document doc = this.getComponent().getDocument();
        if (doc != this.lastDocument) {
            replaceNecessary = true;
        }
        return replaceNecessary;
    }

    protected void rootViewReplaceNotify() {
        this.lastDocument = (AbstractDocument)this.getComponent().getDocument();
    }

    protected void modelChanged() {
        JTextComponent component = this.getComponent();
        Document doc = component.getDocument();
        if (doc != null && !(doc instanceof AbstractDocument)) {
            return;
        }
        AbstractDocument adoc = (AbstractDocument)doc;
        if (doc != null) {
            ViewFactory f = this.getRootView(component).getViewFactory();
            BaseKit kit = (BaseKit)this.getEditorKit(component);
            component.removeAll();
            if (this.isRootViewReplaceNecessary()) {
                this.rootViewReplaceNotify();
                Element elem = doc.getDefaultRootElement();
                View v = f.create(elem);
                this.setView(v);
            }
            component.revalidate();
            Settings.KitAndValue[] kv = Settings.getValueHierarchy(kit.getClass(), "doc-install-action-name-list");
            for (int i = kv.length - 1; i >= 0; --i) {
                List actList = (List)kv[i].value;
                if ((actList = kit.translateActionNameList(actList)) == null) continue;
                Iterator iter = actList.iterator();
                while (iter.hasNext()) {
                    Action a = (Action)iter.next();
                    a.actionPerformed(new ActionEvent(component, 1001, ""));
                }
            }
        }
    }

    protected void installKeyboardActions() {
        String mapName = this.getPropertyPrefix() + ".actionMap";
        UIManager.getLookAndFeelDefaults().put(mapName, (Object)null);
        UIManager.getDefaults().put(mapName, (Object)null);
        super.installKeyboardActions();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (!(c instanceof JTextComponent)) {
            return;
        }
        JTextComponent component = this.getComponent();
        Object value = Settings.getValue(Utilities.getKitClass(component), "margin");
        Insets margin = value instanceof Insets ? (Insets)value : null;
        component.setMargin(margin);
        this.getEditorUI().installUI(component);
        Boolean foldingEnabledBoolean = (Boolean)Settings.getValue(Utilities.getKitClass(component), "code-folding-enable");
        this.foldingEnabled = foldingEnabledBoolean;
        component.putClientProperty("code-folding-enable", foldingEnabledBoolean);
        Settings.addSettingsChangeListener(this);
        if (component.getClientProperty(UIWatcher.class) == null) {
            UIWatcher uiWatcher = new UIWatcher(this.getClass());
            component.addPropertyChangeListener(uiWatcher);
            component.putClientProperty(UIWatcher.class, uiWatcher);
        }
        BaseKit kit = (BaseKit)this.getEditorKit(component);
        ViewFactory vf = kit.getViewFactory();
        Caret caret = kit.createCaret();
        component.setCaretColor(Color.black);
        component.setCaret(caret);
        int br = SettingsUtil.getInteger(Utilities.getKitClass(component), "caret-blink-rate", (int)SettingsDefaults.defaultCaretBlinkRate);
        caret.setBlinkRate(br);
        SwingUtilities.replaceUIInputMap(c, 0, null);
        Registry.addComponent(component);
        Registry.activate(component);
        component.setCursor(Cursor.getPredefinedCursor(2));
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        Settings.removeSettingsChangeListener(this);
        if (c instanceof JTextComponent) {
            JTextComponent comp = (JTextComponent)c;
            BaseDocument doc = Utilities.getDocument(comp);
            if (doc != null) {
                doc.removeDocumentListener(this);
            }
            comp.setKeymap(null);
            comp.setCaret(null);
            this.getEditorUI().uninstallUI(comp);
            Registry.removeComponent(comp);
        }
        this.editorUI = null;
    }

    public int getYFromPos(int pos) throws BadLocationException {
        Rectangle ret = this.modelToView(this.getComponent(), pos);
        return ret == null ? 0 : ret.y;
    }

    public int getPosFromY(int y) throws BadLocationException {
        return this.viewToModel(this.getComponent(), 0, y);
    }

    public int getBaseX(int y) {
        return this.getEditorUI().getTextMargin().left;
    }

    public int viewToModel(JTextComponent c, int x, int y) {
        return this.viewToModel(c, new Point(x, y));
    }

    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        if (biasRet == null) {
            biasRet = new Position.Bias[]{Position.Bias.Forward};
        }
        return super.getNextVisualPositionFrom(t, pos, b, direction, biasRet);
    }

    public EditorKit getEditorKit(JTextComponent c) {
        JEditorPane pane = (JEditorPane)this.getComponent();
        return pane == null ? null : pane.getEditorKit();
    }

    public EditorUI getEditorUI() {
        if (this.editorUI == null) {
            JTextComponent c = this.getComponent();
            BaseKit kit = (BaseKit)this.getEditorKit(c);
            this.editorUI = kit.createEditorUI();
            this.editorUI.initLineHeight(c);
        }
        return this.editorUI;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        JTextComponent comp;
        String propName = evt.getPropertyName();
        if ("document".equals(propName)) {
            BaseDocument newDoc;
            BaseDocument oldDoc;
            BaseDocument baseDocument = oldDoc = evt.getOldValue() instanceof BaseDocument ? (BaseDocument)evt.getOldValue() : null;
            if (oldDoc != null) {
                oldDoc.removeDocumentListener(this);
            }
            BaseDocument baseDocument2 = newDoc = evt.getNewValue() instanceof BaseDocument ? (BaseDocument)evt.getNewValue() : null;
            if (newDoc != null) {
                newDoc.addDocumentListener(this);
                Registry.activate(newDoc);
            }
        } else if ("ancestor".equals(propName) && (comp = (JTextComponent)evt.getSource()).isDisplayable() && this.editorUI != null && this.editorUI.hasExtComponent() && !Boolean.TRUE.equals(comp.getClientProperty("ancestorOverride"))) {
            comp.putClientProperty("ancestorOverride", Boolean.TRUE);
        }
    }

    public void insertUpdate(DocumentEvent evt) {
        try {
            BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
            EditorUI editorUI = this.getEditorUI();
            int y = this.getYFromPos(evt.getOffset());
            int lineHeight = editorUI.getLineHeight();
            int syntaxY = this.getYFromPos(bevt.getSyntaxUpdateOffset());
            if (bevt.getSyntaxUpdateOffset() == evt.getDocument().getLength()) {
                syntaxY += lineHeight;
            }
            if (this.getComponent().isShowing()) {
                editorUI.repaint(y, Math.max(lineHeight, syntaxY - y));
            }
        }
        catch (BadLocationException ex) {
            Utilities.annotateLoggable(ex);
        }
    }

    public void removeUpdate(DocumentEvent evt) {
        try {
            BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
            EditorUI editorUI = this.getEditorUI();
            int y = this.getYFromPos(evt.getOffset());
            int lineHeight = editorUI.getLineHeight();
            int syntaxY = this.getYFromPos(bevt.getSyntaxUpdateOffset());
            if (bevt.getSyntaxUpdateOffset() == evt.getDocument().getLength()) {
                syntaxY += lineHeight;
            }
            if (this.getComponent().isShowing()) {
                editorUI.repaint(y, Math.max(lineHeight, syntaxY - y));
            }
        }
        catch (BadLocationException ex) {
            Utilities.annotateLoggable(ex);
        }
    }

    public void changedUpdate(DocumentEvent evt) {
        if (evt instanceof BaseDocumentEvent) {
            BaseDocumentEvent bdevt = (BaseDocumentEvent)evt;
            BaseDocument doc = (BaseDocument)bdevt.getDocument();
            String layerName = bdevt.getDrawLayerName();
            if (layerName != null) {
                this.getEditorUI().addLayer(doc.findLayer(layerName), bdevt.getDrawLayerVisibility());
            } else {
                try {
                    JTextComponent comp = this.getComponent();
                    if (comp != null && comp.isShowing()) {
                        this.getEditorUI().repaintBlock(evt.getOffset(), evt.getOffset() + evt.getLength());
                    }
                }
                catch (BadLocationException ex) {
                    Utilities.annotateLoggable(ex);
                }
            }
        }
    }

    public View create(Element elem) {
        String kind = elem.getName();
        if (kind != null) {
            if (kind.equals("content")) {
                return new LabelView(elem);
            }
            if (kind.equals("paragraph")) {
                return new DrawEngineLineView(elem);
            }
            if (kind.equals("section")) {
                return new LockView(new DrawEngineDocView(elem));
            }
            if (kind.equals("component")) {
                return new ComponentView(elem);
            }
            if (kind.equals("icon")) {
                return new IconView(elem);
            }
        }
        return new DrawEngineLineView(elem);
    }

    public View create(Element elem, int p0, int p1) {
        return null;
    }

    public void preferenceChanged(boolean width, boolean height) {
        this.modelChanged();
    }

    public void invalidateStartY() {
    }

    public void settingsChange(SettingsChangeEvent evt) {
        JTextComponent component = this.getComponent();
        if (component == null) {
            return;
        }
        if (evt == null || Utilities.getKitClass(component) != evt.getKitClass()) {
            return;
        }
        if ("code-folding-enable".equals(evt.getSettingName())) {
            Boolean foldingEnabledBoolean = (Boolean)Settings.getValue(evt.getKitClass(), "code-folding-enable");
            this.foldingEnabled = foldingEnabledBoolean;
            component.putClientProperty("code-folding-enable", foldingEnabledBoolean);
            this.needsRefresh = true;
            Utilities.runInEventDispatchThread(new Runnable(){

                public void run() {
                    BaseTextUI.this.refresh();
                }
            });
        }
    }

    boolean isFoldingEnabled() {
        return this.foldingEnabled;
    }

    protected void refresh() {
        if (this.getComponent().isShowing() && this.needsRefresh) {
            this.modelChanged();
            this.needsRefresh = false;
        }
    }

    static void uninstallUIWatcher(JTextComponent c) {
        UIWatcher uiWatcher = (UIWatcher)c.getClientProperty(UIWatcher.class);
        if (uiWatcher != null) {
            c.removePropertyChangeListener(uiWatcher);
            c.putClientProperty(UIWatcher.class, null);
        }
    }

    static class UIWatcher
    implements PropertyChangeListener {
        private Class uiClass;

        UIWatcher(Class uiClass) {
            this.uiClass = uiClass;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            JTextComponent c;
            EditorKit kit;
            Object newValue = evt.getNewValue();
            if ("UI".equals(evt.getPropertyName()) && newValue != null && !(newValue instanceof BaseTextUI) && (kit = ((TextUI)newValue).getEditorKit(c = (JTextComponent)evt.getSource())) instanceof BaseKit) {
                try {
                    c.setUI((BaseTextUI)this.uiClass.newInstance());
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
    }

    class EditorUIBoxView
    extends BoxView {
        public EditorUIBoxView(Element elem, int axis) {
            super(elem, axis);
        }

        private DrawEngine.PreinitializedDrawEngine getPreinitializedDrawEngine(Graphics g) {
            DrawEngine.PreinitializedDrawEngine drawEngine = null;
            Rectangle clip = g.getClipBounds();
            if (clip.height <= 0 || clip.width < 0) {
                return null;
            }
            int clipY = clip.y;
            int clipHeight = clip.height;
            int paintY = Math.max(clipY, 0);
            BaseDocument doc = BaseTextUI.this.getEditorUI().getDocument();
            try {
                int startPos = BaseTextUI.this.getPosFromY(paintY);
                int pos = BaseTextUI.this.getPosFromY(clipY + clipHeight - 1);
                int endPos = Utilities.getRowEnd(doc, pos);
                int startOffset = startPos;
                int endOffset = endPos;
                int y = BaseTextUI.this.getYFromPos(startOffset);
                if (endOffset > startOffset) {
                    drawEngine = DrawEngine.getDrawEngine().getDrawEngine(this, new DrawGraphics.GraphicsDG(g), BaseTextUI.this.getEditorUI(), startOffset, endOffset, BaseTextUI.this.getBaseX(y), y, Integer.MAX_VALUE);
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            return drawEngine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics g, Shape allocation) {
            block6: {
                super.paint(g, allocation);
                DrawEngine.PreinitializedDrawEngine pde = null;
                JTextComponent component = BaseTextUI.this.getComponent();
                try {
                    pde = this.getPreinitializedDrawEngine(g);
                    if (component != null) {
                        component.putClientProperty(class$org$netbeans$editor$DrawEngine$PreinitializedDrawEngine == null ? (class$org$netbeans$editor$DrawEngine$PreinitializedDrawEngine = BaseTextUI.class$("org.netbeans.editor.DrawEngine$PreinitializedDrawEngine")) : class$org$netbeans$editor$DrawEngine$PreinitializedDrawEngine, pde);
                    }
                    BaseTextUI.this.getEditorUI().paint(g);
                    if (pde != null) {
                        pde.release();
                    }
                    if (component == null) break block6;
                    component.putClientProperty(class$org$netbeans$editor$DrawEngine$PreinitializedDrawEngine == null ? (class$org$netbeans$editor$DrawEngine$PreinitializedDrawEngine = BaseTextUI.class$("org.netbeans.editor.DrawEngine$PreinitializedDrawEngine")) : class$org$netbeans$editor$DrawEngine$PreinitializedDrawEngine, null);
                }
                catch (Throwable throwable) {
                    if (pde != null) {
                        pde.release();
                    }
                    if (component != null) {
                        component.putClientProperty(class$org$netbeans$editor$DrawEngine$PreinitializedDrawEngine == null ? (class$org$netbeans$editor$DrawEngine$PreinitializedDrawEngine = BaseTextUI.class$("org.netbeans.editor.DrawEngine$PreinitializedDrawEngine")) : class$org$netbeans$editor$DrawEngine$PreinitializedDrawEngine, null);
                    }
                    throw throwable;
                }
            }
        }
    }

    private static class GetFocusedComponentAction
    extends TextAction {
        private GetFocusedComponentAction() {
            super("get-focused-component");
        }

        public void actionPerformed(ActionEvent evt) {
        }

        JTextComponent getFocusedComponent2() {
            return super.getFocusedComponent();
        }
    }
}

