/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.View;
import org.netbeans.editor.Analyzer;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DocumentUtilities;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawGraphics;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.MarkVector;
import org.netbeans.editor.MultiMark;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;

class DrawEngine {
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.draw");
    private static final boolean debugFragment = Boolean.getBoolean("netbeans.debug.editor.draw.fragment");
    private static DrawEngine drawEngine;
    private static final char[] SPACE;

    private DrawEngine() {
    }

    public static DrawEngine getDrawEngine() {
        if (drawEngine == null) {
            drawEngine = new DrawEngine();
        }
        return drawEngine;
    }

    public PreinitializedDrawEngine getDrawEngine(View view, DrawGraphics drawGraphics, EditorUI editorUI, int startOffset, int endOffset, int startX, int startY, int targetOffset) throws BadLocationException {
        if (startOffset < 0 || endOffset < 0 || startOffset > endOffset || startX < 0 || startY < 0) {
            return null;
        }
        BaseDocument doc = (BaseDocument)(view != null ? view.getDocument() : editorUI.getDocument());
        PreinitializedDrawEngine preinitializedDrawEngine = new PreinitializedDrawEngine(drawGraphics);
        preinitializedDrawEngine.preinitialize(doc, editorUI, startOffset, endOffset, startX, startY, targetOffset);
        return preinitializedDrawEngine;
    }

    private void initLineNumbering(DrawInfo ctx) {
        boolean bl = ctx.lineNumbering = ctx.editorUI.lineNumberVisible && ctx.drawGraphics.supportsLineNumbers();
        if (ctx.lineNumbering) {
            Color lnForeColor;
            Color lnBackColor;
            try {
                ctx.startLineNumber = Utilities.getLineOffset(ctx.doc, ctx.startOffset) + 1;
            }
            catch (BadLocationException e) {
                Utilities.annotateLoggable(e);
            }
            ctx.lineNumberColoring = ctx.editorUI.getColoring("line-number");
            ctx.lineNumberColoring = ctx.lineNumberColoring == null ? ctx.defaultColoring : ctx.lineNumberColoring.apply(ctx.defaultColoring);
            Font lnFont = ctx.lineNumberColoring.getFont();
            if (lnFont == null) {
                lnFont = ctx.defaultColoring.getFont();
            }
            if ((lnBackColor = ctx.lineNumberColoring.getBackColor()) == null) {
                lnBackColor = ctx.defaultColoring.getBackColor();
            }
            if ((lnForeColor = ctx.lineNumberColoring.getForeColor()) == null) {
                lnForeColor = ctx.defaultColoring.getForeColor();
            }
            ctx.lineNumberChars = new char[Math.max(ctx.editorUI.lineNumberMaxDigitCount, 1)];
            if (ctx.graphics == null) {
                ctx.syncedLineNumbering = true;
            } else {
                try {
                    int endLineNumber = Utilities.getLineOffset(ctx.doc, ctx.endOffset) + 1;
                    ctx.lineStartOffsets = new int[endLineNumber - ctx.startLineNumber + 2];
                }
                catch (BadLocationException e) {
                    Utilities.annotateLoggable(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initInfo(DrawInfo ctx) throws BadLocationException {
        ctx.x = ctx.startX;
        ctx.y = ctx.startY;
        ctx.lineHeight = ctx.editorUI.getLineHeight();
        ctx.defaultColoring = ctx.editorUI.getDefaultColoring();
        ctx.tabSize = ctx.doc.getTabSize();
        ctx.fragmentOffset = ctx.startOffset;
        ctx.graphics = ctx.drawGraphics.getGraphics();
        if (ctx.graphics != null && ctx.editorUI.renderingHints != null) {
            ((Graphics2D)ctx.graphics).setRenderingHints(ctx.editorUI.renderingHints);
        }
        this.initLineNumbering(ctx);
        ctx.foreColor = ctx.defaultColoring.getForeColor();
        ctx.backColor = ctx.defaultColoring.getBackColor();
        ctx.font = ctx.defaultColoring.getFont();
        ctx.bol = true;
        ctx.drawGraphics.init(ctx);
        ctx.drawGraphics.setDefaultBackColor(ctx.defaultColoring.getBackColor());
        ctx.drawGraphics.setLineHeight(ctx.lineHeight);
        ctx.drawGraphics.setLineAscent(ctx.editorUI.getLineAscent());
        ctx.drawGraphics.setX(ctx.x);
        ctx.drawGraphics.setY(ctx.y);
        ctx.layers = ctx.editorUI.getDrawLayerList().currentLayers();
        int layersLength = ctx.layers.length;
        ctx.layerActives = new boolean[layersLength];
        ctx.layerActivityChangeOffsets = new int[layersLength];
        for (int i = 0; i < layersLength; ++i) {
            ctx.layers[i].init(ctx);
        }
        ctx.drawMarkList = new ArrayList();
        Map docMarks = ctx.doc.marks;
        MarkVector docMarksStorage = ctx.doc.marksStorage;
        Map map = docMarks;
        synchronized (map) {
            int offset = ctx.startOffset;
            int low = 0;
            int markCount = docMarksStorage.getMarkCount();
            int high = markCount - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                int cmp = docMarksStorage.getMarkOffsetInternal(mid) - offset;
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                while (--mid >= 0 && docMarksStorage.getMarkOffsetInternal(mid) == offset) {
                }
                low = mid + 1;
                break;
            }
            offset = ctx.endOffset;
            while (low < markCount) {
                MultiMark m = docMarksStorage.getMark(low);
                if (m.isValid()) {
                    if (m.getOffset() > offset) break;
                    Mark mark = (Mark)docMarks.get(m);
                    if (mark == null) {
                        throw new IllegalStateException("No mark for m=" + m);
                    }
                    if (mark instanceof MarkFactory.DrawMark) {
                        ctx.drawMarkList.add(mark);
                    }
                }
                ++low;
            }
        }
        ctx.drawMarkIndex = 0;
        ctx.drawMarkOffset = Integer.MAX_VALUE;
        if (ctx.drawMarkList.size() > 0) {
            ctx.drawMark = (MarkFactory.DrawMark)ctx.drawMarkList.get(ctx.drawMarkIndex++);
            try {
                ctx.drawMarkOffset = ctx.drawMark.getOffset();
            }
            catch (InvalidMarkException e) {
                throw new IllegalStateException(e.toString());
            }
            if (ctx.drawMarkOffset < ctx.updateOffset) {
                ctx.updateOffset = ctx.drawMarkOffset;
                ctx.drawMarkUpdate = true;
            }
        }
        int endTokenSafeOffset = ctx.doc.getTokenSafeOffset(ctx.endOffset);
        ctx.doc.prepareSyntax(ctx.text, ctx.syntax, ctx.startOffset, endTokenSafeOffset - ctx.startOffset, false, false);
        ctx.textArray = ctx.text.array;
        ctx.buffer = ctx.textArray;
        ctx.bufferStartOffset = ctx.startOffset - ctx.syntax.getOffset();
        ctx.drawGraphics.setBuffer(ctx.textArray);
        if (ctx.drawGraphics instanceof DrawGraphics.GraphicsDG) {
            ((DrawGraphics.GraphicsDG)ctx.drawGraphics).setBufferStartOffset(ctx.bufferStartOffset);
        }
        ctx.continueDraw = true;
    }

    private void handleBOL(DrawInfo ctx) {
        if (ctx.lineNumbering) {
            if (ctx.syncedLineNumbering) {
                int i;
                ctx.foreColor = ctx.lineNumberColoring.getForeColor();
                ctx.backColor = ctx.lineNumberColoring.getBackColor();
                ctx.font = ctx.lineNumberColoring.getFont();
                ctx.strikeThroughColor = null;
                ctx.underlineColor = null;
                ctx.waveUnderlineColor = null;
                int lineNumber = ctx.startLineNumber + ctx.lineIndex;
                int layersLength = ctx.layers.length;
                for (i = 0; i < layersLength; ++i) {
                    lineNumber = ctx.layers[i].updateLineNumberContext(lineNumber, ctx);
                }
                i = Math.max(ctx.lineNumberChars.length - 1, 0);
                do {
                    ctx.lineNumberChars[i--] = (char)(48 + lineNumber % 10);
                } while ((lineNumber /= 10) != 0 && i >= 0);
                while (i >= 0) {
                    ctx.lineNumberChars[i--] = 32;
                }
                int numX = ctx.x - ctx.editorUI.lineNumberWidth;
                if (ctx.editorUI.getLineNumberMargin() != null) {
                    numX += ctx.editorUI.getLineNumberMargin().left;
                }
                ctx.drawGraphics.setX(numX);
                ctx.drawGraphics.setBuffer(ctx.lineNumberChars);
                ctx.drawGraphics.setForeColor(ctx.foreColor);
                ctx.drawGraphics.setBackColor(ctx.backColor);
                ctx.drawGraphics.setStrikeThroughColor(ctx.strikeThroughColor);
                ctx.drawGraphics.setUnderlineColor(ctx.underlineColor);
                ctx.drawGraphics.setWaveUnderlineColor(ctx.waveUnderlineColor);
                ctx.drawGraphics.setFont(ctx.font);
                ctx.drawGraphics.drawChars(0, ctx.lineNumberChars.length, ctx.editorUI.lineNumberWidth);
                if (ctx.drawGraphics.getGraphics() == null) {
                    ctx.drawGraphics.setBuffer(SPACE);
                    ctx.drawGraphics.drawChars(0, 1, ctx.editorUI.lineNumberDigitWidth);
                }
                ctx.drawGraphics.setX(ctx.x);
                ctx.drawGraphics.setBuffer(ctx.textArray);
            } else {
                ctx.lineStartOffsets[ctx.lineIndex] = ctx.fragmentOffset;
            }
        }
        ++ctx.lineIndex;
    }

    private void handleEOL(DrawInfo ctx) {
        ctx.drawGraphics.setX(ctx.x);
        ctx.drawGraphics.setY(ctx.y);
        ctx.drawGraphics.eol();
        ctx.widestWidth = Math.max(ctx.widestWidth, ctx.x);
        ctx.visualColumn = 0;
        ctx.x = ctx.startX;
        ctx.y += ctx.lineHeight;
        ctx.drawGraphics.setX(ctx.x);
        ctx.drawGraphics.setY(ctx.y);
    }

    private void updateOffsetReached(DrawInfo ctx) {
        if (ctx.drawMarkUpdate) {
            int layersLength = ctx.layers.length;
            for (int i = 0; i < layersLength; ++i) {
                int naco;
                DrawLayer l = ctx.layers[i];
                if (!l.getName().equals(ctx.drawMark.layerName) || !ctx.drawMark.isDocumentMark() && ctx.editorUI != ctx.drawMark.getEditorUI()) continue;
                ctx.layerActives[i] = l.isActive(ctx, ctx.drawMark);
                ctx.layerActivityChangeOffsets[i] = naco = l.getNextActivityChangeOffset(ctx);
                if (naco <= ctx.fragmentOffset || naco >= ctx.layerUpdateOffset) continue;
                ctx.layerUpdateOffset = naco;
            }
            if (ctx.drawMarkIndex < ctx.drawMarkList.size()) {
                ctx.drawMark = (MarkFactory.DrawMark)ctx.drawMarkList.get(ctx.drawMarkIndex++);
                try {
                    ctx.drawMarkOffset = ctx.drawMark.getOffset();
                }
                catch (InvalidMarkException e) {
                    throw new IllegalStateException(e.toString());
                }
            } else {
                ctx.drawMark = null;
                ctx.drawMarkOffset = Integer.MAX_VALUE;
            }
        } else {
            ctx.layerUpdateOffset = Integer.MAX_VALUE;
            int layersLength = ctx.layers.length;
            for (int i = 0; i < layersLength; ++i) {
                int naco = ctx.layerActivityChangeOffsets[i];
                if (naco == ctx.fragmentOffset) {
                    DrawLayer l = ctx.layers[i];
                    ctx.layerActives[i] = l.isActive(ctx, null);
                    ctx.layerActivityChangeOffsets[i] = naco = l.getNextActivityChangeOffset(ctx);
                }
                if (naco <= ctx.fragmentOffset || naco >= ctx.layerUpdateOffset) continue;
                ctx.layerUpdateOffset = naco;
            }
        }
        if (ctx.drawMarkOffset < ctx.layerUpdateOffset) {
            ctx.drawMarkUpdate = true;
            ctx.updateOffset = ctx.drawMarkOffset;
        } else {
            ctx.drawMarkUpdate = false;
            ctx.updateOffset = ctx.layerUpdateOffset;
        }
    }

    private void computeFragmentLength(DrawInfo ctx) {
        ctx.fragmentStartIndex = ctx.fragmentOffset - ctx.bufferStartOffset;
        ctx.fragmentLength = Math.min(ctx.updateOffset - ctx.fragmentOffset, ctx.tokenLength - ctx.drawnLength);
        int stopIndex = Analyzer.findFirstTabOrLF(ctx.textArray, ctx.fragmentStartIndex, ctx.fragmentLength);
        ctx.eol = ctx.fragmentOffset == ctx.docLen;
        ctx.tabsFragment = false;
        if (stopIndex >= 0) {
            if (stopIndex == ctx.fragmentStartIndex) {
                if (ctx.textArray[stopIndex] == '\t') {
                    ctx.tabsFragment = true;
                    int ntInd = Analyzer.findFirstNonTab(ctx.textArray, ctx.fragmentStartIndex, ctx.fragmentLength);
                    if (ntInd != -1) {
                        ctx.fragmentLength = ntInd - ctx.fragmentStartIndex;
                    }
                } else {
                    ctx.eol = true;
                    ctx.fragmentLength = 1;
                }
            } else {
                ctx.fragmentLength = stopIndex - ctx.fragmentStartIndex;
            }
        }
    }

    private void computeFragmentDisplayWidth(DrawInfo ctx) {
        if (!ctx.eol) {
            int layersLength = ctx.layers.length;
            for (int i = 0; i < layersLength; ++i) {
                if (!ctx.layerActives[i]) continue;
                ctx.layers[i].updateContext(ctx);
            }
        }
        FontMetricsCache.Info fmcInfo = FontMetricsCache.getInfo(ctx.font);
        ctx.spaceWidth = ctx.component != null ? fmcInfo.getSpaceWidth(ctx.component) : ctx.editorUI.defaultSpaceWidth;
        ctx.fragmentCharCount = ctx.fragmentLength;
        if (ctx.tabsFragment) {
            ctx.fragmentCharCount = Analyzer.getColumn(ctx.textArray, ctx.fragmentStartIndex, ctx.fragmentLength, ctx.tabSize, ctx.visualColumn) - ctx.visualColumn;
            ctx.fragmentWidth = ctx.fragmentCharCount * ctx.spaceWidth;
        } else {
            ctx.fragmentWidth = ctx.eol ? ctx.spaceWidth : (ctx.fragmentLength > 0 ? (ctx.component != null ? FontMetricsCache.getFontMetrics(ctx.font, ctx.component).charsWidth(ctx.textArray, ctx.fragmentStartIndex, ctx.fragmentLength) : ctx.fragmentLength * ctx.spaceWidth) : 0);
        }
    }

    private void drawFragment(DrawInfo ctx) {
        if (ctx.eol) {
            int layersLength = ctx.layers.length;
            boolean emptyLine = false;
            int blankWidth = ctx.fragmentWidth;
            do {
                blankWidth = 0;
                if (ctx.bol) {
                    if (!emptyLine) {
                        for (int i = 0; i < layersLength; ++i) {
                            DrawLayer l;
                            if (!ctx.layerActives[i] || !(l = ctx.layers[i]).extendsEmptyLine()) continue;
                            emptyLine = true;
                            l.updateContext(ctx);
                        }
                        if (emptyLine) {
                            blankWidth = ctx.spaceWidth / 2;
                        }
                    } else {
                        emptyLine = false;
                    }
                }
                if (!emptyLine) {
                    boolean extendEOL = false;
                    for (int i = 0; i < layersLength; ++i) {
                        DrawLayer l;
                        if (!ctx.layerActives[i] || !(l = ctx.layers[i]).extendsEOL()) continue;
                        extendEOL = true;
                        l.updateContext(ctx);
                    }
                    if (extendEOL && ctx.component != null) {
                        ctx.drawGraphics.setStrikeThroughColor(null);
                        ctx.drawGraphics.setUnderlineColor(null);
                        ctx.drawGraphics.setWaveUnderlineColor(null);
                        blankWidth = ctx.component.getWidth();
                    }
                }
                if (blankWidth <= 0) continue;
                ctx.drawGraphics.setBackColor(ctx.backColor);
                ctx.drawGraphics.fillRect(blankWidth);
                if (!emptyLine) continue;
                ctx.x += blankWidth;
            } while (emptyLine);
        } else {
            ctx.drawGraphics.setBackColor(ctx.backColor);
            ctx.drawGraphics.setForeColor(ctx.foreColor);
            ctx.drawGraphics.setStrikeThroughColor(ctx.strikeThroughColor);
            ctx.drawGraphics.setUnderlineColor(ctx.underlineColor);
            ctx.drawGraphics.setWaveUnderlineColor(ctx.waveUnderlineColor);
            ctx.drawGraphics.setFont(ctx.font);
            if (ctx.tabsFragment) {
                ctx.drawGraphics.drawTabs(ctx.fragmentStartIndex, ctx.fragmentLength, ctx.fragmentCharCount, ctx.fragmentWidth);
            } else {
                ctx.drawGraphics.drawChars(ctx.fragmentStartIndex, ctx.fragmentLength, ctx.fragmentWidth);
            }
        }
    }

    private void checkTargetOffsetReached(DrawInfo ctx) {
        ctx.continueDraw = true;
        if (ctx.eol && (ctx.targetOffset == ctx.fragmentOffset || ctx.targetOffset == -1)) {
            char ch = '\n';
            ctx.continueDraw = ctx.drawGraphics.targetOffsetReached(ctx.fragmentOffset, ch, ctx.x, ctx.spaceWidth, ctx);
        } else if (ctx.targetOffset == -1 && ctx.fragmentLength > 0) {
            int lastWidthP1;
            int lastWidth;
            int high;
            FontMetrics fm = FontMetricsCache.getFontMetrics(ctx.font, ctx.component);
            int low = -1;
            int lastMid = high = ctx.fragmentLength - 1;
            if (ctx.tabsFragment) {
                int spaceCount = Analyzer.getColumn(ctx.textArray, ctx.fragmentStartIndex, high, ctx.tabSize, ctx.visualColumn) - ctx.visualColumn;
                lastWidth = spaceCount * ctx.spaceWidth;
            } else {
                lastWidth = fm.charsWidth(ctx.textArray, ctx.fragmentStartIndex, high);
            }
            if (ctx.tabsFragment) {
                int spaceCount = Analyzer.getColumn(ctx.textArray, ctx.fragmentStartIndex, ctx.fragmentLength, ctx.tabSize, ctx.visualColumn) - ctx.visualColumn;
                lastWidthP1 = spaceCount * ctx.spaceWidth;
            } else {
                lastWidthP1 = fm.charsWidth(ctx.textArray, ctx.fragmentStartIndex, ctx.fragmentLength);
            }
            ctx.continueDraw = ctx.drawGraphics.targetOffsetReached(ctx.fragmentOffset + high, ctx.textArray[ctx.fragmentStartIndex + high], ctx.x + lastWidth, lastWidthP1 - lastWidth, ctx);
            if (!ctx.continueDraw) {
                while (low <= high) {
                    int mid = (low + high) / 2;
                    int width = 0;
                    if (mid == lastMid + 1) {
                        width = lastWidthP1;
                    } else if (ctx.tabsFragment) {
                        int spaceCount = Analyzer.getColumn(ctx.textArray, ctx.fragmentStartIndex, mid, ctx.tabSize, ctx.visualColumn) - ctx.visualColumn;
                        width = spaceCount * ctx.spaceWidth;
                    } else {
                        width = fm.charsWidth(ctx.textArray, ctx.fragmentStartIndex, mid);
                    }
                    int widthP1 = 0;
                    if (mid == lastMid - 1) {
                        widthP1 = lastWidth;
                    } else if (ctx.tabsFragment) {
                        int spaceCount = Analyzer.getColumn(ctx.textArray, ctx.fragmentStartIndex, mid + 1, ctx.tabSize, ctx.visualColumn) - ctx.visualColumn;
                        widthP1 = spaceCount * ctx.spaceWidth;
                    } else {
                        widthP1 = fm.charsWidth(ctx.textArray, ctx.fragmentStartIndex, mid + 1);
                    }
                    lastWidth = width;
                    lastWidthP1 = widthP1;
                    lastMid = mid;
                    ctx.continueDraw = ctx.drawGraphics.targetOffsetReached(ctx.fragmentOffset + mid, ctx.textArray[ctx.fragmentStartIndex + mid], ctx.x + width, widthP1 - width, ctx);
                    if (ctx.continueDraw) {
                        low = mid + 1;
                        continue;
                    }
                    if (mid > low && mid != high) {
                        high = mid;
                        continue;
                    }
                    break;
                }
            }
        } else if (ctx.targetOffset < ctx.fragmentOffset + ctx.fragmentLength && ctx.fragmentOffset <= ctx.targetOffset) {
            int curWidth;
            int spaceCount;
            int prevWidth = 0;
            int i = ctx.targetOffset - ctx.fragmentOffset;
            if (i > 0) {
                if (ctx.tabsFragment) {
                    spaceCount = Analyzer.getColumn(ctx.textArray, ctx.fragmentStartIndex, i, ctx.tabSize, ctx.visualColumn) - ctx.visualColumn;
                    prevWidth = spaceCount * ctx.spaceWidth;
                } else {
                    prevWidth = FontMetricsCache.getFontMetrics(ctx.font, ctx.component).charsWidth(ctx.textArray, ctx.fragmentStartIndex, i);
                }
            }
            if (ctx.tabsFragment) {
                spaceCount = Analyzer.getColumn(ctx.textArray, ctx.fragmentStartIndex, i + 1, ctx.tabSize, ctx.visualColumn) - ctx.visualColumn;
                curWidth = spaceCount * ctx.spaceWidth;
            } else {
                curWidth = FontMetricsCache.getFontMetrics(ctx.font, ctx.component).charsWidth(ctx.textArray, ctx.fragmentStartIndex, i + 1);
            }
            ctx.continueDraw = ctx.drawGraphics.targetOffsetReached(ctx.fragmentOffset + i, ctx.textArray[ctx.fragmentStartIndex + i], ctx.x + prevWidth, curWidth - prevWidth, ctx);
        }
    }

    private void drawCurrentTokenFragment(DrawInfo ctx) {
        ctx.foreColor = ctx.defaultColoring.getForeColor();
        ctx.backColor = ctx.defaultColoring.getBackColor();
        ctx.font = ctx.defaultColoring.getFont();
        ctx.strikeThroughColor = null;
        ctx.underlineColor = null;
        ctx.waveUnderlineColor = null;
        if (ctx.bol) {
            Color fg = ctx.foreColor;
            Color bg = ctx.backColor;
            this.handleBOL(ctx);
            ctx.foreColor = fg;
            ctx.backColor = bg;
        }
        while (ctx.fragmentOffset == ctx.updateOffset) {
            this.updateOffsetReached(ctx);
        }
        this.computeFragmentLength(ctx);
        this.computeFragmentDisplayWidth(ctx);
        this.drawFragment(ctx);
        if (debugFragment) {
            System.err.println("DrawEngine:   FRAGMENT='" + EditorDebug.debugChars(ctx.buffer, ctx.fragmentStartIndex, ctx.fragmentLength) + "', at pos=" + ctx.fragmentOffset + ", bol=" + ctx.bol + ", eol=" + ctx.eol);
        }
        if (ctx.component != null) {
            this.checkTargetOffsetReached(ctx);
        }
        ctx.fragmentOffset += ctx.fragmentLength;
        ctx.drawnLength += ctx.fragmentLength;
        ctx.visualColumn += ctx.fragmentCharCount;
        ctx.x += ctx.fragmentWidth;
        ctx.bol = false;
        if (ctx.eol) {
            this.handleEOL(ctx);
            ctx.bol = true;
        }
        if (ctx.fragmentOffset >= ctx.endOffset && ctx.endOffset < ctx.docLen) {
            ctx.continueDraw = false;
        }
    }

    private void drawCurrentToken(DrawInfo ctx) {
        if (ctx.tokenID != null) {
            ctx.tokenContextPath = ctx.syntax.getTokenContextPath();
            ctx.tokenOffset = ctx.syntax.getTokenOffset() + ctx.bufferStartOffset;
            ctx.tokenLength = ctx.syntax.getTokenLength();
            if (ctx.tokenOffset + ctx.tokenLength <= ctx.startOffset) {
                return;
            }
        } else {
            ctx.tokenContextPath = null;
            ctx.tokenOffset = ctx.fragmentOffset;
            ctx.tokenLength = 0;
        }
        if (ctx.tokenOffset <= ctx.startOffset) {
            ctx.layerUpdateOffset = Integer.MAX_VALUE;
            int layersLength = ctx.layers.length;
            for (int i = 0; i < layersLength; ++i) {
                int naco;
                DrawLayer l = ctx.layers[i];
                ctx.layerActives[i] = l.isActive(ctx, null);
                ctx.layerActivityChangeOffsets[i] = naco = l.getNextActivityChangeOffset(ctx);
                if (naco <= ctx.fragmentOffset || naco >= ctx.layerUpdateOffset) continue;
                ctx.layerUpdateOffset = naco;
            }
            ctx.updateOffset = Math.min(ctx.layerUpdateOffset, ctx.drawMarkOffset);
        }
        ctx.drawnLength = ctx.fragmentOffset - ctx.tokenOffset;
        ctx.fragmentLength = 0;
        if (debug) {
            System.err.println("DrawEngine: TOKEN='" + EditorDebug.debugChars(ctx.getBuffer(), ctx.getTokenOffset() - ctx.getBufferStartOffset(), ctx.getTokenLength()) + "', tokenID=<" + (ctx.getTokenID() == null ? "null" : ctx.tokenID.getName()) + ">, tcp=" + ctx.getTokenContextPath() + ", pos=" + ctx.getTokenOffset());
        }
        do {
            this.drawCurrentTokenFragment(ctx);
        } while (ctx.continueDraw && ctx.drawnLength < ctx.tokenLength);
    }

    private void graphicsSpecificUpdates(DrawInfo ctx) {
        Rectangle bounds = ctx.editorUI.getExtentBounds();
        Rectangle clip = ctx.graphics.getClipBounds();
        Insets textMargin = ctx.editorUI.getTextMargin();
        int leftMarginWidth = textMargin.left - ctx.editorUI.lineNumberWidth - ctx.editorUI.textLeftMarginWidth;
        if (ctx.lineNumbering && !ctx.syncedLineNumbering) {
            Color lnBackColor = ctx.lineNumberColoring.getBackColor();
            int numY = ctx.startY;
            int lnBarX = bounds.x + leftMarginWidth;
            if (!lnBackColor.equals(ctx.defaultColoring.getBackColor()) || bounds.x > 0) {
                ctx.graphics.setColor(lnBackColor);
                ctx.graphics.fillRect(lnBarX, numY, ctx.editorUI.lineNumberWidth, ctx.lineIndex * ctx.lineHeight);
            }
            ctx.drawGraphics.setDefaultBackColor(lnBackColor);
            int lastDigitInd = Math.max(ctx.lineNumberChars.length - 1, 0);
            int numX = lnBarX;
            if (ctx.editorUI.getLineNumberMargin() != null) {
                numX += ctx.editorUI.getLineNumberMargin().left;
            }
            ctx.bol = true;
            for (int j = 0; j < ctx.lineIndex; ++j) {
                int i;
                ctx.fragmentOffset = ctx.lineStartOffsets[j];
                ctx.foreColor = ctx.lineNumberColoring.getForeColor();
                ctx.backColor = lnBackColor;
                ctx.font = ctx.lineNumberColoring.getFont();
                ctx.strikeThroughColor = null;
                ctx.underlineColor = null;
                ctx.waveUnderlineColor = null;
                int lineNumber = ctx.startLineNumber + j;
                int layersLength = ctx.layers.length;
                for (i = 0; i < layersLength; ++i) {
                    lineNumber = ctx.layers[i].updateLineNumberContext(lineNumber, ctx);
                }
                i = lastDigitInd;
                do {
                    ctx.lineNumberChars[i--] = (char)(48 + lineNumber % 10);
                } while ((lineNumber /= 10) != 0 && i >= 0);
                while (i >= 0) {
                    ctx.lineNumberChars[i--] = 32;
                }
                ctx.drawGraphics.setY(numY);
                ctx.drawGraphics.setBuffer(ctx.lineNumberChars);
                ctx.drawGraphics.setForeColor(ctx.foreColor);
                ctx.drawGraphics.setBackColor(ctx.backColor);
                ctx.drawGraphics.setStrikeThroughColor(ctx.strikeThroughColor);
                ctx.drawGraphics.setUnderlineColor(ctx.underlineColor);
                ctx.drawGraphics.setWaveUnderlineColor(ctx.waveUnderlineColor);
                ctx.drawGraphics.setFont(ctx.font);
                ctx.drawGraphics.setX(lnBarX);
                ctx.drawGraphics.fillRect(ctx.editorUI.lineNumberWidth);
                ctx.drawGraphics.setX(numX);
                ctx.drawGraphics.drawChars(0, ctx.lineNumberChars.length, ctx.lineNumberChars.length * ctx.editorUI.lineNumberDigitWidth);
                ctx.drawGraphics.setBuffer(null);
                numY += ctx.lineHeight;
            }
        }
        ctx.graphics.setColor(ctx.defaultColoring.getBackColor());
    }

    void draw(DrawGraphics drawGraphics, EditorUI editorUI, int startOffset, int endOffset, int startX, int startY, int targetOffset) throws BadLocationException {
        this.draw(null, drawGraphics, editorUI, startOffset, endOffset, startX, startY, targetOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void draw(View view, DrawGraphics drawGraphics, EditorUI editorUI, int startOffset, int endOffset, int startX, int startY, int targetOffset) throws BadLocationException {
        if (startOffset < 0 || endOffset < 0 || startOffset > endOffset || startX < 0 || startY < 0) {
            return;
        }
        BaseDocument doc = (BaseDocument)(view != null ? view.getDocument() : editorUI.getDocument());
        if (debug) {
            Element lineRoot = doc.getParagraphElement(0).getParentElement();
            int startLine = lineRoot.getElementIndex(startOffset);
            int startLineOffset = lineRoot.getElement(startLine).getStartOffset();
            int endLine = lineRoot.getElementIndex(endOffset);
            int endLineOffset = lineRoot.getElement(endLine).getStartOffset();
            Graphics g = drawGraphics.getGraphics();
            System.err.println("DrawEngine:---------- DRAWING startOffset=" + startOffset + ", startLine=" + startLine + "(o=" + startLineOffset + "), endOffset=" + endOffset + ", endLine=" + endLine + "(o=" + endLineOffset + "), clip=" + (g != null ? g.getClipBounds().toString() : "null") + "  ------------------");
        }
        DrawInfo ctx = new DrawInfo();
        ctx.drawGraphics = drawGraphics;
        ctx.drawGraphics.setView(view);
        ctx.view = view;
        ctx.editorUI = editorUI;
        ctx.startOffset = startOffset;
        ctx.endOffset = endOffset;
        ctx.startX = startX;
        ctx.startY = startY;
        ctx.targetOffset = targetOffset;
        EditorUI editorUI2 = editorUI;
        synchronized (editorUI2) {
            ctx.doc = doc;
            if (ctx.doc == null) {
                return;
            }
            ctx.text = DocumentUtilities.SEGMENT_CACHE.getSegment();
            ctx.syntax = ctx.doc.getFreeSyntax();
            ctx.doc.readLock();
            try {
                ctx.component = editorUI.getComponent();
                ctx.docLen = ctx.doc.getLength();
                if (ctx.startOffset > ctx.docLen || ctx.endOffset > ctx.docLen) {
                    return;
                }
                if (ctx.endOffset < ctx.docLen) {
                    ++ctx.endOffset;
                }
                this.initInfo(ctx);
                do {
                    ctx.tokenID = ctx.syntax.nextToken();
                    this.drawCurrentToken(ctx);
                } while (ctx.continueDraw && ctx.tokenID != null);
                if (ctx.endOffset == ctx.docLen) {
                    this.handleEOL(ctx);
                    if (ctx.editorUI.textLimitLineVisible) {
                        int lineX = ctx.startX + ctx.editorUI.textLimitWidth * ctx.editorUI.defaultSpaceWidth;
                        if (ctx.graphics != null) {
                            ctx.graphics.setColor(ctx.editorUI.textLimitLineColor);
                            Rectangle clip = ctx.graphics.getClipBounds();
                            if (clip.height > ctx.editorUI.getLineHeight()) {
                                ctx.graphics.drawLine(lineX, ctx.y, lineX, ctx.y + clip.height);
                            }
                        }
                    }
                }
                if (ctx.graphics != null) {
                    this.graphicsSpecificUpdates(ctx);
                }
                ctx.drawGraphics.setBuffer(null);
            }
            finally {
                ctx.drawGraphics.finish();
                if (ctx.syntax != null) {
                    ctx.doc.releaseSyntax(ctx.syntax);
                }
                DocumentUtilities.SEGMENT_CACHE.releaseSegment(ctx.text);
                ctx.doc.readUnlock();
            }
        }
    }

    static {
        SPACE = new char[]{' '};
    }

    class PreinitializedDrawEngine
    extends DrawEngine {
        DrawGraphics drawGraphics;
        DrawInfo drawInfo;

        public PreinitializedDrawEngine(DrawGraphics drawGraphics) {
            this.drawGraphics = drawGraphics;
        }

        public void release() {
            this.drawInfo.drawGraphics.setBuffer(null);
            this.drawInfo.drawGraphics.finish();
            if (this.drawInfo.syntax != null) {
                this.drawInfo.doc.releaseSyntax(this.drawInfo.syntax);
            }
            DocumentUtilities.SEGMENT_CACHE.releaseSegment(this.drawInfo.text);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void preinitialize(BaseDocument doc, EditorUI editorUI, int startOffset, int endOffset, int startX, int startY, int targetOffset) throws BadLocationException {
            this.drawInfo = new DrawInfo();
            this.drawInfo.drawGraphics = this.drawGraphics;
            this.drawInfo.editorUI = editorUI;
            this.drawInfo.startOffset = startOffset;
            this.drawInfo.endOffset = endOffset;
            this.drawInfo.startX = startX;
            this.drawInfo.startY = startY;
            this.drawInfo.targetOffset = targetOffset;
            EditorUI editorUI2 = editorUI;
            synchronized (editorUI2) {
                this.drawInfo.doc = doc;
                if (this.drawInfo.doc == null) {
                    return;
                }
                try {
                    this.drawInfo.text = DocumentUtilities.SEGMENT_CACHE.getSegment();
                    this.drawInfo.syntax = this.drawInfo.doc.getFreeSyntax();
                    this.drawInfo.doc.readLock();
                    this.drawInfo.component = editorUI.getComponent();
                    this.drawInfo.docLen = this.drawInfo.doc.getLength();
                    if (this.drawInfo.startOffset > this.drawInfo.docLen || this.drawInfo.endOffset > this.drawInfo.docLen) {
                        return;
                    }
                    if (this.drawInfo.endOffset < this.drawInfo.docLen) {
                        ++this.drawInfo.endOffset;
                    }
                    DrawEngine.this.initInfo(this.drawInfo);
                }
                finally {
                    this.drawInfo.doc.readUnlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void draw(DrawGraphics dg, EditorUI editorUI, int startOffset, int endOffset, int startX, int startY, int targetOffset) throws BadLocationException {
            if (startOffset < 0 || endOffset < 0 || startOffset > endOffset || startX < 0 || startY < 0) {
                return;
            }
            if (dg != null) {
                super.draw(dg, editorUI, startOffset, endOffset, startX, startY, targetOffset);
                return;
            }
            dg = this.drawGraphics;
            EditorUI editorUI2 = editorUI;
            synchronized (editorUI2) {
                DrawInfo ctx = this.drawInfo;
                ctx.doc.readLock();
                try {
                    do {
                        ctx.tokenID = ctx.syntax.nextToken();
                        DrawEngine.this.drawCurrentToken(ctx);
                    } while (ctx.continueDraw && ctx.tokenID != null);
                    if (ctx.endOffset == ctx.docLen) {
                        DrawEngine.this.handleEOL(ctx);
                    }
                    ctx.editorUI.updateVirtualWidth(ctx.widestWidth + ctx.editorUI.lineNumberWidth + 2 * ctx.editorUI.defaultSpaceWidth);
                    if (ctx.graphics != null) {
                        DrawEngine.this.graphicsSpecificUpdates(ctx);
                    }
                }
                finally {
                    ctx.doc.readUnlock();
                }
            }
        }
    }

    static class DrawInfo
    implements DrawContext {
        Color foreColor;
        Color backColor;
        Color underlineColor;
        Color waveUnderlineColor;
        Color strikeThroughColor;
        Font font;
        int startOffset;
        int endOffset;
        boolean bol;
        boolean eol;
        EditorUI editorUI;
        char[] buffer;
        int bufferStartOffset;
        TokenID tokenID;
        TokenContextPath tokenContextPath;
        int tokenOffset;
        int tokenLength;
        int fragmentOffset;
        int fragmentLength;
        DrawGraphics drawGraphics;
        int targetOffset;
        Segment text;
        char[] textArray;
        Syntax syntax;
        View view;
        JTextComponent component;
        BaseDocument doc;
        int docLen;
        int visualColumn;
        int x;
        int y;
        int startX;
        int startY;
        int lineHeight;
        Coloring defaultColoring;
        int tabSize;
        int widestWidth;
        boolean continueDraw;
        int startLineNumber;
        int lineIndex;
        int[] lineStartOffsets;
        char[] lineNumberChars;
        Coloring lineNumberColoring;
        Graphics graphics;
        boolean lineNumbering;
        boolean syncedLineNumbering;
        DrawLayer[] layers;
        boolean[] layerActives;
        int[] layerActivityChangeOffsets;
        int updateOffset;
        int layerUpdateOffset;
        boolean drawMarkUpdate;
        List drawMarkList;
        int drawMarkIndex;
        MarkFactory.DrawMark drawMark;
        int drawMarkOffset;
        int drawnLength;
        int fragmentStartIndex;
        boolean tabsFragment;
        int spaceWidth;
        int fragmentWidth;
        int fragmentCharCount;

        DrawInfo() {
        }

        public Color getForeColor() {
            return this.foreColor;
        }

        public void setForeColor(Color foreColor) {
            this.foreColor = foreColor;
        }

        public Color getBackColor() {
            return this.backColor;
        }

        public void setBackColor(Color backColor) {
            this.backColor = backColor;
        }

        public Color getUnderlineColor() {
            return this.underlineColor;
        }

        public void setUnderlineColor(Color underlineColor) {
            this.underlineColor = underlineColor;
        }

        public Color getWaveUnderlineColor() {
            return this.waveUnderlineColor;
        }

        public void setWaveUnderlineColor(Color waveUnderlineColor) {
            this.waveUnderlineColor = waveUnderlineColor;
        }

        public Color getStrikeThroughColor() {
            return this.strikeThroughColor;
        }

        public void setStrikeThroughColor(Color strikeThroughColor) {
            this.strikeThroughColor = strikeThroughColor;
        }

        public Font getFont() {
            return this.font;
        }

        public void setFont(Font font) {
            this.font = font;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public boolean isBOL() {
            return this.bol;
        }

        public boolean isEOL() {
            return this.eol;
        }

        public EditorUI getEditorUI() {
            return this.editorUI;
        }

        public char[] getBuffer() {
            return this.buffer;
        }

        public int getBufferStartOffset() {
            return this.bufferStartOffset;
        }

        public TokenID getTokenID() {
            return this.tokenID;
        }

        public TokenContextPath getTokenContextPath() {
            return this.tokenContextPath;
        }

        public int getTokenOffset() {
            return this.tokenOffset;
        }

        public int getTokenLength() {
            return this.tokenLength;
        }

        public int getFragmentOffset() {
            return this.fragmentOffset;
        }

        public int getFragmentLength() {
            return this.fragmentLength;
        }
    }
}

