/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.netbeans.editor.ext.DataAccessor;

public class FileAccessor
implements DataAccessor {
    private File f;
    private RandomAccessFile file;

    public FileAccessor(File file) {
        this.f = file;
    }

    public void append(byte[] buffer, int off, int len) throws IOException {
        this.file.write(buffer, off, len);
    }

    public void read(byte[] buffer, int off, int len) throws IOException {
        this.file.readFully(buffer, off, len);
    }

    public void open(boolean requestWrite) throws IOException {
        this.file = new RandomAccessFile(this.f, requestWrite ? "rw" : "r");
        if (!this.f.exists()) {
            this.f.createNewFile();
        }
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }

    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    public void resetFile() throws IOException {
        this.file.setLength(0L);
    }

    public void seek(long pos) throws IOException {
        this.file.seek(pos);
    }

    public int getFileLength() {
        return (int)this.f.length();
    }

    public String toString() {
        return this.f.getAbsolutePath();
    }
}

