/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TooManyListenersException;
import javax.jmi.reflect.RefFeatured;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.navigation.ClassMemberComparator;
import org.netbeans.modules.java.navigation.ClassMemberRelatedItemProvider;
import org.netbeans.modules.java.navigation.NaturalSortComparator;
import org.netbeans.modules.java.navigation.actions.FilterSubmenuAction;
import org.netbeans.modules.java.navigation.actions.GenerateJavadocAction;
import org.netbeans.modules.java.navigation.actions.OpenAction;
import org.netbeans.modules.java.navigation.actions.SortActionSupport;
import org.netbeans.modules.java.navigation.base.FiltersDescription;
import org.netbeans.modules.java.navigation.base.FiltersManager;
import org.netbeans.modules.java.navigation.jmi.Hacks;
import org.netbeans.modules.java.navigation.jmi.JUtils;
import org.netbeans.modules.java.navigation.spi.RelatedItemListModelSupport;
import org.netbeans.modules.java.navigation.spi.RelatedItemProvider;
import org.netbeans.modules.java.navigation.spi.Reorderable;
import org.netbeans.modules.java.navigation.spi.StringFilter;
import org.netbeans.modules.java.navigation.spi.strings.WeightedString;
import org.netbeans.modules.java.navigation.strings.WeightedStringImpl;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ClassMemberModel
extends RelatedItemListModelSupport
implements MDRChangeListener,
Reorderable,
FiltersManager.FilterChangeListener {
    private static final String SHOW_NON_PUBLIC = "show_non_public";
    private static final String SHOW_STATIC = "show_static";
    private static final String SHOW_FIELDS = "show_fields";
    private static final String SHOW_INHERITED = "show_inherited";
    private static final MDRepository repo = JavaModel.getJavaRepository();
    static FiltersManager filters = null;
    private final HashSet listeningTo = new HashSet();
    private JavaDataObject dob = null;
    private JavaClass clazz = null;
    private static boolean naturalSort = false;
    private List noMembersAvail;
    private boolean isInheritance = false;
    private JUtils.TipHackInvoker tipInvoker;
    private RelatedItemProvider.RelatedItemListener relatedL;
    private static final boolean singleClick = Boolean.getBoolean("nb.navigator.singleclick");
    private boolean includeInners = true;

    ClassMemberModel(JavaDataObject jdo, JUtils.TipHackInvoker tipInvoker, RelatedItemProvider.RelatedItemListener relatedL) {
        super(new ClassMemberRelatedItemProvider(jdo), singleClick, true, true);
        this.dob = jdo;
        this.isInheritance = false;
        this.tipInvoker = tipInvoker;
        this.relatedL = relatedL;
    }

    ClassMemberModel(JavaClass clazz) {
        super(null, false, true, true);
        this.clazz = clazz;
        this.isInheritance = true;
    }

    void setDataObject(JavaDataObject jdo) {
        this.dob = jdo;
    }

    public String getTooltip(Object o) {
        return null;
    }

    public String getTooltip(Object tooltipFor, int x, int y) {
        ItemPaintingData itemData = (ItemPaintingData)tooltipFor;
        return JUtils.getTooltip(itemData.getWString(), itemData.getJMIData(), this.clazz, x, y, this.tipInvoker);
    }

    public Action getDefaultAction(Object o) {
        if (!(o instanceof ItemPaintingData)) {
            o = null;
        }
        Object jmiData = o != null ? ((ItemPaintingData)o).getJMIData() : null;
        return OpenAction.createOpenAction(jmiData);
    }

    public Action[] getActions(Object o) {
        Object jmiData = null;
        if (o instanceof ItemPaintingData) {
            jmiData = ((ItemPaintingData)o).getJMIData();
        }
        boolean wrap = false;
        if (jmiData != null) {
            JUtils.isWrapper(jmiData);
            jmiData = JUtils.unwrap(jmiData);
        }
        if (jmiData == null || jmiData instanceof Method && wrap) {
            return new Action[]{new SortActionSupport.SortByNameAction(this), new SortActionSupport.SortBySourceAction(this), null, new FilterSubmenuAction(ClassMemberModel.filtersInstance())};
        }
        return new Action[]{new GenerateJavadocAction((ClassMember)jmiData), null, new SortActionSupport.SortByNameAction(this), new SortActionSupport.SortBySourceAction(this), null, new FilterSubmenuAction(ClassMemberModel.filtersInstance())};
    }

    public List getSearchResults(String partial) {
        if (this.getList() == null) {
            return Collections.EMPTY_LIST;
        }
        partial = partial.trim();
        StringFilter exactFilter = StringFilter.create(partial);
        StringFilter insensitiveFilter = StringFilter.create(partial.toUpperCase());
        ArrayList<ItemPaintingData> results = new ArrayList<ItemPaintingData>();
        ArrayList<ItemPaintingData> caseInsensitive = new ArrayList<ItemPaintingData>();
        Iterator i = this.getList().iterator();
        while (i.hasNext()) {
            ItemPaintingData pData = (ItemPaintingData)i.next();
            String s = pData.getWString().toString();
            int dotIndex = s.lastIndexOf(".");
            if (dotIndex != -1) {
                s = s.substring(dotIndex + 1);
            }
            if (exactFilter.match(s)) {
                results.add(pData);
                continue;
            }
            if (!insensitiveFilter.match(s.toUpperCase())) continue;
            caseInsensitive.add(pData);
        }
        results.addAll(caseInsensitive);
        return Collections.unmodifiableList(results);
    }

    public Icon getIcon(Object o) {
        return ((ItemPaintingData)o).getIcon();
    }

    protected WeightedString assembleName(WeightedString str, Object o) {
        return ((ItemPaintingData)o).getWString();
    }

    protected boolean isObjectValid(Object o) {
        return true;
    }

    public int indexOf(Object obj) {
        if (obj instanceof Element) {
            return this.findItemIndexForElement((Element)obj);
        }
        return super.indexOf(obj);
    }

    private int findItemIndexForElement(Element elem) {
        List items = this.getList();
        ItemPaintingData curItem = null;
        int result = 0;
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            curItem = (ItemPaintingData)iter.next();
            if (elem.equals(curItem.getJMIData())) {
                return result;
            }
            ++result;
        }
        return -1;
    }

    protected void stopListening() {
        if (!this.listeningTo.isEmpty()) {
            Iterator i = this.listeningTo.iterator();
            while (i.hasNext()) {
                ((MDRChangeSource)i.next()).removeListener((MDRChangeListener)this);
            }
            this.listeningTo.clear();
        }
        if (this.relatedL != null) {
            this.getRelatedItemProviderSupport().removeRelatedItemListener(this.relatedL);
        }
    }

    protected void startListening() {
        if (this.relatedL != null) {
            try {
                this.getRelatedItemProviderSupport().addRelatedItemListener(this.relatedL);
            }
            catch (TooManyListenersException ex) {
                ex.printStackTrace();
            }
        }
    }

    void setIncludeInners(boolean val) {
        this.includeInners = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List loadContents() {
        List result = null;
        ((JMManager)JMManager.getManager()).waitScanFinished();
        repo.beginTrans(false);
        try {
            this.fireBusyChange(true);
            if (this.clazz != null && !this.clazz.isValid()) {
                this.clazz = null;
            }
            JavaClass clazz = this.clazz;
            JavaClass[] jc = new JavaClass[]{clazz};
            boolean showInherited = ClassMemberModel.filtersInstance().isSelected(SHOW_INHERITED);
            if (this.isInheritance) {
                if (clazz != null) {
                    result = JUtils.getClassMembers(clazz, showInherited, this.includeInners);
                }
            } else {
                result = JUtils.getClassMembers(this.dob, showInherited, jc, this.includeInners);
            }
            if (result == null) {
                List list = this.getNoMembersAvail();
                return list;
            }
            if (jc[0] != this.clazz && jc[0] != null) {
                this.clazz = jc[0];
            }
            Iterator i = result.iterator();
            while (i.hasNext()) {
                Object o = JUtils.unwrap(i.next());
                if (o instanceof Method || o instanceof Constructor || o instanceof Field || o instanceof Attribute) continue;
                i.remove();
            }
            result = this.filter(this.clazz, result);
            Object[] toSort = result.toArray();
            Arrays.sort(toSort, naturalSort ? new NaturalSortComparator() : new ClassMemberComparator(clazz));
            result = Arrays.asList(toSort);
            result = this.buildMembersForPainting(result);
            if (result.isEmpty()) {
                result = this.getNoMembersAvail();
            }
            this.startListeningTo(Hacks.getResourceForDataObject(this.dob));
        }
        finally {
            repo.endTrans(false);
            this.fireBusyChange(false);
        }
        return result;
    }

    private List buildMembersForPainting(List jmiMembers) {
        ArrayList<ItemPaintingData> result = new ArrayList<ItemPaintingData>(jmiMembers.size());
        Object wString = null;
        Object jmiData = null;
        Iterator iter = jmiMembers.iterator();
        while (iter.hasNext()) {
            jmiData = iter.next();
            result.add(new ItemPaintingData(this.buildWString(jmiData), JUtils.iconFor(jmiData), jmiData));
        }
        return result;
    }

    private List getNoMembersAvail() {
        if (this.noMembersAvail == null) {
            this.noMembersAvail = new ArrayList(1);
            WeightedStringImpl wString = new WeightedStringImpl();
            ((WeightedString)wString).startMarkupRun(4);
            ((WeightedString)wString).append(NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_NoMembersAvail"), 0.9f);
            this.noMembersAvail.add(new ItemPaintingData(wString, null, null));
        }
        return this.noMembersAvail;
    }

    private WeightedString buildWString(Object jmiData) {
        WeightedStringImpl result = new WeightedStringImpl();
        if (jmiData instanceof ClassMember && !((ClassMember)jmiData).isValid()) {
            ((WeightedString)result).startMarkupRun(512);
            ((WeightedString)result).append(NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_Invalid"), 0.9f);
        } else {
            boolean useName;
            boolean bl = useName = this.dob == null;
            if (!useName && !this.isInheritance && jmiData instanceof ClassMember && ((ClassMember)jmiData).getDeclaringClass() instanceof JavaClass) {
                JavaClass declClass = (JavaClass)((ClassMember)jmiData).getDeclaringClass();
                useName = declClass != this.clazz || declClass.isInner();
            }
            JUtils.extractName(result, jmiData, this.clazz, useName);
        }
        return result;
    }

    private List filter(JavaClass headClass, List members) {
        FiltersManager f = ClassMemberModel.filtersInstance();
        boolean showStatic = f.isSelected(SHOW_STATIC);
        boolean showNonPublic = f.isSelected(SHOW_NON_PUBLIC);
        boolean showFields = f.isSelected(SHOW_FIELDS);
        if (showStatic && showNonPublic && showFields) {
            return members;
        }
        ArrayList<ClassMember> result = new ArrayList<ClassMember>();
        boolean isHeadPublic = (headClass.getModifiers() & 1) != 0;
        Iterator i = members.iterator();
        while (i.hasNext()) {
            Object curElem = i.next();
            Object unwrappedElem = JUtils.unwrap(curElem);
            if (!(unwrappedElem instanceof ClassMember)) continue;
            ClassMember cm = (ClassMember)unwrappedElem;
            if (!showNonPublic && (!isHeadPublic || !this.isPartOfPublicAPI(cm)) || !showStatic && (cm.getModifiers() & 8) != 0 || !showFields && cm instanceof Field) continue;
            result.add(cm);
        }
        return result;
    }

    private boolean isPartOfPublicAPI(ClassMember cm) {
        boolean isProtected;
        boolean isPublic = (cm.getModifiers() & 1) != 0;
        boolean bl = isProtected = (cm.getModifiers() & 4) != 0;
        if (!isPublic && !isProtected) {
            return false;
        }
        RefFeatured parentRef = cm.refImmediateComposite();
        while (parentRef instanceof JavaClass) {
            boolean isJCProtected;
            JavaClass jc = (JavaClass)parentRef;
            int jcModifs = jc.getModifiers();
            boolean isJCPublic = (jcModifs & 1) != 0;
            boolean bl2 = isJCProtected = (jcModifs & 4) != 0;
            if (!isJCPublic && !isJCProtected) {
                return false;
            }
            if (isProtected && isJCProtected && (jcModifs & 0x10) != 0) {
                return false;
            }
            parentRef = jc.refImmediateComposite();
        }
        return true;
    }

    private void startListeningTo(Object r) {
        if (r != null && r instanceof MDRChangeSource && !this.listeningTo.contains(r)) {
            this.listeningTo.add(r);
            ((MDRChangeSource)r).addListener((MDRChangeListener)this);
        } else if (this.clazz != null && this.clazz instanceof MDRChangeSource && !this.listeningTo.contains(this.clazz)) {
            this.listeningTo.add(this.clazz);
            ((MDRChangeSource)this.clazz).addListener((MDRChangeListener)this);
        }
    }

    public void change(MDRChangeEvent e) {
        if (!(e instanceof AttributeEvent)) {
            return;
        }
        this.change();
    }

    public boolean isReorderable() {
        return naturalSort;
    }

    public void setNaturalSort(boolean value) {
        if (naturalSort == value) {
            return;
        }
        naturalSort = value;
        this.fireChange();
        this.change();
    }

    public boolean isNaturalSort() {
        return naturalSort;
    }

    public String move(Object o, int newLocation) {
        ClassMember after;
        Object jmiData = ((ItemPaintingData)o).getJMIData();
        ClassMember toMove = (ClassMember)(jmiData = JUtils.unwrap(jmiData));
        String result = JUtils.move(toMove, after = (ClassMember)((ItemPaintingData)this.getElementAt(newLocation)).getJMIData());
        if (result == null) {
            this.change();
        }
        return result;
    }

    public JComponent getFilters() {
        FiltersManager f = ClassMemberModel.filtersInstance();
        f.hookChangeListener(this);
        return f.getComponent();
    }

    public void filterStateChanged(ChangeEvent e) {
        if (this.isActive()) {
            this.change();
        }
    }

    private static synchronized FiltersManager filtersInstance() {
        if (filters == null) {
            filters = ClassMemberModel.createFilters();
        }
        return filters;
    }

    private static FiltersManager createFilters() {
        FiltersDescription desc = new FiltersDescription();
        desc.addFilter(SHOW_INHERITED, NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowInherited"), NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowInheritedTip"), false, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/filterHideInherited.png")), null);
        desc.addFilter(SHOW_FIELDS, NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowFields"), NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowFieldsTip"), true, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/filterHideFields.gif")), null);
        desc.addFilter(SHOW_STATIC, NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowStatic"), NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowStaticTip"), true, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/filterHideStatic.png")), null);
        desc.addFilter(SHOW_NON_PUBLIC, NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowNonPublic"), NbBundle.getMessage((Class)ClassMemberModel.class, (String)"LBL_ShowNonPublicTip"), true, new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/java/navigation/resources/filterHideNonPublic.png")), null);
        return FiltersDescription.createManager(desc);
    }

    static final class ItemPaintingData {
        private final WeightedString wString;
        private final Icon icon;
        private final Object jmiData;

        public ItemPaintingData(WeightedString wString, Icon icon, Object jmiData) {
            this.wString = wString;
            this.icon = icon;
            this.jmiData = jmiData;
        }

        public WeightedString getWString() {
            return this.wString;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public Object getJMIData() {
            return this.jmiData;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return this.jmiData == null ? false : this.jmiData.equals(o);
        }

        public int hashCode() {
            return this.jmiData == null ? System.identityHashCode(this) : this.jmiData.hashCode();
        }
    }
}

