/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.apache.tools.ant.module.AntSettings;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.execution.NbClassPath;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.NbBundle;

public final class AntCustomizer
extends JPanel
implements ActionListener {
    private JTextField tfAntHome = new JTextField();
    private JButton bAntHome = new JButton();
    private JCheckBox cbSaveFiles = new JCheckBox();
    private JCheckBox cbReuseOutput = new JCheckBox();
    private JCheckBox cbAlwaysShowOutput = new JCheckBox();
    private JComboBox cbVerbosity = new JComboBox();
    private JButton bProperties = new JButton();
    private JButton bClasspath = new JButton();
    protected JLabel lAntVersion = new JLabel();
    private NbClassPath classpath;
    private Properties properties;
    private boolean changed = false;
    private boolean listen = false;
    private File originalAntHome;
    private boolean initialized = false;

    public AntCustomizer() {
        this.tfAntHome.setColumns(30);
        AntCustomizer.loc(this.bAntHome, "Ant_Home_Button");
        this.bAntHome.addActionListener(this);
        AntCustomizer.loc(this.cbSaveFiles, "Save_Files");
        this.cbSaveFiles.setBackground(Color.white);
        this.cbReuseOutput.setBackground(Color.white);
        AntCustomizer.loc(this.cbReuseOutput, "Reuse_Output");
        AntCustomizer.loc(this.cbAlwaysShowOutput, "Always_Show_Output");
        this.cbAlwaysShowOutput.setBackground(Color.white);
        this.cbVerbosity.addItem(NbBundle.getMessage((Class)AntCustomizer.class, (String)"LBL_verbosity_warn"));
        this.cbVerbosity.addItem(NbBundle.getMessage((Class)AntCustomizer.class, (String)"LBL_verbosity_info"));
        this.cbVerbosity.addItem(NbBundle.getMessage((Class)AntCustomizer.class, (String)"LBL_verbosity_verbose"));
        this.cbVerbosity.addItem(NbBundle.getMessage((Class)AntCustomizer.class, (String)"LBL_verbosity_debug"));
        AntCustomizer.loc(this.bProperties, "Properties_Button");
        this.bProperties.addActionListener(this);
        AntCustomizer.loc(this.bClasspath, "Classpath_Button");
        this.bClasspath.addActionListener(this);
        this.cbSaveFiles.addActionListener(this);
        this.cbReuseOutput.addActionListener(this);
        this.cbAlwaysShowOutput.addActionListener(this);
        this.cbVerbosity.addActionListener(this);
        FormLayout layout = new FormLayout("p:g", "p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        CellConstraints lc = new CellConstraints();
        FormLayout layout1 = new FormLayout("p, 5dlu, p:g, 5dlu, p", "p, 5dlu, p, 5dlu, p, 5dlu, p, 5dlu, p, 5dlu, p");
        PanelBuilder builder1 = new PanelBuilder(layout1);
        builder1.addLabel(AntCustomizer.loc("Ant_Home"), lc.xy(1, 1), (Component)this.tfAntHome, cc.xy(3, 1));
        builder1.add((Component)this.bAntHome, cc.xy(5, 1));
        builder1.add((Component)this.lAntVersion, lc.xyw(3, 3, 3));
        builder1.add((Component)this.cbSaveFiles, cc.xy(3, 5));
        builder1.add((Component)this.cbReuseOutput, cc.xy(3, 7));
        builder1.add((Component)this.cbAlwaysShowOutput, cc.xy(3, 9));
        builder1.addLabel(AntCustomizer.loc("Verbosity"), lc.xy(1, 11), (Component)this.cbVerbosity, cc.xy(3, 11, "l, d"));
        builder1.getPanel().setBackground(Color.white);
        builder.add((Component)builder1.getPanel(), cc.xy(1, 1));
        layout1 = new FormLayout("50dlu:g, 5dlu, p", "p");
        builder1 = new PanelBuilder(layout1);
        builder1.addLabel("<html>" + AntCustomizer.loc("Properties_Text_Area"), cc.xy(1, 1));
        builder1.add((Component)this.bProperties, cc.xy(3, 1));
        builder1.getPanel().setBackground(Color.white);
        builder1.getPanel().setBorder(new TitledBorder(AntCustomizer.loc("Properties_Panel")));
        builder.add((Component)builder1.getPanel(), cc.xy(1, 3));
        layout1 = new FormLayout("50dlu:g, 5dlu, p", "p");
        builder1 = new PanelBuilder(layout1);
        builder1.addLabel("<html>" + AntCustomizer.loc("Classpath_Text_Area"), cc.xy(1, 1));
        builder1.add((Component)this.bClasspath, cc.xy(3, 1));
        builder1.getPanel().setBackground(Color.white);
        builder1.getPanel().setBorder(new TitledBorder(AntCustomizer.loc("Classpath_Panel")));
        builder.add((Component)builder1.getPanel(), cc.xy(1, 5));
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)AntCustomizer.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)AntCustomizer.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)AntCustomizer.loc(key));
        }
    }

    void update() {
        this.listen = false;
        AntSettings settings = AntSettings.getDefault();
        this.classpath = settings.getExtraClasspath();
        this.properties = settings.getProperties();
        this.originalAntHome = settings.getAntHomeWithDefault();
        this.tfAntHome.setText(this.originalAntHome.toString());
        this.cbSaveFiles.setSelected(settings.getSaveAll());
        this.cbReuseOutput.setSelected(settings.getAutoCloseTabs());
        this.cbAlwaysShowOutput.setSelected(settings.getAlwaysShowOutput());
        this.cbVerbosity.setSelectedIndex(settings.getVerbosity() - 1);
        this.lAntVersion.setText("(" + settings.getAntVersion() + ")");
        this.changed = false;
        this.initialized = true;
        this.listen = true;
    }

    void applyChanges() {
        if (!this.initialized) {
            return;
        }
        AntSettings settings = AntSettings.getDefault();
        String antHome = this.tfAntHome.getText().trim();
        settings.setAntHome(new File(antHome));
        if (settings.getAutoCloseTabs() != this.cbReuseOutput.isSelected()) {
            settings.setAutoCloseTabs(this.cbReuseOutput.isSelected());
        }
        if (settings.getSaveAll() != this.cbSaveFiles.isSelected()) {
            settings.setSaveAll(this.cbSaveFiles.isSelected());
        }
        if (settings.getAlwaysShowOutput() != this.cbAlwaysShowOutput.isSelected()) {
            settings.setAlwaysShowOutput(this.cbAlwaysShowOutput.isSelected());
        }
        if (settings.getVerbosity() != this.cbVerbosity.getSelectedIndex() + 1) {
            settings.setVerbosity(this.cbVerbosity.getSelectedIndex() + 1);
        }
        if (!settings.getProperties().equals(this.properties)) {
            settings.setProperties(this.properties);
        }
        if (!settings.getExtraClasspath().equals((Object)this.classpath)) {
            settings.setExtraClasspath(this.classpath);
        }
        this.changed = false;
    }

    void cancel() {
        AntSettings settings = AntSettings.getDefault();
        if (settings.getAntHome() != this.originalAntHome) {
            settings.setAntHome(this.originalAntHome);
        }
        this.changed = false;
    }

    boolean dataValid() {
        return true;
    }

    boolean isChanged() {
        return this.changed;
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.listen) {
            return;
        }
        Object o = e.getSource();
        if (o == this.cbAlwaysShowOutput) {
            this.changed = true;
        } else if (o == this.cbReuseOutput) {
            this.changed = true;
        } else if (o == this.cbSaveFiles) {
            this.changed = true;
        } else if (o == this.cbVerbosity) {
            this.changed = true;
        } else if (o == this.bAntHome) {
            JFileChooser chooser = new JFileChooser(this.tfAntHome.getText());
            chooser.setFileSelectionMode(1);
            int r = chooser.showDialog(SwingUtilities.getWindowAncestor(this), AntCustomizer.loc("Select_Directory"));
            if (r == 0) {
                File file = chooser.getSelectedFile();
                if (!new File(new File(file, "lib"), "ant.jar").isFile()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(AntCustomizer.loc("Not_a_ant_home"), file), 2));
                    return;
                }
                this.tfAntHome.setText(file.getAbsolutePath());
                AntSettings settings = AntSettings.getDefault();
                settings.setAntHome(file);
                this.lAntVersion.setText("(" + settings.getAntVersion() + ")");
                this.changed = true;
            }
        } else if (o == this.bClasspath) {
            PropertyEditor editor = PropertyEditorManager.findEditor(NbClassPath.class);
            editor.setValue(this.classpath);
            Component customEditor = editor.getCustomEditor();
            DialogDescriptor dd = new DialogDescriptor((Object)customEditor, AntCustomizer.loc("Classpath_Editor_Title"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setVisible(true);
            if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                this.classpath = (NbClassPath)editor.getValue();
                this.changed = true;
            }
        } else if (o == this.bProperties) {
            PropertyEditor editor = PropertyEditorManager.findEditor(Properties.class);
            editor.setValue(this.properties);
            Component customEditor = editor.getCustomEditor();
            DialogDescriptor dd = new DialogDescriptor((Object)customEditor, AntCustomizer.loc("Properties_Editor_Title"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setVisible(true);
            if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                this.properties = customEditor instanceof EnhancedCustomPropertyEditor ? (Properties)((EnhancedCustomPropertyEditor)customEditor).getPropertyValue() : (Properties)editor.getValue();
                this.changed = true;
            }
        }
    }
}

