/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Timer;
import java.util.TimerTask;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.metadata.NNListener;
import org.netbeans.modules.j2ee.metadata.Utils;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.project.config.ServiceAlreadyExistsExeption;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSNNListener
implements NNListener {
    private static final ArrayList<String> supportedAnnotations = new ArrayList();
    private static final String WS_NAME = "name";
    private static final String WSDL_LOCATION_NN_ATTRIBUTE = "wsdlLocation";
    private JaxWsModel jaxWSmodel;
    private ClassPath cp;
    private Timer timer = new Timer();
    private TimerTask ttask = this.createTimerTask();

    public JAXWSNNListener(JaxWsModel jaxWSmodel, ClassPath cp) {
        this.jaxWSmodel = jaxWSmodel;
        this.cp = cp;
    }

    public ClassPath getClassPath() {
        return this.cp;
    }

    public Collection<String> getSupportedAnnotations() {
        return supportedAnnotations;
    }

    public Collection<String> getPrimaryAnnotations() {
        return Collections.emptyList();
    }

    public void addClassAnnotation(JavaClass javaClass, Annotation annotation, AnnotationType annotationType) {
        block7: {
            if (Utils.getNNAttributes((Annotation)annotation).get(WSDL_LOCATION_NN_ATTRIBUTE) == null) {
                String wsName = this.getWSName(javaClass, annotation);
                String className = javaClass.getName();
                FileObject fo = JavaModel.getFileObject((Resource)javaClass.getResource());
                if (this.isInSourceGroup(fo) && !javaClass.isInterface()) {
                    try {
                        Service service = this.jaxWSmodel.findServiceByImplementationClass(className);
                        if (service == null) {
                            this.jaxWSmodel.addService(wsName, className);
                            this.requestModelUpdate();
                        }
                    }
                    catch (ServiceAlreadyExistsExeption e) {
                        Service service = this.jaxWSmodel.findServiceByImplementationClass(className);
                        if (service != null && wsName.equals(service.getName())) break block7;
                        String newName = WSUtils.findProperServiceName(wsName, this.jaxWSmodel);
                        try {
                            this.jaxWSmodel.addService(newName, className);
                        }
                        catch (ServiceAlreadyExistsExeption ex1) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    public void removeClassAnnotation(JavaClass javaClass, Annotation annotation, AnnotationType annotationType) {
        Service serviceToRemove;
        FileObject fo = JavaModel.getFileObject((Resource)javaClass.getResource());
        if ((fo == null || this.isInSourceGroup(fo)) && (serviceToRemove = this.jaxWSmodel.findServiceByImplementationClass(javaClass.getName())) != null && serviceToRemove.getWsdlUrl() == null) {
            this.jaxWSmodel.removeServiceByClassName(javaClass.getName());
            this.requestModelUpdate();
        }
    }

    public void classRemoved(String fqn) {
        Service serviceToRemove = this.jaxWSmodel.findServiceByImplementationClass(fqn);
        if (serviceToRemove != null && serviceToRemove.getWsdlUrl() == null) {
            this.jaxWSmodel.removeServiceByClassName(fqn);
            this.requestModelUpdate();
        }
    }

    public void addClassAttribute(JavaClass javaClass, Annotation annotation, AnnotationType t, String attributeName, String attributeValue) {
    }

    public void removeClassAttribute(JavaClass javaClass, Annotation annotation, AnnotationType t, String attributeName) {
    }

    public void addMemberAttribute(JavaClass javaClass, Element member, Annotation annotation, AnnotationType t, String attributeName, String attributeValue) {
    }

    public void removeMemberAttribute(JavaClass javaClass, Element memberName, Annotation annotation, AnnotationType t, String attributeName) {
    }

    public void addMemberAnnotation(boolean field, JavaClass javaClass, Element member, Annotation annotation, AnnotationType t) {
    }

    public void removeMemberAnnotation(boolean field, JavaClass javaClass, String memberName, String memberType, Annotation annotation, AnnotationType t) {
    }

    private boolean isInSourceGroup(FileObject fo) {
        Project project = FileOwnerQuery.getOwner((FileObject)this.jaxWSmodel.getJaxWsFile());
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        for (int i = 0; i < sourceGroups.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sourceGroups[i].getRootFolder(), (FileObject)fo)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestModelUpdate() {
        TimerTask timerTask = this.ttask;
        synchronized (timerTask) {
            this.ttask.cancel();
            this.ttask = this.createTimerTask();
            this.timer.schedule(this.ttask, 100L);
        }
    }

    private TimerTask createTimerTask() {
        return new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                TimerTask timerTask = JAXWSNNListener.this.ttask;
                synchronized (timerTask) {
                    try {
                        JAXWSNNListener.this.jaxWSmodel.write();
                    }
                    catch (IOException ioe) {
                        JAXWSNNListener.this.requestModelUpdate();
                    }
                }
            }
        };
    }

    private String getWSName(JavaClass javaClass, Annotation annotation) {
        String wsname = (String)Utils.getNNAttributes((Annotation)annotation).get(WS_NAME);
        if (wsname == null) {
            wsname = javaClass.getSimpleName();
        }
        return wsname;
    }

    static {
        supportedAnnotations.add("javax.jws.WebService");
    }
}

