/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.ui.nodes.FieldCustomizer;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class CmpFieldHelper {
    private EntityHelper entityHelper;
    private CmpField field;
    public static final String PROPERTY_FIELD_ROW_CHANGED = "FIELD_ROW_CHANGED";

    public CmpFieldHelper(EntityHelper entityHelper, CmpField field) {
        this.entityHelper = entityHelper;
        this.field = field;
    }

    public String getTypeString() {
        Type type = this.getType();
        return type == null ? null : type.getName();
    }

    public Type getType() {
        Method getterMethod = this.entityHelper.getGetterMethod(this.getFieldName());
        return getterMethod == null ? null : getterMethod.getType();
    }

    public void reloadType() {
        this.setType(this.getTypeString());
    }

    public void setType(String typeString) {
        this.setType(JMIUtils.resolveType((String)typeString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(Type newType) {
        EntityMethodController entityMethodController = this.entityHelper.getEntityMethodController();
        entityMethodController.beginWriteJmiTransaction();
        boolean rollback = true;
        try {
            JavaClass beanClass;
            if (newType instanceof PrimitiveType && this.isPrimary()) {
                newType = JMIUtils.getPrimitiveTypeWrapper((PrimitiveType)((PrimitiveType)newType));
            }
            String fieldName = this.getFieldName();
            Method getterMethod = this.entityHelper.getGetterMethod(fieldName);
            Method setterMethod = this.entityHelper.getSetterMethod(fieldName, getterMethod);
            boolean primary = this.isPrimary();
            JavaClass localBusinessInterfaceClass = this.entityHelper.getLocalBusinessInterfaceClass();
            entityMethodController.registerClassForSave(localBusinessInterfaceClass);
            JavaClass remoteBusinessInterfaceClass = this.entityHelper.getRemoteBusinessInterfaceClass();
            entityMethodController.registerClassForSave(remoteBusinessInterfaceClass);
            this.changeReturnType(Utils.getMethod(localBusinessInterfaceClass, getterMethod), newType);
            Utils.changeParameterType(Utils.getMethod(localBusinessInterfaceClass, setterMethod), newType);
            this.changeReturnType(Utils.getMethod(remoteBusinessInterfaceClass, getterMethod), newType);
            Utils.changeParameterType(Utils.getMethod(remoteBusinessInterfaceClass, setterMethod), newType);
            this.changeReturnType(getterMethod, newType);
            Utils.changeParameterType(setterMethod, newType);
            newType = JMIUtils.resolveType((String)this.getTypeString());
            if (primary) {
                this.entityHelper.setPrimKeyClass(newType);
            }
            if ((beanClass = this.entityHelper.getBeanClass()) != null) {
                entityMethodController.registerClassForSave(beanClass);
                Method[] methods = JMIUtils.getMethods((JavaClass)beanClass);
                block3: for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    String name = method.getName();
                    boolean isCreate = "ejbCreate".equals(name);
                    boolean isPostCreate = "ejbPostCreate".equals(name);
                    if (isCreate && primary) {
                        this.changeReturnType(method, newType);
                    }
                    if (!isCreate && !isPostCreate) continue;
                    List parameters = method.getParameters();
                    Iterator it1 = parameters.iterator();
                    while (it1.hasNext()) {
                        Parameter parameter = (Parameter)it1.next();
                        if (!fieldName.equals(parameter.getName())) continue;
                        parameter.setType(newType);
                        continue block3;
                    }
                }
            }
            rollback = false;
        }
        finally {
            entityMethodController.endWriteJmiTransaction(rollback);
        }
        this.entityHelper.cmpFields.firePropertyChange(null);
        this.modelUpdatedFromUI();
    }

    private void modelUpdatedFromUI() {
        this.entityHelper.modelUpdatedFromUI();
    }

    private void changeReturnType(Method method, Type type) {
        if (method != null) {
            method.setType(type);
        }
    }

    public boolean hasLocalGetter() {
        return this.getLocalGetter() != null;
    }

    private Method getLocalGetter() {
        return this.entityHelper.getEntityMethodController().getGetterMethod(this.getFieldName(), true);
    }

    public boolean hasLocalSetter() {
        return this.getLocalSetter() != null;
    }

    private Method getLocalSetter() {
        return this.entityHelper.getEntityMethodController().getSetterMethod(this.getFieldName(), true);
    }

    public boolean hasRemoteGetter() {
        return this.getRemoteGetter() != null;
    }

    private Method getRemoteGetter() {
        return this.entityHelper.getEntityMethodController().getGetterMethod(this.getFieldName(), false);
    }

    public boolean hasRemoteSetter() {
        return this.getRemoteSetter() != null;
    }

    private Method getRemoteSetter() {
        return this.entityHelper.getEntityMethodController().getSetterMethod(this.getFieldName(), false);
    }

    public void setLocalGetter(boolean create) {
        this.entityHelper.updateFieldAccessor(this.getFieldName(), true, true, create);
    }

    public void setLocalSetter(boolean create) {
        this.entityHelper.updateFieldAccessor(this.getFieldName(), false, true, create);
    }

    public void setRemoteGetter(boolean create) {
        this.entityHelper.updateFieldAccessor(this.getFieldName(), true, false, create);
    }

    public void setRemoteSetter(boolean create) {
        this.entityHelper.updateFieldAccessor(this.getFieldName(), false, false, create);
    }

    public boolean deleteCmpField() {
        String message = NbBundle.getMessage((Class)CmpFieldHelper.class, (String)"MSG_ConfirmDeleteField", (Object)this.field.getFieldName());
        String title = NbBundle.getMessage((Class)CmpFieldHelper.class, (String)"MSG_ConfirmDeleteFieldTitle");
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)message, title, 0);
        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) {
            EntityMethodController entityMethodController = this.entityHelper.getEntityMethodController();
            try {
                entityMethodController.deleteField(this.field, this.entityHelper.ejbJarFile);
                this.modelUpdatedFromUI();
                return true;
            }
            catch (IOException e) {
                Utils.notifyError(e);
            }
        }
        return false;
    }

    private static void removeMethod(JavaClass interfaceClass, Method method) {
        if (Utils.getMethod(interfaceClass, method) != null) {
            Utils.removeMethod(interfaceClass, method);
        }
    }

    public void setFieldName(String newName) {
        int newFieldRow;
        Parameter[] parameters;
        NamedElement parameter;
        IllegalArgumentException ex = FieldCustomizer.validateFieldName((String)newName);
        if (ex != null) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return;
        }
        String fieldName = this.getFieldName();
        boolean primary = this.isPrimary();
        int oldFieldRow = this.entityHelper.cmpFields.getFieldRow(this.field);
        RefactoringSession refactoringSession = RefactoringSession.create((String)"Rename");
        Method[] methods = JMIUtils.getMethods((JavaClass)this.entityHelper.getBeanClass());
        Method ejbPostCreateMethod = (Method)CmpFieldHelper.findNamedElement((NamedElement[])methods, "ejbPostCreate");
        Method ejbCreateMethod = (Method)CmpFieldHelper.findNamedElement((NamedElement[])methods, "ejbCreate");
        if (ejbCreateMethod != null && (parameter = CmpFieldHelper.findNamedElement((NamedElement[])(parameters = ejbCreateMethod.getParameters().toArray(new Parameter[0])), fieldName)) != null) {
            CmpFieldHelper.prepareRename(refactoringSession, parameter, newName);
        }
        if (ejbPostCreateMethod != null && (parameter = CmpFieldHelper.findNamedElement((NamedElement[])(parameters = ejbPostCreateMethod.getParameters().toArray(new Parameter[0])), fieldName)) != null) {
            CmpFieldHelper.prepareRename(refactoringSession, parameter, newName);
        }
        Method getterMethod = this.entityHelper.getGetterMethod(fieldName);
        Method setterMethod = this.entityHelper.getSetterMethod(fieldName, getterMethod);
        String getterName = EntityMethodController.getMethodName((String)newName, (boolean)true);
        String setterName = EntityMethodController.getMethodName((String)newName, (boolean)false);
        CmpFieldHelper.prepareRename(refactoringSession, (NamedElement)getterMethod, getterName);
        CmpFieldHelper.prepareRename(refactoringSession, (NamedElement)setterMethod, setterName);
        CmpFieldHelper.prepareRename(refactoringSession, (NamedElement)this.getLocalGetter(), getterName);
        CmpFieldHelper.prepareRename(refactoringSession, (NamedElement)this.getLocalSetter(), setterName);
        CmpFieldHelper.prepareRename(refactoringSession, (NamedElement)this.getRemoteGetter(), getterName);
        CmpFieldHelper.prepareRename(refactoringSession, (NamedElement)this.getRemoteSetter(), setterName);
        refactoringSession.doRefactoring(true);
        this.field.setFieldName(newName);
        if (primary) {
            this.entityHelper.setPrimkeyFieldName(newName);
        }
        if (oldFieldRow != (newFieldRow = this.entityHelper.cmpFields.getFieldRow(this.field))) {
            this.entityHelper.cmpFields.firePropertyChange(new PropertyChangeEvent(this.entityHelper.cmpFields, PROPERTY_FIELD_ROW_CHANGED, new Integer(oldFieldRow), new Integer(newFieldRow)));
        }
        this.modelUpdatedFromUI();
    }

    private static void prepareRename(RefactoringSession refactoringSession, NamedElement element, String newName) {
        if (element != null) {
            RenameRefactoring refactoring = new RenameRefactoring((Object)element);
            refactoring.setNewName(newName);
            refactoring.prepare(refactoringSession);
        }
    }

    private static NamedElement findNamedElement(NamedElement[] elements, String name) {
        for (int i = 0; i < elements.length; ++i) {
            NamedElement element = elements[i];
            if (!name.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    public void setDescription(String s) {
        this.field.setDescription(s);
        this.modelUpdatedFromUI();
    }

    public String getDefaultDescription() {
        return this.field.getDefaultDescription();
    }

    public String getFieldName() {
        return this.field.getFieldName();
    }

    public boolean isPrimary() {
        return this.getFieldName().equals(this.entityHelper.getPrimkeyField());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean edit() {
        Field field = JavaModel.getDefaultExtent().getField().createField();
        String fieldName = this.getFieldName();
        field.setName(fieldName);
        field.setType(JMIUtils.resolveType((String)this.getTypeString()));
        FieldCustomizer customizer = new FieldCustomizer(field, this.getDefaultDescription(), this.entityHelper.hasLocalInterface(), this.entityHelper.hasRemoteInterface(), this.hasLocalGetter(), this.hasLocalSetter(), this.hasRemoteGetter(), this.hasRemoteSetter());
        while (this.openEditCmpFieldDialog(customizer)) {
            customizer.isOK();
            String newFieldName = field.getName();
            if (!fieldName.equals(newFieldName)) {
                try {
                    this.entityHelper.getEntityMethodController().validateNewCmpFieldName(newFieldName);
                }
                catch (IllegalArgumentException ex) {
                    Utils.notifyError(ex);
                    continue;
                }
            }
            Utils.beginJmiTransaction(true);
            boolean rollback = true;
            try {
                this.setFieldName(newFieldName);
                this.setType(field.getType());
                this.setDescription(customizer.getDescription());
                this.setLocalGetter(customizer.isLocalGetter());
                this.setLocalSetter(customizer.isLocalSetter());
                this.setRemoteGetter(customizer.isRemoteGetter());
                this.setRemoteSetter(customizer.isRemoteSetter());
                rollback = false;
            }
            finally {
                Utils.endJmiTransaction(rollback);
            }
            this.modelUpdatedFromUI();
            return true;
        }
        return false;
    }

    private boolean openEditCmpFieldDialog(FieldCustomizer customizer) {
        String title = Utils.getBundleMessage("LBL_EditCmpField");
        NotifyDescriptor nd = new NotifyDescriptor((Object)customizer, title, 2, -1, null, null);
        return DialogDisplayer.getDefault().notify(nd) == NotifyDescriptor.OK_OPTION;
    }
}

