/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.xml.sax.SAXException;

public class EjbJarMultiViewDataNode
extends DataNode {
    private static final String DEPLOYMENT = "deployment";
    private EjbJarMultiViewDataObject dataObject;
    public static final String PROPERTY_DOCUMENT_TYPE = "documentType";
    private PropertyChangeListener ddListener;

    public EjbJarMultiViewDataNode(EjbJarMultiViewDataObject obj) {
        this(obj, Children.LEAF);
    }

    public EjbJarMultiViewDataNode(EjbJarMultiViewDataObject obj, Children ch) {
        super((DataObject)obj, ch);
        this.dataObject = obj;
        this.initListeners();
        this.setIconBase(this.dataObject.getSaxError() == null);
    }

    private void initListeners() {
        this.ddListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                Object oldValue = evt.getOldValue();
                Object newValue = evt.getNewValue();
                if ("documentDTD".equals(propertyName)) {
                    EjbJarMultiViewDataNode.this.firePropertyChange(EjbJarMultiViewDataNode.PROPERTY_DOCUMENT_TYPE, oldValue, newValue);
                } else if ("valid".equals(propertyName) && Boolean.TRUE.equals(newValue)) {
                    EjbJarMultiViewDataNode.this.removePropertyChangeListener(EjbJarMultiViewDataNode.this.ddListener);
                } else if ("document_valid".equals(propertyName)) {
                    EjbJarMultiViewDataNode.this.setIconBase(Boolean.TRUE.equals(newValue));
                } else if ("propertySets".equals(propertyName)) {
                    EjbJarMultiViewDataNode.this.firePropertySetsChange(null, null);
                } else if ("sax_error".equals(propertyName)) {
                    EjbJarMultiViewDataNode.this.fireShortDescriptionChange((String)oldValue, (String)newValue);
                }
            }
        };
        this.getDataObject().addPropertyChangeListener(this.ddListener);
    }

    private void setIconBase(boolean valid) {
        if (valid) {
            this.setIconBaseWithExtension(this.dataObject.getIconBaseForValidDocument());
        } else {
            this.setIconBaseWithExtension(this.dataObject.getIconBaseForInvalidDocument());
        }
        this.fireIconChange();
    }

    protected Sheet createSheet() {
        Sheet s = new Sheet();
        Sheet.Set ss = new Sheet.Set();
        ss.setName(DEPLOYMENT);
        ss.setDisplayName(NbBundle.getMessage((Class)EjbJarMultiViewDataNode.class, (String)"PROP_deploymentSet"));
        ss.setShortDescription(NbBundle.getMessage((Class)EjbJarMultiViewDataNode.class, (String)"HINT_deploymentSet"));
        ss.setValue("helpID", (Object)"TBD---Ludo ejbjar node");
        PropertySupport.ReadWrite p = new PropertySupport.ReadWrite(PROPERTY_DOCUMENT_TYPE, String.class, NbBundle.getBundle((Class)EjbJarMultiViewDataNode.class).getString("PROP_documentDTD"), NbBundle.getBundle((Class)EjbJarMultiViewDataNode.class).getString("HINT_documentDTD")){

            public Object getValue() {
                BigDecimal version = EjbJarMultiViewDataNode.this.dataObject.getEjbJar().getVersion();
                return version == null ? "" : version.toString();
            }

            public void setValue(Object value) {
                String val = (String)value;
                if ("2.1".equals(val) && !val.equals(EjbJarMultiViewDataNode.this.dataObject.getEjbJar().getVersion().toString())) {
                    EjbJarMultiViewDataNode.this.dataObject.getEjbJar().setVersion(new BigDecimal(val));
                    EjbJarMultiViewDataNode.this.dataObject.modelUpdatedFromUI();
                }
            }
        };
        ss.put((Node.Property)p);
        s.put(ss);
        return s;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public Image getIcon(int type) {
        Image ejbJarXmlIcon = Utilities.loadImage((String)"org/netbeans/modules/j2ee/ddloaders/web/resources/DDDataIcon.gif");
        if (this.dataObject.getSaxError() == null) {
            return ejbJarXmlIcon;
        }
        Image errorBadgeIcon = Utilities.loadImage((String)"org/netbeans/modules/j2ee/ddloaders/web/resources/error-badge.gif");
        return Utilities.mergeImages((Image)ejbJarXmlIcon, (Image)errorBadgeIcon, (int)6, (int)6);
    }

    void descriptionChanged(String oldDesc, String newDesc) {
        this.setShortDescription(newDesc == null ? "Enterprise Bean deployment descriptor" : newDesc);
    }

    public String getShortDescription() {
        SAXException saxError = this.dataObject.getSaxError();
        if (saxError == null) {
            return Utils.getBundleMessage("HINT_ejb_dd");
        }
        return saxError.getMessage();
    }
}

