/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.BrowseFolders;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.DDUtils;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SectionValidator;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletPanelFactory;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.ConfirmDialog;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionContainer;
import org.netbeans.modules.xml.multiview.ui.SectionContainerNode;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.SimpleDialogPanel;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ServletsMultiViewElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private SectionView view;
    private ToolBarDesignEditor comp;
    private DDDataObject dObj;
    private WebApp webApp;
    private ServletPanelFactory factory;
    private Action addAction;
    private Action removeAction;
    private boolean needInit = true;
    private int index;
    private RequestProcessor.Task repaintingTask;
    private static final String SERVLET_MV_ID = "dd_multiviewServlets";
    private static final String HELP_ID_PREFIX = "dd_multiview_servlets_";

    public ServletsMultiViewElement(DDDataObject dObj, int index) {
        super((XmlMultiViewDataObject)dObj);
        this.dObj = dObj;
        this.index = index;
        this.comp = new ToolBarDesignEditor();
        this.factory = new ServletPanelFactory(this.comp, dObj);
        this.addAction = new AddAction(dObj, NbBundle.getMessage((Class)ServletsMultiViewElement.class, (String)"LBL_addServlet"));
        this.removeAction = new RemoveAction(NbBundle.getMessage((Class)ServletsMultiViewElement.class, (String)"LBL_remove"));
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ServletsMultiViewElement.this.repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        this.dObj.setLastOpenView(this.index);
        if (this.needInit || !this.dObj.isDocumentParseable()) {
            this.repaintView();
            this.needInit = false;
        }
    }

    public void componentOpened() {
        super.componentOpened();
        this.dObj.getWebApp().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.dObj.getWebApp().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name;
        if (!this.dObj.isChangedFromUI() && (name = evt.getPropertyName()).indexOf("Servlet") > 0) {
            if (SERVLET_MV_ID.equals(this.dObj.getSelectedPerspective().preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    private void repaintView() {
        this.webApp = this.dObj.getWebApp();
        this.view = new ServletsView(this.webApp);
        this.comp.setContentView((PanelView)this.view);
        Object lastActive = this.comp.getLastActive();
        if (lastActive != null) {
            this.view.openPanel(lastActive);
        } else {
            ServletsView servletsView = (ServletsView)this.view;
            Node initialNode = servletsView.getServletsNode();
            Children ch = initialNode.getChildren();
            if (ch.getNodesCount() > 0) {
                initialNode = ch.getNodes()[0];
            }
            servletsView.selectNode(initialNode);
        }
        this.view.checkValidity();
        this.dObj.checkParseable();
    }

    private class RemoveAction
    extends AbstractAction {
        RemoveAction(String actionName) {
            super(actionName);
            char mnem = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"LBL_remove_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            ConfirmDialog desc = new ConfirmDialog(NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"TXT_removeServletConfirm"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)desc);
            dialog.setVisible(true);
            if (DialogDescriptor.OK_OPTION.equals(desc.getValue())) {
                SectionPanel sectionPanel = ((SectionPanel.HeaderButton)evt.getSource()).getSectionPanel();
                Servlet servlet = (Servlet)sectionPanel.getKey();
                ServletsMultiViewElement.this.dObj.modelUpdatedFromUI();
                ServletsMultiViewElement.this.dObj.setChangedFromUI(true);
                try {
                    DDUtils.removeServletMappings(ServletsMultiViewElement.this.webApp, servlet.getServletName());
                    DDUtils.removeFilterMappingsForServlet(ServletsMultiViewElement.this.webApp, servlet.getServletName());
                    ServletsMultiViewElement.this.webApp.removeServlet(servlet);
                    sectionPanel.getSectionView().removeSection(sectionPanel.getNode());
                }
                finally {
                    ServletsMultiViewElement.this.dObj.setChangedFromUI(false);
                }
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        AddAction(DDDataObject dObj, String actionName) {
            super(actionName);
            char mnem = NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"LBL_addServlet_mnem").charAt(0);
            this.putValue("MnemonicKey", new Integer(mnem));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt) {
            String[] labels = new String[]{NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"LBL_servletName"), NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"LBL_servletClass"), NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"LBL_jspFile"), NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"LBL_description"), NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"LBL_urlPatterns")};
            char[] mnem = new char[]{NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"LBL_servletName_mnem").charAt(0), NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"LBL_servletClass_mnem").charAt(0), NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"LBL_jspFile_mnem").charAt(0), NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"LBL_description_mnem").charAt(0), NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"LBL_urlPatterns_mnem").charAt(0)};
            boolean[] buttons = new boolean[]{false, true, true, false, false};
            SimpleDialogPanel.DialogDescriptor descriptor = new SimpleDialogPanel.DialogDescriptor(labels);
            descriptor.setMnemonics(mnem);
            descriptor.setButtons(buttons);
            descriptor.setTextField(new boolean[]{true, true, true, false, true});
            final SimpleDialogPanel dialogPanel = new SimpleDialogPanel(descriptor);
            dialogPanel.getCustomizerButtons()[0].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        SourceGroup[] groups = DDUtils.getJavaSourceGroups(ServletsMultiViewElement.this.dObj);
                        FileObject fo = BrowseFolders.showDialog(groups);
                        if (fo != null) {
                            String className = DDUtils.getResourcePath(groups, fo);
                            dialogPanel.getTextComponents()[1].setText(className);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            dialogPanel.getCustomizerButtons()[1].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        SourceGroup[] groups = DDUtils.getDocBaseGroups(ServletsMultiViewElement.this.dObj);
                        FileObject fo = BrowseFolders.showDialog(groups);
                        if (fo != null) {
                            String res = "/" + DDUtils.getResourcePath(groups, fo, '/', true);
                            dialogPanel.getTextComponents()[2].setText(res);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            EditDialog dialog = new EditDialog((JPanel)dialogPanel, NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"TTL_Servlet"), true){

                protected String validate() {
                    String[] values = dialogPanel.getValues();
                    String servletName = values[0].trim();
                    String servletClass = values[1].trim();
                    String jspFile = values[2].trim();
                    String urlPatterns = values[4];
                    return SectionValidator.validateNewServlet(ServletsMultiViewElement.this.dObj.getWebApp(), servletName, servletClass, jspFile, urlPatterns);
                }
            };
            dialog.setValid(false);
            EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
            dialogPanel.getTextComponents()[0].getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getTextComponents()[1].getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getTextComponents()[2].getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getTextComponents()[4].getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            dialogPanel.getTextComponents()[0].getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getTextComponents()[1].getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getTextComponents()[2].getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getTextComponents()[4].getDocument().removeDocumentListener((DocumentListener)docListener);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                String[] values = dialogPanel.getValues();
                ServletsMultiViewElement.this.dObj.modelUpdatedFromUI();
                ServletsMultiViewElement.this.dObj.setChangedFromUI(true);
                try {
                    Servlet servlet = (Servlet)ServletsMultiViewElement.this.webApp.createBean("Servlet");
                    servlet.setServletName(values[0].trim());
                    String servletClass = values[1].trim();
                    if (servletClass.length() > 0) {
                        servlet.setServletClass(servletClass);
                    } else {
                        servlet.setJspFile(values[2].trim());
                    }
                    String desc = values[3].trim();
                    if (desc.length() > 0) {
                        servlet.setDescription(desc);
                    }
                    ServletsMultiViewElement.this.webApp.addServlet(servlet);
                    String[] patterns = DDUtils.getStringArray(values[4]);
                    DDUtils.addServletMappings(ServletsMultiViewElement.this.webApp, servlet, patterns);
                    ServletsView view = (ServletsView)ServletsMultiViewElement.this.comp.getContentView();
                    ServletNode node = new ServletNode(view, ServletsMultiViewElement.this.webApp, servlet);
                    view.getServletsNode().getChildren().add(new Node[]{node});
                    SectionPanel pan = new SectionPanel((SectionView)view, (Node)node, view.getServletTitle(servlet), (Object)servlet);
                    pan.setHeaderActions(new Action[]{ServletsMultiViewElement.this.removeAction});
                    view.getServletsContainer().addSection((NodeSectionPanel)pan, true);
                }
                catch (ClassNotFoundException ex) {
                }
                finally {
                    ServletsMultiViewElement.this.dObj.setChangedFromUI(false);
                }
            }
        }
    }

    private class ServletNode
    extends AbstractNode {
        private Servlet servlet;
        private WebApp webApp;
        private SectionView view;

        ServletNode(SectionView view, WebApp webApp, Servlet servlet) {
            super(Children.LEAF);
            this.servlet = servlet;
            this.webApp = webApp;
            this.view = view;
            this.setDisplayName(servlet.getServletName());
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/class.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_servlets_servletNode");
        }
    }

    class ServletsView
    extends SectionView {
        private SectionContainer servletsCont;
        private Node servletsNode;

        ServletsView(WebApp webApp) {
            super((InnerPanelFactory)ServletsMultiViewElement.this.factory);
            Servlet[] servlets = webApp.getServlet();
            Node[] nodes = new Node[servlets.length];
            Children.Array ch = new Children.Array();
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = new ServletNode(this, webApp, servlets[i]);
            }
            ch.add(nodes);
            this.servletsNode = new SectionContainerNode((Children)ch);
            this.servletsCont = new SectionContainer((SectionView)this, this.servletsNode, NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"TTL_servlets"), false);
            this.servletsCont.setHeaderActions(new Action[]{ServletsMultiViewElement.this.addAction});
            Children.Array servletsChildren = new Children.Array();
            servletsChildren.add(new Node[]{this.servletsNode});
            AbstractNode root = new AbstractNode((Children)servletsChildren);
            SectionPanel[] pan = new SectionPanel[servlets.length];
            for (int i = 0; i < nodes.length; ++i) {
                pan[i] = new SectionPanel((SectionView)this, nodes[i], this.getServletTitle(servlets[i]), (Object)servlets[i]);
                pan[i].setHeaderActions(new Action[]{ServletsMultiViewElement.this.removeAction});
                this.servletsCont.addSection((NodeSectionPanel)pan[i]);
            }
            this.addSection((NodeSectionPanel)this.servletsCont);
            this.servletsNode.setDisplayName(NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"TTL_servlets"));
            this.servletsNode.setName("dd_multiview_servlets_servletsNode");
            this.setRoot((Node)root);
        }

        Node getServletsNode() {
            return this.servletsNode;
        }

        SectionContainer getServletsContainer() {
            return this.servletsCont;
        }

        String getServletTitle(Servlet servlet) {
            String servletName = servlet.getServletName();
            if (servletName == null) {
                servletName = "";
            }
            String mappings = DDUtils.urlPatternList(DDUtils.getUrlPatterns(ServletsMultiViewElement.this.webApp, servlet));
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement == null ? (class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement = ServletsMultiViewElement.class$("org.netbeans.modules.j2ee.ddloaders.web.multiview.ServletsMultiViewElement")) : class$org$netbeans$modules$j2ee$ddloaders$web$multiview$ServletsMultiViewElement), (String)"TTL_servletPanel", (Object)servletName, (Object)mappings);
        }

        public Error validateView() {
            Error error = ServletsMultiViewElement.this.getSectionView().getErrorPanel().getError();
            if (error != null) {
                return error;
            }
            return SectionValidator.validateServlets(ServletsMultiViewElement.this.webApp);
        }
    }
}

