/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.tools.schemaframework;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.databaseaccess.FieldTypeDefinition;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.tools.schemaframework.TableDefinition;

public class FieldDefinition
implements Serializable,
Cloneable {
    protected String name;
    protected Class type;
    protected String typeName;
    protected int size;
    protected int subSize;
    protected boolean shouldAllowNull;
    protected boolean isIdentity;
    protected boolean isPrimaryKey;
    protected boolean isUnique;
    protected String additional;
    protected String constraint;
    protected String foreignKeyFieldName;

    public FieldDefinition() {
        this.name = "";
        this.size = 0;
        this.subSize = 0;
        this.shouldAllowNull = true;
        this.isIdentity = false;
        this.isPrimaryKey = false;
        this.isUnique = false;
    }

    public FieldDefinition(String name, Class type) {
        this.name = name;
        this.type = type;
        this.size = 0;
        this.subSize = 0;
        this.shouldAllowNull = true;
        this.isIdentity = false;
        this.isPrimaryKey = false;
        this.isUnique = false;
    }

    public FieldDefinition(String name, Class type, int size) {
        this();
        this.name = name;
        this.type = type;
        this.size = size;
    }

    public FieldDefinition(String name, Class type, int size, int subSize) {
        this();
        this.name = name;
        this.type = type;
        this.size = size;
        this.subSize = subSize;
    }

    public FieldDefinition(String name, String typeName) {
        this();
        this.name = name;
        this.typeName = typeName;
    }

    public void appendDBString(Writer writer, AbstractSession session, TableDefinition table) throws ValidationException {
        FieldTypeDefinition fieldType;
        if (this.getType() != null) {
            fieldType = session.getPlatform().getFieldTypeDefinition(this.getType());
            if (fieldType == null) {
                throw ValidationException.javaTypeIsNotAValidDatabaseType(this.getType());
            }
        } else {
            fieldType = new FieldTypeDefinition(this.getTypeName());
        }
        try {
            writer.write(this.getName());
            writer.write(" ");
            String qualifiedName = table.getFullName() + '.' + this.getName();
            session.getPlatform().printFieldTypeSize(writer, this, fieldType, session, qualifiedName);
            session.getPlatform().printFieldUnique(writer, this.isUnique(), session, qualifiedName);
            if (this.isIdentity()) {
                String name = table.getFullName() + '.' + this.getName();
                session.getPlatform().printFieldIdentityClause(writer, session, name);
            }
            if (this.shouldAllowNull() && fieldType.shouldAllowNull()) {
                session.getPlatform().printFieldNullClause(writer);
            } else {
                session.getPlatform().printFieldNotNullClause(writer);
            }
            if (this.getConstraint() != null) {
                writer.write(" " + this.getConstraint());
            }
            if (this.getAdditional() != null) {
                writer.write(" " + this.getAdditional());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void appendTypeString(Writer writer, AbstractSession session) throws ValidationException {
        FieldTypeDefinition fieldType;
        if (this.getType() != null) {
            fieldType = session.getPlatform().getFieldTypeDefinition(this.getType());
            if (fieldType == null) {
                throw ValidationException.javaTypeIsNotAValidDatabaseType(this.getType());
            }
        } else {
            fieldType = new FieldTypeDefinition(this.getTypeName());
        }
        try {
            writer.write(this.getName());
            writer.write(" ");
            writer.write(fieldType.getName());
            if (fieldType.isSizeAllowed() && (this.getSize() != 0 || fieldType.isSizeRequired())) {
                writer.write("(");
                if (this.getSize() == 0) {
                    writer.write(new Integer(fieldType.getDefaultSize()).toString());
                } else {
                    writer.write(new Integer(this.getSize()).toString());
                }
                if (this.getSubSize() != 0) {
                    writer.write(",");
                    writer.write(new Integer(this.getSubSize()).toString());
                } else if (fieldType.getDefaultSubSize() != 0) {
                    writer.write(",");
                    writer.write(new Integer(fieldType.getDefaultSubSize()).toString());
                }
                writer.write(")");
            }
            if (this.getAdditional() != null) {
                writer.write(" " + this.getAdditional());
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException impossible) {
            return null;
        }
    }

    public String getAdditional() {
        return this.additional;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public String getForeignKeyFieldName() {
        return this.foreignKeyFieldName;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public int getSubSize() {
        return this.subSize;
    }

    public Class getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void setAdditional(String string) {
        this.additional = string;
    }

    public void setConstraint(String string) {
        this.constraint = string;
    }

    public void setForeignKeyFieldName(String foreignKeyFieldName) {
        this.foreignKeyFieldName = foreignKeyFieldName;
    }

    public void setIsIdentity(boolean value) {
        this.isIdentity = value;
        if (value) {
            this.setShouldAllowNull(false);
        }
    }

    public void setIsPrimaryKey(boolean value) {
        this.isPrimaryKey = value;
        if (value) {
            this.setShouldAllowNull(false);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShouldAllowNull(boolean value) {
        this.shouldAllowNull = value;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setSubSize(int subSize) {
        this.subSize = subSize;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setUnique(boolean value) {
        this.isUnique = value;
    }

    public boolean shouldAllowNull() {
        return this.shouldAllowNull;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getName() + "(" + this.getType() + "))";
    }
}

