/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.Statistics;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenSupport;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;

public final class FolderObj
extends BaseFileObj {
    static final long serialVersionUID = -1022430210876356809L;
    private static final Mutex.Privileged mp;
    private static final Mutex mutex;
    private final FolderChildrenCache folderChildren = new FolderChildrenCache();
    boolean valid = true;
    private int bitmask = 0;
    static final String LIGHTWEIGHT_LOCK_SET = "LIGHTWEIGHT_LOCK_SET";
    private static int LIGHTWEIGHT_LOCK;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FolderObj(File file, FileNaming name) {
        super(file, name);
    }

    public final boolean isFolder() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject getFileObject(String name, String ext) {
        FileNaming child;
        File file;
        FileObject retVal = null;
        File f = this.getFileName().getFile();
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged mutexPrivileged = childrenCache.getMutexPrivileged();
        mutexPrivileged.enterReadAccess();
        try {
            file = BaseFileObj.getFile(f, name, ext);
            String nameExt = BaseFileObj.getNameExt(file);
            child = childrenCache.getChild(nameExt, false);
        }
        finally {
            mutexPrivileged.exitReadAccess();
        }
        FileBasedFileSystem lfs = this.getLocalFileSystem();
        if (!$assertionsDisabled && lfs == null) {
            throw new AssertionError();
        }
        if (child != null) {
            retVal = lfs.findFileObject(file);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject[] getChildren() {
        HashSet fileNames;
        ArrayList<FileObject> results = new ArrayList<FileObject>();
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged mutexPrivileged = childrenCache.getMutexPrivileged();
        mutexPrivileged.enterWriteAccess();
        try {
            fileNames = new HashSet(childrenCache.getChildren(true));
        }
        finally {
            mutexPrivileged.exitWriteAccess();
        }
        FileBasedFileSystem lfs = this.getLocalFileSystem();
        Iterator iterator = fileNames.iterator();
        while (iterator.hasNext()) {
            FileNaming fileName = (FileNaming)iterator.next();
            FileInfo fInfo = new FileInfo(fileName.getFile());
            fInfo.setFileNaming(fileName);
            fInfo.setValueForFlag(2, true);
            FileObject fo = lfs.findFileObject(fInfo);
            if (fo == null) continue;
            results.add(fo);
        }
        return results.toArray(new FileObject[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject createFolder(String name) throws IOException {
        File folder2Create;
        if (name.indexOf(92) != -1 || name.indexOf(47) != -1) {
            throw new IllegalArgumentException(name);
        }
        BaseFileObj retVal = null;
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged mutexPrivileged = childrenCache.getMutexPrivileged();
        mutexPrivileged.enterWriteAccess();
        try {
            folder2Create = BaseFileObj.getFile(this.getFileName().getFile(), name, null);
            this.createFolder(folder2Create, name);
            FileNaming childName = this.getChildrenCache().getChild(folder2Create.getName(), true);
            NamingFactory.checkCaseSensitivity(childName, folder2Create);
            if (!$assertionsDisabled && childName == null) {
                throw new AssertionError();
            }
        }
        finally {
            mutexPrivileged.exitWriteAccess();
        }
        FileBasedFileSystem localFileBasedFileSystem = this.getLocalFileSystem();
        if (localFileBasedFileSystem != null) {
            if (!($assertionsDisabled || folder2Create.exists() && folder2Create.isDirectory())) {
                throw new AssertionError((Object)folder2Create.getAbsolutePath());
            }
            retVal = (FolderObj)localFileBasedFileSystem.findFileObject(folder2Create);
        }
        if (!$assertionsDisabled && retVal == null) {
            throw new AssertionError((Object)folder2Create.getAbsolutePath());
        }
        retVal.fireFileFolderCreatedEvent(false);
        return retVal;
    }

    private void createFolder(File folder2Create, String name) throws IOException {
        boolean isSupported = new FileInfo(folder2Create).isSupportedFile();
        if (!isSupported) {
            FSException.io("EXC_CannotCreateFolder", folder2Create.getName(), this.getPath());
        } else if (folder2Create.exists()) {
            FSException.io("EXC_CannotCreateFolder", folder2Create.getName(), this.getPath());
        } else if (!folder2Create.mkdirs()) {
            FSException.io("EXC_CannotCreateFolder", folder2Create.getName(), this.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject createData(String name, String ext) throws IOException {
        File file2Create;
        if (name.indexOf(92) != -1 || name.indexOf(47) != -1) {
            throw new IllegalArgumentException(name);
        }
        ChildrenCache childrenCache = this.getChildrenCache();
        Mutex.Privileged mutexPrivileged = childrenCache.getMutexPrivileged();
        mutexPrivileged.enterWriteAccess();
        try {
            file2Create = BaseFileObj.getFile(this.getFileName().getFile(), name, ext);
            this.createData(file2Create);
            FileNaming childName = this.getChildrenCache().getChild(file2Create.getName(), true);
            NamingFactory.checkCaseSensitivity(childName, file2Create);
            if (!$assertionsDisabled && childName == null) {
                throw new AssertionError();
            }
        }
        finally {
            mutexPrivileged.exitWriteAccess();
        }
        FileBasedFileSystem localFileBasedFileSystem = this.getLocalFileSystem();
        BaseFileObj retVal = null;
        if (localFileBasedFileSystem != null) {
            if (!($assertionsDisabled || file2Create.exists() && !file2Create.isDirectory())) {
                throw new AssertionError((Object)file2Create.getAbsolutePath());
            }
            retVal = (FileObj)localFileBasedFileSystem.findFileObject(file2Create);
        }
        if (!$assertionsDisabled && retVal == null) {
            throw new AssertionError();
        }
        retVal.fireFileDataCreatedEvent(false);
        return retVal;
    }

    private void createData(File file2Create) throws IOException {
        boolean isSupported = new FileInfo(file2Create).isSupportedFile();
        if (!isSupported) {
            FSException.io("EXC_CannotCreateData", file2Create.getName(), this.getPath());
        } else if (file2Create.exists()) {
            FSException.io("EXC_CannotCreateData", file2Create.getName(), this.getPath());
        } else if (!file2Create.createNewFile()) {
            FSException.io("EXC_CannotCreateData", file2Create.getName(), this.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(FileLock lock, ProvidedExtensions.DeleteHandler deleteHandler) throws IOException {
        LinkedList all = new LinkedList();
        File file = this.getFileName().getFile();
        if (!this.deleteFile(file, all, this.getLocalFileSystem().getFactory(), deleteHandler)) {
            FolderObj parent = this.getExistingParent();
            String parentPath = parent != null ? parent.getPath() : file.getParentFile().getAbsolutePath();
            FSException.io("EXC_CannotDelete", file.getName(), parentPath);
        }
        BaseFileObj.attribs.deleteAttributes(file.getAbsolutePath().replace('\\', '/'));
        this.setValid(false);
        for (int i = 0; i < all.size(); ++i) {
            ChildrenCache childrenCache;
            BaseFileObj toDel = (BaseFileObj)((Object)all.get(i));
            FolderObj existingParent = toDel.getExistingParent();
            ChildrenCache childrenCache2 = childrenCache = existingParent != null ? existingParent.getChildrenCache() : null;
            if (childrenCache != null) {
                Mutex.Privileged mutexPrivileged;
                Mutex.Privileged privileged = mutexPrivileged = childrenCache != null ? childrenCache.getMutexPrivileged() : null;
                if (mutexPrivileged != null) {
                    mutexPrivileged.enterWriteAccess();
                }
                try {
                    if (deleteHandler != null) {
                        childrenCache.removeChild(BaseFileObj.getNameExt(file));
                    } else {
                        childrenCache.getChild(BaseFileObj.getNameExt(file), true);
                    }
                }
                finally {
                    if (mutexPrivileged != null) {
                        mutexPrivileged.exitWriteAccess();
                    }
                }
            }
            toDel.setValid(false);
            toDel.fireFileDeletedEvent(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(boolean expected, boolean fire) {
        Statistics.StopWatch stopWatch = Statistics.getStopWatch(Statistics.REFRESH_FOLDER);
        stopWatch.start();
        if (this.isValid()) {
            ChildrenCache cache = this.getChildrenCache();
            Mutex.Privileged mutexPrivileged = cache.getMutexPrivileged();
            Set oldChildren = null;
            Map refreshResult = null;
            mutexPrivileged.enterWriteAccess();
            try {
                oldChildren = cache.getChildren(false);
                refreshResult = cache.refresh();
            }
            finally {
                mutexPrivileged.exitWriteAccess();
            }
            oldChildren.removeAll(refreshResult.keySet());
            Iterator iterator = oldChildren.iterator();
            while (iterator.hasNext()) {
                FileName child = (FileName)iterator.next();
                BaseFileObj childObj = this.getLocalFileSystem().getFactory().get(child.getFile());
                if (childObj == null || !childObj.isData()) continue;
                ((FileObj)childObj).refresh(expected);
            }
            FileBasedFileSystem localFileSystem = this.getLocalFileSystem();
            FileObjectFactory factory = localFileSystem.getFactory();
            Iterator iterator2 = refreshResult.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                FileName child = (FileName)entry.getKey();
                Integer operationId = (Integer)entry.getValue();
                BaseFileObj newChild = operationId == ChildrenCache.ADDED_CHILD ? (BaseFileObj)factory.findFileObject(new FileInfo(child.getFile())) : factory.get(child.getFile());
                BaseFileObj baseFileObj = newChild = newChild != null ? newChild : this.getFileObject(child.getName());
                if (operationId == ChildrenCache.ADDED_CHILD && newChild != null) {
                    if (newChild.isFolder()) {
                        if (!fire) continue;
                        newChild.fireFileFolderCreatedEvent(expected);
                        continue;
                    }
                    if (!fire) continue;
                    newChild.fireFileDataCreatedEvent(expected);
                    continue;
                }
                if (operationId == ChildrenCache.REMOVED_CHILD) {
                    if (newChild != null) {
                        if (!newChild.isValid()) continue;
                        newChild.setValid(false);
                        if (!fire) continue;
                        newChild.fireFileDeletedEvent(expected);
                        continue;
                    }
                    File f = child.getFile();
                    if (new FileInfo(f).isConvertibleToFileObject()) continue;
                    BaseFileObj fakeInvalid = child.isFile() ? new FileObj(f, child) : new FolderObj(f, child);
                    fakeInvalid.setValid(false);
                    if (!fire) continue;
                    fakeInvalid.fireFileDeletedEvent(expected);
                    continue;
                }
                if (!$assertionsDisabled && new FileInfo(child.getFile()).isConvertibleToFileObject()) {
                    throw new AssertionError();
                }
            }
            boolean validityFlag = this.getFileName().getFile().exists();
            if (!validityFlag) {
                this.setValid(false);
                if (fire) {
                    this.fireFileDeletedEvent(expected);
                }
            }
        }
        stopWatch.stop();
    }

    public final void refresh(boolean expected) {
        this.refresh(expected, true);
    }

    private boolean deleteFile(File file, LinkedList all, FileObjectFactory factory, ProvidedExtensions.DeleteHandler deleteHandler) throws IOException {
        BaseFileObj aliveFo;
        boolean retVal;
        boolean ret;
        boolean bl = ret = deleteHandler != null ? deleteHandler.delete(file) : file.delete();
        if (ret) {
            BaseFileObj aliveFo2 = factory.get(file);
            if (aliveFo2 != null) {
                all.addFirst(aliveFo2);
            }
            return true;
        }
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] arr = file.listFiles();
            for (int i = 0; i < arr.length; ++i) {
                File f2Delete = arr[i];
                if (this.deleteFile(f2Delete, all, factory, deleteHandler)) continue;
                return false;
            }
        }
        boolean bl2 = retVal = deleteHandler != null ? deleteHandler.delete(file) : file.delete();
        if (retVal && (aliveFo = factory.get(file)) != null) {
            all.addFirst(aliveFo);
        }
        return true;
    }

    protected void setValid(boolean valid) {
        if (valid) {
            if (!$assertionsDisabled && !this.isValid()) {
                throw new AssertionError((Object)this.toString());
            }
        } else {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public final InputStream getInputStream() throws FileNotFoundException {
        throw new FileNotFoundException(this.getPath());
    }

    public final OutputStream getOutputStream(FileLock lock) throws IOException {
        throw new IOException(this.getPath());
    }

    public final Date lastModified() {
        File f = this.getFileName().getFile();
        return new Date(f.lastModified());
    }

    public final FileLock lock() throws IOException {
        return new FileLock();
    }

    final boolean checkLock(FileLock lock) throws IOException {
        return true;
    }

    public final ChildrenCache getChildrenCache() {
        return this.folderChildren;
    }

    public Object getAttribute(String attrName) {
        if (attrName.equals(LIGHTWEIGHT_LOCK_SET)) {
            this.bitmask |= LIGHTWEIGHT_LOCK;
            return new FileLock(){

                public void releaseLock() {
                    super.releaseLock();
                    FolderObj.this.bitmask &= ~LIGHTWEIGHT_LOCK;
                }
            };
        }
        return super.getAttribute(attrName);
    }

    boolean isLightWeightLockRequired() {
        return (this.bitmask & LIGHTWEIGHT_LOCK) == LIGHTWEIGHT_LOCK;
    }

    static {
        $assertionsDisabled = !FolderObj.class.desiredAssertionStatus();
        mp = new Mutex.Privileged();
        mutex = new Mutex(mp);
        LIGHTWEIGHT_LOCK = 1;
    }

    public final class FolderChildrenCache
    implements ChildrenCache {
        final ChildrenSupport ch = new ChildrenSupport();

        public final Set getChildren(boolean rescan) {
            return this.ch.getChildren(FolderObj.this.getFileName(), rescan);
        }

        public final FileNaming getChild(String childName, boolean rescan) {
            return this.ch.getChild(childName, FolderObj.this.getFileName(), rescan);
        }

        public final Map refresh() {
            return this.ch.refresh(FolderObj.this.getFileName());
        }

        public final Mutex.Privileged getMutexPrivileged() {
            return mp;
        }

        public final String toString() {
            return FolderObj.this.getFileName().toString();
        }

        public boolean existsInCache(String childName) {
            return this.ch.existsldInCache(FolderObj.this.getFileName(), childName);
        }

        public void removeChild(String childName) {
            this.ch.removeChild(FolderObj.this.getFileName(), childName);
        }
    }
}

