/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;

public class MMapDirectory
extends FSDirectory {
    private final int MAX_BBUF = Integer.MAX_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexInput openInput(String name) throws IOException {
        IndexInput indexInput;
        File f = new File(this.getFile(), name);
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        try {
            indexInput = raf.length() <= Integer.MAX_VALUE ? new MMapIndexInput(raf) : new MultiMMapIndexInput(raf, Integer.MAX_VALUE);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            raf.close();
            throw throwable;
        }
        raf.close();
        return indexInput;
    }

    public IndexInput openInput(String name, int bufferSize) throws IOException {
        return this.openInput(name);
    }

    private static class MultiMMapIndexInput
    extends IndexInput {
        private ByteBuffer[] buffers;
        private int[] bufSizes;
        private final long length;
        private int curBufIndex;
        private final int maxBufSize;
        private ByteBuffer curBuf;
        private int curAvail;

        public MultiMMapIndexInput(RandomAccessFile raf, int maxBufSize) throws IOException {
            this.length = raf.length();
            this.maxBufSize = maxBufSize;
            if (maxBufSize <= 0) {
                throw new IllegalArgumentException("Non positive maxBufSize: " + maxBufSize);
            }
            if (this.length / (long)maxBufSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("RandomAccessFile too big for maximum buffer size: " + raf.toString());
            }
            int nrBuffers = (int)(this.length / (long)maxBufSize);
            if ((long)(nrBuffers * maxBufSize) < this.length) {
                ++nrBuffers;
            }
            this.buffers = new ByteBuffer[nrBuffers];
            this.bufSizes = new int[nrBuffers];
            long bufferStart = 0L;
            FileChannel rafc = raf.getChannel();
            for (int bufNr = 0; bufNr < nrBuffers; ++bufNr) {
                int bufSize = this.length > bufferStart + (long)maxBufSize ? maxBufSize : (int)(this.length - bufferStart);
                this.buffers[bufNr] = rafc.map(FileChannel.MapMode.READ_ONLY, bufferStart, bufSize);
                this.bufSizes[bufNr] = bufSize;
                bufferStart += (long)bufSize;
            }
            this.seek(0L);
        }

        public byte readByte() throws IOException {
            if (this.curAvail == 0) {
                ++this.curBufIndex;
                this.curBuf = this.buffers[this.curBufIndex];
                this.curBuf.position(0);
                this.curAvail = this.bufSizes[this.curBufIndex];
            }
            --this.curAvail;
            return this.curBuf.get();
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            while (len > this.curAvail) {
                this.curBuf.get(b, offset, this.curAvail);
                len -= this.curAvail;
                offset += this.curAvail;
                ++this.curBufIndex;
                this.curBuf = this.buffers[this.curBufIndex];
                this.curBuf.position(0);
                this.curAvail = this.bufSizes[this.curBufIndex];
            }
            this.curBuf.get(b, offset, len);
            this.curAvail -= len;
        }

        public long getFilePointer() {
            return (long)this.curBufIndex * (long)this.maxBufSize + (long)this.curBuf.position();
        }

        public void seek(long pos) throws IOException {
            this.curBufIndex = (int)(pos / (long)this.maxBufSize);
            this.curBuf = this.buffers[this.curBufIndex];
            int bufOffset = (int)(pos - (long)(this.curBufIndex * this.maxBufSize));
            this.curBuf.position(bufOffset);
            this.curAvail = this.bufSizes[this.curBufIndex] - bufOffset;
        }

        public long length() {
            return this.length;
        }

        public Object clone() {
            MultiMMapIndexInput clone = (MultiMMapIndexInput)super.clone();
            clone.buffers = new ByteBuffer[this.buffers.length];
            for (int bufNr = 0; bufNr < this.buffers.length; ++bufNr) {
                clone.buffers[bufNr] = this.buffers[bufNr].duplicate();
            }
            try {
                clone.seek(this.getFilePointer());
            }
            catch (IOException ioe) {
                RuntimeException newException = new RuntimeException(ioe);
                newException.initCause(ioe);
                throw newException;
            }
            return clone;
        }

        public void close() throws IOException {
        }
    }

    private static class MMapIndexInput
    extends IndexInput {
        private ByteBuffer buffer;
        private final long length;

        private MMapIndexInput(RandomAccessFile raf) throws IOException {
            this.length = raf.length();
            this.buffer = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.length);
        }

        public byte readByte() throws IOException {
            return this.buffer.get();
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            this.buffer.get(b, offset, len);
        }

        public long getFilePointer() {
            return this.buffer.position();
        }

        public void seek(long pos) throws IOException {
            this.buffer.position((int)pos);
        }

        public long length() {
            return this.length;
        }

        public Object clone() {
            MMapIndexInput clone = (MMapIndexInput)super.clone();
            clone.buffer = this.buffer.duplicate();
            return clone;
        }

        public void close() throws IOException {
        }
    }
}

