# -*- coding: UTF-8 -*-
################################################################################
#
# Copyright (c) 2002-2005, Benjamin Saller <bcsaller@ideasuite.com>, and
#                              the respective authors. All rights reserved.
# For a list of Archetypes contributors see docs/CREDITS.txt.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice, this
#   list of conditions and the following disclaimer.
# * Redistributions in binary form must reproduce the above copyright notice,
#   this list of conditions and the following disclaimer in the documentation
#   and/or other materials provided with the distribution.
# * Neither the name of the author nor the names of its contributors may be used
#   to endorse or promote products derived from this software without specific
#   prior written permission.
#
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
################################################################################
"""
"""

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))


from Testing import ZopeTestCase

from Products.Archetypes.tests.attestcase import ATTestCase

from Products.validation import validation as validationService

class TestValidation(ATTestCase):
    def test_inNumericRange(self):
        v = validationService.validatorFor('inNumericRange')
        self.failUnlessEqual(v(10, 1, 20), 1)
        self.failUnlessEqual(v('10', 1, 20), 1)
        self.failIfEqual(v(0, 4, 5), 1)

    def test_isPrintable(self):
        v = validationService.validatorFor('isPrintable')
        self.failUnlessEqual(v('text'), 1)
        self.failIfEqual(v('\u203'), 1)
        self.failIfEqual(v(10), 1)

    def test_isSSN(self):
        v = validationService.validatorFor('isSSN')
        self.failUnlessEqual(v('111223333'), 1)
        self.failUnlessEqual(v('111-22-3333', ignore=r'-'), 1)

    def test_isUSPhoneNumber(self):
        v = validationService.validatorFor('isUSPhoneNumber')
        self.failUnlessEqual(v('(212) 555-1212',
                               ignore=r'[\s\(\)\-]'), 1)
        self.failUnlessEqual(v('2125551212',
                               ignore=r'[\s\(\)\-]'), 1)

        self.failUnlessEqual(v('(212) 555-1212'), 1)


    def test_isURL(self):
        v = validationService.validatorFor('isURL')
        self.failUnlessEqual(v('http://foo.bar:8080/manage'), 1)
        self.failIfEqual(v('http://\n'), 1)
        self.failIfEqual(v('../foo/bar'), 1)


    def test_isEmail(self):
        v = validationService.validatorFor('isEmail')
        self.failUnlessEqual(v('test@test.com'), 1)
        self.failIfEqual(v('@foo.bar'), 1)
        self.failIfEqual(v('me'), 1)

    def test_isUnixLikeName(self):
        v = validationService.validatorFor('isUnixLikeName')
        self.failUnlessEqual(v('abcd'), 1)
        self.failUnlessEqual(v('a_123456'), 1)
        self.failIfEqual(v('123'), 1)
        self.failIfEqual(v('ab.c'), 1)
        self.failIfEqual(v('ab,c'),1 )
        self.failIfEqual(v('aaaaaaaab'), 1) # too long


def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    suite.addTest(makeSuite(TestValidation))
    return suite

if __name__ == '__main__':
    framework()
