/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragAndDropEffect;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

class TreeDragAndDropEffect
extends DragAndDropEffect {
    Tree tree;
    int scrollIndex = -1;
    long scrollBeginTime;
    int expandIndex = -1;
    long expandBeginTime;
    static final int SCROLL_HYSTERESIS = 150;
    static final int EXPAND_HYSTERESIS = 300;

    TreeDragAndDropEffect(Tree tree) {
        this.tree = tree;
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    Widget getItem(int x, int y) {
        Rectangle area;
        Point coordinates = new Point(x, y);
        TreeItem item = this.tree.getItem(coordinates = this.tree.toControl(coordinates));
        if (item == null && (area = this.tree.getClientArea()).contains(coordinates)) {
            int x1 = area.x;
            while (x1 < area.x + area.width) {
                Point pt = new Point(x1, coordinates.y);
                item = this.tree.getItem(pt);
                if (item != null) break;
                ++x1;
            }
        }
        return item;
    }

    ImageData getDragSourceImage(int x, int y) {
        long[] model;
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            return null;
        }
        long handle = this.tree.handle;
        long selection = OS.gtk_tree_view_get_selection(handle);
        long list = OS.gtk_tree_selection_get_selected_rows(selection, model = OS.GTK_VERSION < OS.VERSION(2, 2, 4) ? new long[1] : null);
        if (list == 0L) {
            return null;
        }
        int count = Math.min(10, OS.g_list_length(list));
        Image image = null;
        Display display = this.tree.getDisplay();
        if (count == 1) {
            long path = OS.g_list_nth_data(list, 0);
            long pixmap = OS.gtk_tree_view_create_row_drag_icon(handle, path);
            image = Image.gtk_new(display, 1, pixmap, 0L);
        } else {
            int width = 0;
            int height = 0;
            int[] w = new int[1];
            int[] h = new int[1];
            int[] yy = new int[count];
            int[] hh = new int[count];
            long[] pixmaps = new long[count];
            GdkRectangle rect = new GdkRectangle();
            int i = 0;
            while (i < count) {
                long path = OS.g_list_nth_data(list, i);
                OS.gtk_tree_view_get_cell_area(handle, path, 0L, rect);
                pixmaps[i] = OS.gtk_tree_view_create_row_drag_icon(handle, path);
                OS.gdk_drawable_get_size(pixmaps[i], w, h);
                width = Math.max(width, w[0]);
                height = rect.y + h[0] - yy[0];
                yy[i] = rect.y;
                hh[i] = h[0];
                ++i;
            }
            long source = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), width, height, -1);
            long gcSource = OS.gdk_gc_new(source);
            long mask = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), width, height, 1);
            long gcMask = OS.gdk_gc_new(mask);
            GdkColor color = new GdkColor();
            color.pixel = 0;
            OS.gdk_gc_set_foreground(gcMask, color);
            OS.gdk_draw_rectangle(mask, gcMask, 1, 0, 0, width, height);
            color.pixel = 1;
            OS.gdk_gc_set_foreground(gcMask, color);
            int i2 = 0;
            while (i2 < count) {
                OS.gdk_draw_drawable(source, gcSource, pixmaps[i2], 0, 0, 0, yy[i2] - yy[0], -1, -1);
                OS.gdk_draw_rectangle(mask, gcMask, 1, 0, yy[i2] - yy[0], width, hh[i2]);
                OS.g_object_unref(pixmaps[i2]);
                ++i2;
            }
            OS.g_object_unref(gcSource);
            OS.g_object_unref(gcMask);
            image = Image.gtk_new(display, 1, source, mask);
        }
        OS.g_list_free(list);
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    void showDropTargetEffect(int effect, int x, int y) {
        long indices;
        effect = this.checkEffect(effect);
        long handle = this.tree.handle;
        Point coordinates = new Point(x, y);
        coordinates = this.tree.toControl(coordinates);
        long[] path = new long[1];
        OS.gtk_tree_view_get_path_at_pos(handle, coordinates.x, coordinates.y, path, null, null, null);
        int index = -1;
        if (path[0] != 0L && (indices = OS.gtk_tree_path_get_indices(path[0])) != 0L) {
            int depth = OS.gtk_tree_path_get_depth(path[0]);
            int[] temp = new int[depth];
            OS.memmove(temp, indices, (long)(temp.length * 4));
            index = temp[temp.length - 1];
        }
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (index != -1 && this.scrollIndex == index && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                GdkRectangle cellRect = new GdkRectangle();
                OS.gtk_tree_view_get_cell_area(handle, path[0], 0L, cellRect);
                if (cellRect.y < cellRect.height) {
                    int[] tx = new int[1];
                    int[] ty = new int[1];
                    OS.gtk_tree_view_widget_to_tree_coords(handle, cellRect.x, cellRect.y - cellRect.height, tx, ty);
                    OS.gtk_tree_view_scroll_to_point(handle, -1, ty[0]);
                } else {
                    OS.gtk_tree_view_get_path_at_pos(handle, coordinates.x, coordinates.y + cellRect.height, path, null, null, null);
                    if (path[0] != 0L) {
                        OS.gtk_tree_view_scroll_to_cell(handle, path[0], 0L, false, 0.0f, 0.0f);
                        OS.gtk_tree_path_free(path[0]);
                        path[0] = 0L;
                    }
                    OS.gtk_tree_view_get_path_at_pos(handle, coordinates.x, coordinates.y, path, null, null, null);
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollIndex = index;
        }
        if ((effect & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandIndex = -1;
        } else if (index != -1 && this.expandIndex == index && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                OS.gtk_tree_view_expand_row(handle, path[0], false);
                this.expandBeginTime = 0L;
                this.expandIndex = -1;
            }
        } else {
            this.expandBeginTime = System.currentTimeMillis() + 300L;
            this.expandIndex = index;
        }
        if (path[0] != 0L) {
            int position = -1;
            if ((effect & 1) != 0) {
                position = 2;
            }
            if ((effect & 2) != 0) {
                position = 0;
            }
            if ((effect & 4) != 0) {
                position = 1;
            }
            if (position != -1) {
                OS.gtk_tree_view_set_drag_dest_row(handle, path[0], position);
            } else {
                OS.gtk_tree_view_unset_rows_drag_dest(handle);
            }
        } else {
            OS.gtk_tree_view_unset_rows_drag_dest(handle);
        }
        if (path[0] != 0L) {
            OS.gtk_tree_path_free(path[0]);
        }
    }
}

