/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.run;

import br.arca.morcego.Config;
import br.arca.morcego.run.Animator;
import br.arca.morcego.structure.Graph;
import br.arca.morcego.structure.Node;
import br.arca.morcego.transport.Transport;
import java.util.Enumeration;
import java.util.Vector;

public class Feeder
implements Runnable {
    private Graph graph;
    private Transport transport;
    private Animator animator;
    private boolean shouldWait = true;

    public Feeder(Graph g, Transport t) {
        this.graph = g;
        this.transport = t;
        this.animator = new Animator(this.graph);
    }

    private Vector diffGraphs(Graph g1, Graph g2) {
        Vector<Node> diff = new Vector<Node>();
        Enumeration e = g1.getNodes().elements();
        while (e.hasMoreElements()) {
            Node node = (Node)e.nextElement();
            if (g2.getNodeById(node.getId()) != null) continue;
            diff.add(node);
        }
        return diff;
    }

    private Vector intersectGraphs(Graph g1, Graph g2) {
        Vector<Node> intersection = new Vector<Node>();
        Enumeration e = g1.getNodes().elements();
        while (e.hasMoreElements()) {
            Node node = (Node)e.nextElement();
            if (g2.getNodeById(node.getId()) == null) continue;
            intersection.add(node);
        }
        return intersection;
    }

    public void feed(Graph newGraph) {
        Graph graph = newGraph;
        synchronized (graph) {
            Vector removed = this.diffGraphs(this.graph, newGraph);
            Vector added = this.diffGraphs(newGraph, this.graph);
            Vector intersection = this.intersectGraphs(newGraph, this.graph);
            Enumeration e = intersection.elements();
            while (e.hasMoreElements()) {
                Node newNode = (Node)e.nextElement();
                Node oldNode = this.graph.getNodeById(newNode.getId());
                newNode.setBody(oldNode.getBody());
                this.graph.removeNode(oldNode);
                this.graph.addNode(newNode);
                if (!oldNode.centered()) continue;
                this.graph.center(newNode);
            }
            this.animator.animate(added, removed);
        }
    }

    public void notifyFeeder() {
        this.shouldWait = false;
        this.notify();
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        Thread animationThread = new Thread(this.animator);
        animationThread.start();
        while (true) {
            Graph newGraph;
            Feeder feeder = this;
            synchronized (feeder) {
                try {
                    if (this.shouldWait) {
                        this.wait();
                    }
                    this.shouldWait = true;
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                newGraph = this.transport.retrieveData(this.graph.getCenterNode(), (Integer)Config.getValue("morcego.navigationDepth"));
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
            this.feed(newGraph);
        }
    }
}

