/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.catalina.Cluster;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.cluster.ClusterReceiver;
import org.apache.catalina.cluster.ClusterSender;
import org.apache.catalina.cluster.ReplicationWrapper;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.CustomObjectInputStream;

public final class DistributedManager
extends PersistentManagerBase {
    private static final String info = "DistributedManager/1.0";
    protected static String name = "DistributedManager";
    private ClusterSender clusterSender = null;
    private ClusterReceiver clusterReceiver = null;

    public String getInfo() {
        return info;
    }

    public String getName() {
        return name;
    }

    public Session createSession() {
        Session session = super.createSession();
        ObjectOutputStream oos = null;
        ByteArrayOutputStream bos = null;
        Object bis = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            ((StandardSession)session).writeObjectData(oos);
            oos.close();
            byte[] obs = bos.toByteArray();
            this.clusterSender.send(obs);
            if (this.debug > 0) {
                this.log("Replicating Session: " + session.getId());
            }
        }
        catch (IOException e) {
            this.log("An error occurred when replicating Session: " + session.getId());
        }
        return session;
    }

    public void start() throws LifecycleException {
        Container container = this.getContainer();
        Cluster cluster = null;
        if (container != null) {
            cluster = container.getCluster();
        }
        if (cluster != null) {
            this.clusterSender = cluster.getClusterSender(this.getName());
            this.clusterReceiver = cluster.getClusterReceiver(this.getName());
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processClusterReceiver() {
        Object[] objs = this.clusterReceiver.getObjects();
        StandardSession _session = null;
        ByteArrayInputStream bis = null;
        Loader loader = null;
        ClassLoader classLoader = null;
        ObjectInputStream ois = null;
        byte[] buf = new byte[5000];
        ReplicationWrapper repObj = null;
        for (int i = 0; i < objs.length; ++i) {
            block14: {
                bis = new ByteArrayInputStream(buf);
                repObj = (ReplicationWrapper)objs[i];
                buf = repObj.getDataStream();
                bis = new ByteArrayInputStream(buf, 0, buf.length);
                if (this.container != null) {
                    loader = this.container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                ois = classLoader != null ? new CustomObjectInputStream(bis, classLoader) : new ObjectInputStream(bis);
                _session = (StandardSession)super.createSession();
                _session.readObjectData(ois);
                _session.setManager(this);
                if (this.debug <= 0) break block14;
                this.log("Loading replicated session: " + _session.getId());
            }
            Object var12_13 = null;
            if (ois == null) continue;
            try {
                ois.close();
                bis = null;
            }
            catch (IOException e2) {}
            continue;
            {
                catch (IOException e) {
                    this.log("Error occurred when trying to read replicated session: " + e.toString());
                    var12_13 = null;
                    if (ois == null) continue;
                    try {
                        ois.close();
                        bis = null;
                    }
                    catch (IOException e2) {}
                    continue;
                }
                catch (ClassNotFoundException e) {
                    this.log("Error occurred when trying to read replicated session: " + e.toString());
                    var12_13 = null;
                    if (ois == null) continue;
                    try {
                        ois.close();
                        bis = null;
                    }
                    catch (IOException e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var12_13 = null;
                if (ois != null) {
                    try {
                        ois.close();
                        bis = null;
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processClusterReceiver();
            this.processExpires();
            this.processPersistenceChecks();
        }
    }
}

