/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Library;

public class AprLifecycleListener
implements LifecycleListener {
    private static Log log = LogFactory.getLog(AprLifecycleListener.class);
    protected StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected static final int TCN_REQUIRED_MAJOR = 1;
    protected static final int TCN_REQUIRED_MINOR = 1;
    protected static final int TCN_REQUIRED_PATCH = 8;
    protected static final int TCN_RECOMMENDED_PV = 10;
    protected static String SSLEngine = "on";
    protected static String SSLRandomSeed = "builtin";
    protected static boolean sslInitialized = false;
    protected static boolean aprInitialized = false;

    public void lifecycleEvent(LifecycleEvent event) {
        block11: {
            if ("init".equals(event.getType())) {
                aprInitialized = this.init();
                if (aprInitialized) {
                    try {
                        AprLifecycleListener.initializeSSL();
                    }
                    catch (Throwable t) {
                        if (!log.isDebugEnabled()) {
                            log.info((Object)this.sm.getString("aprListener.sslInit"));
                            break block11;
                        }
                        log.debug((Object)this.sm.getString("aprListener.sslInit"), t);
                    }
                }
            } else if ("after_stop".equals(event.getType())) {
                if (!aprInitialized) {
                    return;
                }
                try {
                    AprLifecycleListener.terminateAPR();
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) {
                        log.info((Object)this.sm.getString("aprListener.aprDestroy"));
                    }
                    log.debug((Object)this.sm.getString("aprListener.aprDestroy"), t);
                }
            }
        }
    }

    private static synchronized void terminateAPR() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String methodName = "terminate";
        Method method = Class.forName("org.apache.tomcat.jni.Library").getMethod(methodName, null);
        method.invoke(null, (Object[])null);
    }

    private boolean init() {
        int major = 0;
        int minor = 0;
        int patch = 0;
        if (aprInitialized) {
            return true;
        }
        try {
            String methodName = "initialize";
            Class[] paramTypes = new Class[]{String.class};
            Object[] paramValues = new Object[]{null};
            Class<?> clazz = Class.forName("org.apache.tomcat.jni.Library");
            Method method = clazz.getMethod(methodName, paramTypes);
            method.invoke(null, paramValues);
            major = clazz.getField("TCN_MAJOR_VERSION").getInt(null);
            minor = clazz.getField("TCN_MINOR_VERSION").getInt(null);
            patch = clazz.getField("TCN_PATCH_VERSION").getInt(null);
        }
        catch (Throwable t) {
            if (!log.isDebugEnabled()) {
                log.info((Object)this.sm.getString("aprListener.aprInit", System.getProperty("java.library.path")));
            } else {
                log.debug((Object)this.sm.getString("aprListener.aprInit", System.getProperty("java.library.path")), t);
            }
            return false;
        }
        if (major != 1 || minor != 1 || patch < 8) {
            log.error((Object)this.sm.getString("aprListener.tcnInvalid", major + "." + minor + "." + patch, "1.1.8"));
            try {
                AprLifecycleListener.terminateAPR();
            }
            catch (Throwable t) {
                // empty catch block
            }
            return false;
        }
        if (patch < 10) {
            if (!log.isDebugEnabled()) {
                log.info((Object)this.sm.getString("aprListener.tcnVersion", major + "." + minor + "." + patch, "1.1.10"));
            } else {
                log.debug((Object)this.sm.getString("aprListener.tcnVersion", major + "." + minor + "." + patch, "1.1.10"));
            }
        }
        if (!log.isDebugEnabled()) {
            log.info((Object)this.sm.getString("aprListener.tcnValid", major + "." + minor + "." + patch));
        } else {
            log.debug((Object)this.sm.getString("aprListener.tcnValid", major + "." + minor + "." + patch));
        }
        log.info((Object)this.sm.getString("aprListener.flags", Library.APR_HAVE_IPV6, Library.APR_HAS_SENDFILE, Library.APR_HAS_SO_ACCEPTFILTER, Library.APR_HAS_RANDOM));
        return true;
    }

    private static synchronized void initializeSSL() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if ("off".equalsIgnoreCase(SSLEngine)) {
            return;
        }
        if (sslInitialized) {
            return;
        }
        String methodName = "randSet";
        Class[] paramTypes = new Class[]{String.class};
        Object[] paramValues = new Object[]{SSLRandomSeed};
        Class<?> clazz = Class.forName("org.apache.tomcat.jni.SSL");
        Method method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        methodName = "initialize";
        paramValues[0] = "on".equalsIgnoreCase(SSLEngine) ? null : SSLEngine;
        method = clazz.getMethod(methodName, paramTypes);
        method.invoke(null, paramValues);
        sslInitialized = true;
    }

    public String getSSLEngine() {
        return SSLEngine;
    }

    public void setSSLEngine(String SSLEngine) {
        AprLifecycleListener.SSLEngine = SSLEngine;
    }

    public String getSSLRandomSeed() {
        return SSLRandomSeed;
    }

    public void setSSLRandomSeed(String SSLRandomSeed) {
        AprLifecycleListener.SSLRandomSeed = SSLRandomSeed;
    }
}

