/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.io.IOException;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.resources.ResourceLinksForm;
import org.apache.webapp.admin.resources.ResourceUtils;

public final class DeleteResourceLinksAction
extends Action {
    private MBeanServer mserver = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        MessageResources resources = this.getResources(request);
        Locale locale = this.getLocale(request);
        if (this.isCancelled(request)) {
            return mapping.findForward("List Resource Links Setup");
        }
        if (!this.isTokenValid(request)) {
            response.sendError(400, resources.getMessage(locale, "users.error.token"));
            return null;
        }
        ResourceLinksForm resourceLinksForm = (ResourceLinksForm)form;
        String[] resourceLinks = resourceLinksForm.getResourceLinks();
        if (resourceLinks == null) {
            resourceLinks = new String[]{};
        }
        try {
            String resourcetype = resourceLinksForm.getResourcetype();
            String path = resourceLinksForm.getPath();
            String host = resourceLinksForm.getHost();
            ObjectName dname = null;
            String[] signature = new String[]{"java.lang.String"};
            Object[] params = new String[1];
            for (int i = 0; i < resourceLinks.length; ++i) {
                ObjectName oname = new ObjectName(resourceLinks[i]);
                String domain = oname.getDomain();
                dname = ResourceUtils.getNamingResourceObjectName(domain, resourcetype, path, host);
                params[0] = oname.getKeyProperty("name");
                this.mserver.invoke(dname, "removeResourceLink", params, signature);
            }
        }
        catch (Throwable t) {
            this.getServlet().log(resources.getMessage(locale, "users.error.invoke", (Object)"removeResource"), t);
            response.sendError(500, resources.getMessage(locale, "users.error.invoke", (Object)"removeResource"));
            return null;
        }
        return mapping.findForward("ResourceLinks List Setup");
    }
}

