/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.layout.LayoutEdge;
import ca.sqlpower.architect.layout.LayoutNode;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.IERelationshipUI;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.RelationshipUI;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.event.PlayPenComponentEvent;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.MouseInputAdapter;
import org.apache.log4j.Logger;

public class Relationship
extends PlayPenComponent
implements Selectable,
SQLObjectListener,
LayoutEdge {
    private static final Logger logger = Logger.getLogger(Relationship.class);
    protected SQLRelationship model;
    protected TablePane pkTable;
    protected TablePane fkTable;
    protected JPopupMenu popup;
    protected boolean selected;
    private PlayPenComponentListener ppcListener = new PlayPenComponentListener();
    private List<SelectionListener> selectionListeners = new LinkedList<SelectionListener>();
    private Color columnHighlightColour = Color.red;

    public Relationship(Relationship r, PlayPenContentPane contentPane, TablePane pkTable, TablePane fkTable) {
        super(contentPane);
        this.model = r.model;
        this.pkTable = r.pkTable;
        this.fkTable = r.fkTable;
        this.popup = r.popup;
        this.selected = false;
        this.ppcListener = new PlayPenComponentListener();
        this.columnHighlightColour = r.columnHighlightColour;
        this.selectionListeners = new ArrayList<SelectionListener>();
        try {
            RelationshipUI ui = (RelationshipUI)r.getUI().getClass().newInstance();
            ui.installUI(this);
            this.setUI(ui);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Woops, couldn't invoke no-args constructor of " + r.getUI().getClass().getName());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Woops, couldn't access no-args constructor of " + r.getUI().getClass().getName());
        }
    }

    public Relationship(PlayPen parentPP, SQLRelationship model) throws ArchitectException {
        super(parentPP.getPlayPenContentPane());
        this.model = model;
        this.setPkTable(this.getPlayPen().findTablePane(model.getPkTable()));
        this.setFkTable(this.getPlayPen().findTablePane(model.getFkTable()));
        this.setup();
    }

    protected void setup() {
        this.updateUI();
        this.setOpaque(false);
        this.setBackground(Color.green);
        this.model.addSQLObjectListener(this);
        this.setToolTipText(this.model.getName());
        this.createPopup();
    }

    protected void createPopup() {
        ArchitectFrame af = ArchitectFrame.getMainInstance();
        this.popup = new JPopupMenu();
        JMenuItem mi = new JMenuItem(af.editRelationshipAction);
        mi.setActionCommand("PlayPen");
        this.popup.add(mi);
        mi = new JMenuItem(af.deleteSelectedAction);
        mi.setActionCommand("PlayPen");
        this.popup.add(mi);
        if (logger.isDebugEnabled()) {
            mi = new JMenuItem(new AbstractAction("Show Mappings"){

                public void actionPerformed(ActionEvent e) {
                    StringBuffer componentList = new StringBuffer();
                    for (SQLRelationship.ColumnMapping columnMap : Relationship.this.getModel().getMappings()) {
                        componentList.append(columnMap).append("\n");
                    }
                    JOptionPane.showMessageDialog(ArchitectFrame.getMainInstance(), new JScrollPane(new JTextArea(componentList.toString())));
                }
            });
            this.popup.add(mi);
        }
    }

    public Point getPreferredLocation() {
        return ((RelationshipUI)this.getUI()).getPreferredLocation();
    }

    public String toString() {
        return "Relationship: " + this.model;
    }

    public void updateUI() {
        RelationshipUI ui = (RelationshipUI)IERelationshipUI.createUI(this);
        ui.installUI(this);
        this.setUI(ui);
        this.revalidate();
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListeners.add(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.selectionListeners.remove(l);
    }

    protected void fireSelectionEvent(SelectionEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Notifying " + this.selectionListeners.size() + " listeners of selection change"));
        }
        Iterator<SelectionListener> it = this.selectionListeners.iterator();
        if (e.getType() == 1) {
            while (it.hasNext()) {
                it.next().itemSelected(e);
            }
        } else if (e.getType() == 2) {
            while (it.hasNext()) {
                it.next().itemDeselected(e);
            }
        } else {
            throw new IllegalStateException("Unknown selection event type " + e.getType());
        }
    }

    public void setSelected(boolean isSelected, int multiSelectType) {
        if (this.selected != isSelected) {
            try {
                for (SQLRelationship.ColumnMapping m : this.getModel().getChildren()) {
                    if (isSelected) {
                        this.pkTable.addColumnHighlight(m.getPkColumn(), this.columnHighlightColour);
                        this.fkTable.addColumnHighlight(m.getFkColumn(), this.columnHighlightColour);
                        continue;
                    }
                    this.pkTable.removeColumnHighlight(m.getPkColumn(), this.columnHighlightColour);
                    this.fkTable.removeColumnHighlight(m.getFkColumn(), this.columnHighlightColour);
                }
            }
            catch (ArchitectException e) {
                logger.error((Object)"Couldn't modify highlights for columns in the mapping", (Throwable)e);
            }
            this.selected = isSelected;
            this.fireSelectionEvent(new SelectionEvent(this, this.selected ? 1 : 2, 4));
            this.repaint();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String getUIClassID() {
        return "RelationshipUI";
    }

    public SQLRelationship getModel() {
        return this.model;
    }

    public void setPkTable(TablePane tp) {
        if (this.pkTable != null) {
            this.pkTable.removePlayPenComponentListener(this.ppcListener);
        }
        this.pkTable = tp;
        this.pkTable.addPlayPenComponentListener(this.ppcListener);
    }

    public TablePane getPkTable() {
        return this.pkTable;
    }

    public void setFkTable(TablePane tp) {
        if (this.fkTable != null) {
            this.fkTable.removePlayPenComponentListener(this.ppcListener);
        }
        this.fkTable = tp;
        this.fkTable.addPlayPenComponentListener(this.ppcListener);
    }

    public TablePane getFkTable() {
        return this.fkTable;
    }

    public Point getPkConnectionPoint() {
        return ((RelationshipUI)this.getUI()).getPkConnectionPoint();
    }

    public Point getFkConnectionPoint() {
        return ((RelationshipUI)this.getUI()).getFkConnectionPoint();
    }

    public void setPkConnectionPoint(Point p) {
        ((RelationshipUI)this.getUI()).setPkConnectionPoint(p);
        this.revalidate();
    }

    public void setFkConnectionPoint(Point p) {
        ((RelationshipUI)this.getUI()).setFkConnectionPoint(p);
        this.revalidate();
    }

    public void dbChildrenInserted(SQLObjectEvent e) {
    }

    public void dbChildrenRemoved(SQLObjectEvent e) {
    }

    public void dbObjectChanged(SQLObjectEvent e) {
        if (e.getPropertyName() != null) {
            if (e.getPropertyName().equals("name")) {
                this.setToolTipText(this.model.getName());
            } else if (e.getPropertyName().equals("identifying") || e.getPropertyName().equals("pkCardinality") || e.getPropertyName().equals("fkCardinality")) {
                this.repaint();
            }
        }
    }

    public void dbStructureChanged(SQLObjectEvent e) {
    }

    public boolean intersects(Rectangle region) {
        return ((RelationshipUI)this.getUI()).intersects(region);
    }

    public LayoutNode getHeadNode() {
        return this.fkTable;
    }

    public LayoutNode getTailNode() {
        return this.pkTable;
    }

    protected static class RelationshipDecorationMover
    extends MouseInputAdapter {
        protected Relationship r;
        protected boolean movingPk;

        public RelationshipDecorationMover(Relationship r, boolean movePk) {
            this.r = r;
            this.movingPk = movePk;
            r.getPlayPen().addMouseMotionListener(this);
            r.getPlayPen().addMouseListener(this);
            r.getPlayPen().setCursor(Cursor.getPredefinedCursor(13));
        }

        public void mouseMoved(MouseEvent e) {
            Point p = new Point(e.getPoint());
            this.r.getPlayPen().unzoomPoint(p);
            if (this.movingPk) {
                this.r.setPkConnectionPoint(this.translatePoint(p));
            } else {
                this.r.setFkConnectionPoint(this.translatePoint(p));
            }
        }

        public void mouseDragged(MouseEvent e) {
            this.mouseMoved(e);
        }

        protected Point translatePoint(Point p) {
            if (this.movingPk) {
                p.x -= this.r.getPkTable().getX();
                p.y -= this.r.getPkTable().getY();
                p = ((RelationshipUI)this.r.getUI()).closestEdgePoint(this.movingPk, p);
            } else {
                p.x -= this.r.getFkTable().getX();
                p.y -= this.r.getFkTable().getY();
                p = ((RelationshipUI)this.r.getUI()).closestEdgePoint(this.movingPk, p);
            }
            return p;
        }

        public void mouseReleased(MouseEvent e) {
            this.cleanup();
        }

        protected void cleanup() {
            this.r.getPlayPen().removeMouseMotionListener(this);
            this.r.getPlayPen().removeMouseListener(this);
            this.r.getPlayPen().setCursor(null);
        }
    }

    private class PlayPenComponentListener
    implements ca.sqlpower.architect.swingui.event.PlayPenComponentListener {
        private PlayPenComponentListener() {
        }

        public void componentMoved(PlayPenComponentEvent e) {
            logger.debug((Object)("Component " + e.getPPComponent().getName() + " moved"));
            if (e.getPPComponent() == Relationship.this.pkTable || e.getPPComponent() == Relationship.this.fkTable) {
                Relationship.this.revalidate();
            }
        }

        public void componentResized(PlayPenComponentEvent e) {
            logger.debug((Object)("Component " + e.getPPComponent().getName() + " changed size"));
            if (e.getPPComponent() == Relationship.this.pkTable) {
                Relationship.this.setPkConnectionPoint(((RelationshipUI)Relationship.this.getUI()).closestEdgePoint(true, Relationship.this.getPkConnectionPoint()));
            }
            if (e.getPPComponent() == Relationship.this.fkTable) {
                Relationship.this.setFkConnectionPoint(((RelationshipUI)Relationship.this.getUI()).closestEdgePoint(false, Relationship.this.getFkConnectionPoint()));
            }
        }

        public void componentMoveStart(PlayPenComponentEvent e) {
        }

        public void componentMoveEnd(PlayPenComponentEvent e) {
        }
    }
}

