/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.ddl.ConflictResolver;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLWarning;
import ca.sqlpower.architect.ddl.DDLWarningComponent;
import ca.sqlpower.architect.ddl.DDLWarningComponentFactory;
import ca.sqlpower.architect.ddl.GenericDDLGenerator;
import ca.sqlpower.architect.qfa.ArchitectExceptionReportFactory;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectPanel;
import ca.sqlpower.architect.swingui.ArchitectPanelBuilder;
import ca.sqlpower.architect.swingui.DDLExportPanel;
import ca.sqlpower.architect.swingui.MonitorableWorker;
import ca.sqlpower.architect.swingui.SQLScriptDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ExportDDLAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(ExportDDLAction.class);
    private static final String GENDDL_WARNINGS_EXPLANATION = "Errors:\nThe DDL could not be generated because the following error(s) were detected. You need to correct all the errors before we can generate DDL for you. Some errors may have their 'QuickFix' button enabled; holding the mouse over these buttons will tell you what the suggested quick-fix is. If you are OK with the suggestion, press the QuickFix button, otherwise, make the change yourself using the GUI controls following the message.";
    protected ArchitectFrame architectFrame = ArchitectFrame.getMainInstance();
    private JDialog d;

    public ExportDDLAction() {
        super("Forward Engineer...", ASUtils.createIcon("ForwardEngineer", "Forward Engineer", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("ShortDescription", "Forward Engineer SQL Script");
    }

    public void actionPerformed(ActionEvent e) {
        final DDLExportPanel ddlPanel = new DDLExportPanel(this.architectFrame.getProject());
        AbstractAction okAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (ddlPanel.applyChanges()) {
                        GenericDDLGenerator ddlg = ExportDDLAction.this.architectFrame.getProject().getDDLGenerator();
                        ddlg.setTargetSchema(ddlPanel.getSchemaField().getText());
                        boolean done = false;
                        block8: while (!done) {
                            ddlg.generateDDL(ExportDDLAction.this.architectFrame.getProject().getPlayPen().getDatabase());
                            final List warnings = ddlg.getWarnings();
                            final JPanel outerPanel = new JPanel();
                            if (warnings.size() == 0) {
                                done = true;
                                continue;
                            }
                            final ArrayList warningComponents = new ArrayList();
                            ArchitectPanel dialogPanel = new ArchitectPanel(){

                                public boolean applyChanges() {
                                    return false;
                                }

                                public void discardChanges() {
                                }

                                public JComponent getPanel() {
                                    outerPanel.setLayout(new BorderLayout());
                                    JTextArea explanation = new JTextArea(ExportDDLAction.GENDDL_WARNINGS_EXPLANATION, 5, 60);
                                    explanation.setLineWrap(true);
                                    explanation.setWrapStyleWord(true);
                                    explanation.setEditable(false);
                                    explanation.setBackground(outerPanel.getBackground());
                                    outerPanel.add((Component)explanation, "North");
                                    JPanel listBoxPanel = new JPanel();
                                    listBoxPanel.setLayout(new GridLayout(0, 1, 5, 5));
                                    Iterator i$ = warnings.iterator();
                                    while (i$.hasNext()) {
                                        DDLWarning o;
                                        DDLWarning ddlwarning = o = (DDLWarning)i$.next();
                                        DDLWarningComponent ddlWarningComponent = DDLWarningComponentFactory.createComponent(ddlwarning);
                                        listBoxPanel.add(ddlWarningComponent.getComponent());
                                        warningComponents.add(ddlWarningComponent);
                                    }
                                    outerPanel.add((Component)new JScrollPane(listBoxPanel), "Center");
                                    return outerPanel;
                                }
                            };
                            Object[] options = new String[]{"QuickFix All", "Ignore Warnings", "Cancel", "Recheck"};
                            int dialogChoice = JOptionPane.showOptionDialog(ArchitectFrame.getMainInstance(), dialogPanel.getPanel(), "Errors in generated DDL", -1, 0, null, options, options[options.length - 1]);
                            logger.debug((Object)dialogChoice);
                            switch (dialogChoice) {
                                case 0: {
                                    for (DDLWarning warning : warnings) {
                                        if (!warning.isQuickFixable()) continue;
                                        warning.quickFix();
                                    }
                                    continue block8;
                                }
                                case 1: {
                                    done = true;
                                    break;
                                }
                                case -1: 
                                case 2: {
                                    return;
                                }
                                case 3: {
                                    for (DDLWarningComponent warningComponent : warningComponents) {
                                        warningComponent.applyChanges();
                                    }
                                    break;
                                }
                            }
                        }
                        SQLDatabase ppdb = ArchitectFrame.getMainInstance().getProject().getPlayPen().getDatabase();
                        SQLScriptDialog ssd = new SQLScriptDialog(ExportDDLAction.this.d, "Preview SQL Script", "", false, (DDLGenerator)ddlg, ppdb.getDataSource(), true);
                        MonitorableWorker scriptWorker = ssd.getExecuteTask();
                        ConflictFinderProcess cfp = new ConflictFinderProcess(ssd, ppdb, ddlg, ddlg.getDdlStatements());
                        ConflictResolverProcess crp = new ConflictResolverProcess(ssd, cfp);
                        cfp.setNextProcess(crp);
                        crp.setNextProcess(scriptWorker);
                        ssd.setExecuteTask(cfp);
                        ssd.setVisible(true);
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(ExportDDLAction.this.architectFrame, "Can't export DDL: " + ex);
                    logger.error((Object)"Got exception while exporting DDL", (Throwable)ex);
                }
            }

            private void generateAnyway() {
                logger.debug((Object)"generateAnyway()");
            }
        };
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                ddlPanel.discardChanges();
                ExportDDLAction.this.d.setVisible(false);
            }
        };
        this.d = ArchitectPanelBuilder.createArchitectPanelDialog(ddlPanel, ArchitectFrame.getMainInstance(), "Forward Engineer SQL Script", "OK", okAction, cancelAction);
        this.d.pack();
        this.d.setLocationRelativeTo(ArchitectFrame.getMainInstance());
        this.d.setVisible(true);
    }

    public class ConflictResolverProcess
    extends MonitorableWorker {
        private JDialog parentDialog;
        private ConflictFinderProcess conflictFinder;
        private ConflictResolver cr;
        private String errorMessage;
        private Exception error;

        public ConflictResolverProcess(JDialog d, ConflictFinderProcess cfp) {
            this.parentDialog = d;
            this.conflictFinder = cfp;
        }

        public void doStuff() {
            if (this.isCanceled()) {
                return;
            }
            if (this.conflictFinder.doesUserWantToDropConflicts()) {
                this.cr = this.conflictFinder.getConflictResolver();
                this.cr.aboutToCallDropConflicting();
                try {
                    this.cr.dropConflicting();
                }
                catch (Exception ex) {
                    logger.error((Object)"Error while dropping conflicting objects", (Throwable)ex);
                    this.errorMessage = "Error while dropping conflicting objects:\n\n" + ex.getMessage();
                }
            }
        }

        public void cleanup() {
            if (this.errorMessage != null) {
                ASUtils.showExceptionDialog(this.parentDialog, "Error Dropping Conflicts: " + this.errorMessage, this.error, new ArchitectExceptionReportFactory());
                this.setCancelled(true);
            }
        }

        public Integer getJobSize() throws ArchitectException {
            return this.cr.getJobSize();
        }

        public String getMessage() {
            return this.cr.getMessage();
        }

        public int getProgress() throws ArchitectException {
            return this.cr.getProgress();
        }

        public boolean hasStarted() {
            return this.cr.hasStarted();
        }

        public boolean isFinished() throws ArchitectException {
            return this.cr.isFinished();
        }
    }

    public class ConflictFinderProcess
    extends MonitorableWorker {
        JDialog parentDialog;
        SQLDatabase target;
        DDLGenerator ddlg;
        List statements;
        ConflictResolver cr;
        String errorMessage;
        Throwable error;
        private boolean shouldDropConflicts;

        public ConflictFinderProcess(JDialog parentDialog, SQLDatabase target, DDLGenerator ddlg, List statements) throws ArchitectException, SQLException {
            this.parentDialog = parentDialog;
            this.target = target;
            this.ddlg = ddlg;
            this.statements = statements;
            this.cr = new ConflictResolver(target, ddlg, statements);
        }

        public boolean doesUserWantToDropConflicts() {
            return this.shouldDropConflicts;
        }

        public void doStuff() {
            if (this.isCanceled()) {
                return;
            }
            try {
                this.cr.findConflicting();
            }
            catch (Exception ex) {
                this.error = ex;
                this.errorMessage = "You have to specify a target database connection\nbefore executing this script.";
                logger.error((Object)"Unexpected exception setting up DDL generation", (Throwable)ex);
            }
        }

        public void cleanup() {
            if (!SwingUtilities.isEventDispatchThread()) {
                logger.error((Object)"runFinished is running on the wrong thread!");
            }
            if (this.errorMessage != null) {
                JOptionPane.showMessageDialog(this.parentDialog, this.errorMessage, "Error", 0);
            } else if (!this.cr.isEmpty()) {
                Object[] messages = new Object[3];
                messages[0] = "The following objects in the target database\nconflict with those you wish to create:";
                JTextArea conflictsPane = new JTextArea(this.cr.toConflictTree());
                conflictsPane.setRows(15);
                conflictsPane.setEditable(false);
                messages[1] = new JScrollPane(conflictsPane);
                messages[2] = "Do you want the Architect to drop these objects\nbefore attempting to create the new ones?";
                int choice = JOptionPane.showConfirmDialog(this.parentDialog, messages, "Conflicting Objects Found", 1);
                if (choice == 0) {
                    this.shouldDropConflicts = true;
                } else if (choice == 1) {
                    this.shouldDropConflicts = false;
                } else if (choice == 2) {
                    this.shouldDropConflicts = false;
                    this.setCancelled(true);
                }
            }
        }

        public ConflictResolver getConflictResolver() {
            return this.cr;
        }

        public Integer getJobSize() throws ArchitectException {
            return this.cr.getJobSize();
        }

        public String getMessage() {
            return this.cr.getMessage();
        }

        public int getProgress() throws ArchitectException {
            return this.cr.getProgress();
        }

        public boolean hasStarted() {
            return this.cr.hasStarted();
        }

        public boolean isFinished() throws ArchitectException {
            return this.cr.isFinished();
        }
    }
}

