/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.net;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class DNSUtils {
    private DirContext ctx;
    private Pattern p;

    public DNSUtils(String dnsHost) throws NamingException {
        System.out.println("DNSUtils: Creating DirContext");
        System.setProperty("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        System.setProperty("java.naming.provider.url", "dns://" + dnsHost);
        this.ctx = new InitialDirContext();
        System.out.println("Done Creating DirContext");
        this.p = Pattern.compile("(\\d+)\\s+([\\w.]+)");
    }

    public String findMX(String host) throws NamingException {
        System.out.println("DNSUtils: Getting attributes...");
        Attributes attrs = this.ctx.getAttributes(host, new String[]{"MX"});
        NamingEnumeration<? extends Attribute> enumeration = attrs.getAll();
        if (enumeration.hasMore()) {
            Attribute attr = enumeration.next();
            System.out.println("<< " + attr.getClass().getName());
            System.out.println(attr.getID());
            String mx = (String)attr.get();
            Matcher m = this.p.matcher(mx);
            if (m.matches()) {
                String rating = m.group(1);
                String mailServerHost = m.group(2);
                System.out.println(String.valueOf(mailServerHost) + " --> " + rating);
                return mailServerHost;
            }
            throw new IllegalStateException("RegEx Match Failed");
        }
        return host;
    }
}

