/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.sql;

import com.darwinsys.sql.ConnectionUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;

public class ValuePrompt {
    public static final String USAGE = "ValuePrompt connection-name \"select query...\"";

    public static void main(String[] args) {
        if (args.length == 1 && args[0].startsWith("-h")) {
            System.err.println(USAGE);
            System.exit(0);
        }
        if (args.length != 2) {
            System.err.println(USAGE);
            System.exit(1);
        }
        String connection = args[0];
        String query = args[1];
        try {
            Connection con = ConnectionUtil.getConnection(connection);
            BufferedReader is = new BufferedReader(new InputStreamReader(System.in));
            Statement stmt = con.createStatement(1005, 1008);
            ResultSet rs = stmt.executeQuery(query);
            System.out.println("Starting processing: query = " + query);
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int colCount = rsMetaData.getColumnCount();
            while (rs.next()) {
                boolean changed = false;
                int i = 1;
                while (i <= colCount) {
                    System.out.printf("%s=%s: ", rsMetaData.getColumnName(i), rs.getObject(i));
                    String resp = is.readLine();
                    if (resp != null && !"".equals(resp)) {
                        rs.updateString(i, resp);
                        changed = true;
                    }
                    ++i;
                }
                if (!changed) continue;
                rs.updateRow();
            }
            System.out.println("All done.");
            rs.close();
            stmt.close();
            con.close();
        }
        catch (Exception ex) {
            System.err.println("Exception: " + ex);
        }
    }
}

