/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.util;

import com.darwinsys.util.RecentItems;
import java.util.List;
import java.util.prefs.Preferences;
import junit.framework.TestCase;

public class RecentItemstest
extends TestCase {
    Preferences p = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
    RecentItems.Callback lister = new RecentItems.Callback(){

        @Override
        public void reload(List<String> items) {
            for (String string : items) {
                System.out.println("LIST contains " + string);
            }
        }
    };
    RecentItems r;

    public void testAdding() {
        System.out.println("RecentItemstest.test1()");
        this.r = new RecentItems(this.p, this.lister);
        this.r.putRecent("abc");
        this.r.putRecent("def");
        List<String> list = this.r.getList();
        RecentItemstest.assertEquals((int)2, (int)list.size());
        RecentItemstest.assertEquals((String)"def", (String)list.get(0));
        RecentItemstest.assertEquals((String)"abc", (String)list.get(1));
        this.r.putRecent("abc");
        try {
            list.remove(0);
            RecentItemstest.fail((String)"Did not return unmodifiableList");
        }
        catch (UnsupportedOperationException e) {
            System.out.println("Caught expected exception");
        }
        RecentItemstest.assertEquals((String)"abc", (String)list.get(0));
        list = this.r.getList();
        RecentItemstest.assertEquals((String)"abc", (String)list.get(0));
    }

    public void testRemoving() {
        System.out.println("RecentItemstest.test2()");
        this.r = new RecentItems(this.p, this.lister);
        this.r.putRecent("abc");
        this.r.putRecent("def");
        List<String> list = this.r.getList();
        RecentItemstest.assertEquals((int)2, (int)list.size());
        this.r.remove("abc");
        RecentItemstest.assertEquals((String)"def", (String)list.get(0));
    }

    public void testOverflow() {
        this.r = new RecentItems(this.p, this.lister, 3);
        List<String> list = this.r.getList();
        this.r.putRecent("abc");
        this.r.putRecent("def");
        this.r.putRecent("ghi");
        this.r.putRecent("jkl");
        RecentItemstest.assertEquals((int)3, (int)list.size());
        this.r.putRecent("mno");
        this.r.putRecent("pqr");
        RecentItemstest.assertEquals((String)"pqr", (String)list.get(0));
        RecentItemstest.assertEquals((String)"jkl", (String)list.get(2));
    }
}

