/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.ColumnNotDisplayableException;
import ca.sqlpower.sql.NoRowidException;
import ca.sqlpower.sql.WebResultFormatter;
import ca.sqlpower.sql.WebResultSet;
import java.io.PrintWriter;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.StringCharacterIterator;
import java.util.Date;

public class WebResultCSVFormatter
extends WebResultFormatter {
    public void formatToStream(WebResultSet wrs, PrintWriter out) throws SQLException, NoRowidException, IllegalStateException {
        this.formatHeader(wrs, out);
        this.formatBody(wrs, out);
    }

    public void formatHeader(WebResultSet wrs, PrintWriter out) throws SQLException {
        int numCols = wrs.getColumnCount();
        StringBuffer sb = new StringBuffer(256);
        boolean thisIsTheFirstColumn = true;
        for (int i = 1; i <= numCols; ++i) {
            if (this.columnNotAppropriate(wrs, i)) continue;
            sb.setLength(0);
            try {
                if (!thisIsTheFirstColumn) {
                    sb.append(",");
                }
                sb.append(WebResultCSVFormatter.makeStringSafe(this.beautifyHeading(wrs.getColumnLabel(i))));
                out.print(sb);
                thisIsTheFirstColumn = false;
                continue;
            }
            catch (ColumnNotDisplayableException e) {
                // empty catch block
            }
        }
        out.println("");
    }

    public void formatBody(WebResultSet wrs, PrintWriter out) throws SQLException, NoRowidException {
        int numCols = wrs.getColumnCount();
        StringBuffer sb = new StringBuffer(256);
        StringBuffer contents = new StringBuffer(256);
        StringBuffer align = new StringBuffer(32);
        while (wrs.next()) {
            boolean thisIsTheFirstColumn = true;
            for (int i = 1; i <= numCols; ++i) {
                if (this.columnNotAppropriate(wrs, i)) continue;
                contents.setLength(0);
                align.setLength(0);
                try {
                    this.getColumnFormatted(wrs, i, contents, align);
                    if (!thisIsTheFirstColumn) {
                        out.print(",");
                    }
                    out.print(WebResultCSVFormatter.makeStringSafe(contents.toString()));
                    thisIsTheFirstColumn = false;
                    continue;
                }
                catch (ColumnNotDisplayableException e) {
                    continue;
                }
                catch (UnsupportedOperationException e) {
                    out.print(WebResultCSVFormatter.makeStringSafe(wrs.getString(i)));
                }
            }
            out.println("");
        }
    }

    public static String makeStringSafe(String original) {
        if (original == null) {
            return "";
        }
        StringBuffer escaped = new StringBuffer(original.length());
        StringCharacterIterator it = new StringCharacterIterator(original);
        boolean escapedDiffersFromOriginal = false;
        escaped.append("\"");
        do {
            char ch = it.current();
            switch (ch) {
                case '\n': {
                    escaped.append("\\n");
                    escapedDiffersFromOriginal = true;
                    break;
                }
                case '\r': {
                    escaped.append("\\r");
                    escapedDiffersFromOriginal = true;
                    break;
                }
                case '\"': {
                    escaped.append("\\\"");
                    escapedDiffersFromOriginal = true;
                    break;
                }
                case '\\': {
                    escaped.append("\\\\");
                    escapedDiffersFromOriginal = true;
                    break;
                }
                case '\t': 
                case '\f': 
                case ' ': 
                case ',': {
                    escaped.append(ch);
                    escapedDiffersFromOriginal = true;
                    break;
                }
                default: {
                    escaped.append(ch);
                }
            }
        } while (it.next() != '\uffff');
        escaped.append("\"");
        return escapedDiffersFromOriginal ? escaped.toString() : original;
    }

    protected boolean columnNotAppropriate(WebResultSet wrs, int colNo) {
        int ctype = wrs.getColumnType(colNo);
        switch (ctype) {
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    protected void getColumnFormatted(WebResultSet wrs, int i, StringBuffer contents, StringBuffer align) throws SQLException, NoRowidException, ColumnNotDisplayableException, IllegalStateException {
        ResultSetMetaData md = wrs.getRsmd();
        switch (md.getColumnType(i)) {
            case 93: {
                java.sql.Date tsDate = wrs.getDate(i);
                if (tsDate == null) break;
                contents.append(this.dateFormatter.format(new Date(tsDate.getTime())));
                break;
            }
            default: {
                contents.append(wrs.getString(i));
            }
        }
    }
}

