/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.cgi;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.epic.core.PerlCore;
import org.epic.core.PerlProject;
import org.epic.core.util.PerlExecutableUtilities;
import org.epic.debug.LaunchConfigurationDelegate;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.cgi.CGIBrowser;
import org.epic.debug.cgi.CGIDebugTarget;
import org.epic.debug.cgi.CGIProxy;
import org.epic.debug.util.RemotePort;
import org.osgi.framework.Bundle;

public class CGILaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.epic.debug.cgi.CGILaunchConfigurationDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected void doLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        RemotePort debugPort = this.createDebugPort(launch);
        try {
            CGIProxy cgiProxy = new CGIProxy(launch, "CGI Process");
            int brazilPort = RemotePort.findFreePort();
            IProcess process = this.startBrazil(launch, cgiProxy, brazilPort, debugPort);
            cgiProxy.waitForConnect();
            if (!cgiProxy.isConnected()) {
                PerlDebugPlugin.getDefault().logError("(CGI-Target) Could not connect to CGI-Proxy");
                launch.terminate();
                return;
            }
            launch.addProcess((IProcess)cgiProxy);
            this.openBrowser(launch, brazilPort);
            if (debugPort != null) {
                this.createCGIDebugTarget(launch, process, debugPort);
            }
        }
        catch (CoreException e) {
            if (debugPort != null) {
                debugPort.shutdown();
            }
            launch.terminate();
            throw e;
        }
    }

    private BrazilProps createBrazilProps(ILaunch launch, CGIProxy cgiProxy, int brazilPort, int debugPort) throws CoreException {
        String htmlRootDir = this.getLaunchAttribute(launch, "ATTR_HTML_ROOT_DIR", true);
        String cgiRootDir = this.getLaunchAttribute(launch, "ATTR_CGI_ROOT_DIR", true);
        String cgiFileExtension = this.getLaunchAttribute(launch, "ATTR_CGI_FILE_EXTENSION", false);
        String perlParams = this.getLaunchAttribute(launch, "ATTR_PERL_PARAMETERS", false);
        if (perlParams == null) {
            perlParams = "";
        }
        perlParams = perlParams.replaceAll("[\\n\\r]", " ");
        PerlProject project = PerlCore.create((IProject)this.getProject(launch));
        String perlPath = PerlExecutableUtilities.getPerlInterpreterPath();
        if (perlPath == null) {
            perlPath = "";
        }
        BrazilProps props = new BrazilProps();
        props.add("cgi.InPort", cgiProxy.getInPort());
        props.add("cgi.OutPort", cgiProxy.getOutPort());
        props.add("cgi.ErrorPort", cgiProxy.getErrorPort());
        props.add("cgi.Debug", this.isDebugMode(launch));
        props.add("root", htmlRootDir);
        props.add("port", brazilPort);
        props.add("cgi.root", cgiRootDir);
        props.add("cgi.executable", perlPath);
        props.add("cgi.suffix", cgiFileExtension);
        props.add("cgi.PerlParams", perlParams);
        props.add("cgi.DebugInclude", "-I" + PerlDebugPlugin.getDefault().getInternalDebugInc());
        props.add("cgi.RunInclude", PerlExecutableUtilities.getPerlIncArgs((PerlProject)project));
        String[] env = PerlDebugPlugin.getDebugEnv(launch, debugPort);
        int i = 0;
        while (i < env.length) {
            int j = env[i].indexOf(61);
            if (j > 0) {
                props.add("cgi.ENV_" + env[i].substring(0, j), env[i].substring(j + 1));
            }
            ++i;
        }
        return props;
    }

    private void createCGIDebugTarget(ILaunch launch, IProcess process, RemotePort debugPort) throws CoreException {
        if (debugPort.waitForConnect(true) != 1) {
            PerlDebugPlugin.errorDialog("Could not connect to debug port!");
            debugPort.shutdown();
            launch.terminate();
            return;
        }
        CGIDebugTarget target = new CGIDebugTarget(launch, process, debugPort, this.getPathMapper(launch));
        launch.addDebugTarget((IDebugTarget)target);
    }

    private RemotePort createDebugPort(ILaunch launch) {
        if (!this.isDebugMode(launch)) {
            return null;
        }
        RemotePort debugPort = new RemotePort("DebugTarget.mDebugPort");
        debugPort.startConnect();
        return debugPort;
    }

    private List getBrazilJVMClasspath() throws CoreException {
        try {
            ArrayList<File> cp = new ArrayList<File>();
            URL brazilUrl = Platform.resolve((URL)Platform.getBundle((String)"org.epic.lib").getEntry("/lib/brazil_mini.jar"));
            if (!$assertionsDisabled && !"file".equalsIgnoreCase(brazilUrl.getProtocol())) {
                throw new AssertionError((Object)"brazil_mini.jar must reside in the file system");
            }
            cp.add(this.urlToFile(brazilUrl));
            Bundle bundle = PerlDebugPlugin.getDefault().getBundle();
            URL binUrl = bundle.getEntry("/bin");
            if (binUrl != null) {
                binUrl = Platform.resolve((URL)binUrl);
                if (!$assertionsDisabled && !binUrl.getProtocol().equalsIgnoreCase("file")) {
                    throw new AssertionError();
                }
                cp.add(this.urlToFile(binUrl));
            } else {
                URL dirUrl = Platform.resolve((URL)bundle.getEntry("/"));
                if (dirUrl.getProtocol().equalsIgnoreCase("jar")) {
                    String path = dirUrl.getPath();
                    if (!$assertionsDisabled && !path.startsWith("file:")) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !path.endsWith(".jar!/")) {
                        throw new AssertionError();
                    }
                    URL jarUrl = new URL(path.substring(0, path.length() - 2));
                    cp.add(this.urlToFile(jarUrl));
                } else {
                    if (!$assertionsDisabled && !dirUrl.getProtocol().equalsIgnoreCase("file")) {
                        throw new AssertionError();
                    }
                    cp.add(this.urlToFile(dirUrl));
                }
            }
            return cp;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "getBrazilJVMClasspath failed", (Throwable)e));
        }
    }

    private String getLaunchAttribute(ILaunch launch, String attrName, boolean isPath) throws CoreException {
        String attrValue = launch.getLaunchConfiguration().getAttribute(attrName, null);
        if (attrValue == null) {
            return null;
        }
        return new Path(attrValue).toString();
    }

    private String getRelativeURL(ILaunch launch) throws CoreException {
        String htmlRootFile = this.getLaunchAttribute(launch, "ATTR_HTML_ROOT_FILE", true);
        String htmlRootDir = this.getLaunchAttribute(launch, "ATTR_HTML_ROOT_DIR", true);
        return new Path(htmlRootFile).setDevice(null).removeFirstSegments(new Path(htmlRootDir).segments().length).toString();
    }

    private static String makePathString(List path) {
        StringBuffer buf = new StringBuffer();
        Iterator i = path.iterator();
        while (i.hasNext()) {
            File entry = (File)i.next();
            if (buf.length() > 0) {
                buf.append(File.pathSeparator);
            }
            buf.append(entry.getAbsolutePath());
        }
        return buf.toString();
    }

    private void openBrowser(ILaunch launch, int httpPort) throws CoreException {
        try {
            CGIBrowser browser = new CGIBrowser(launch, this.getRelativeURL(launch), httpPort);
            browser.open();
        }
        catch (CoreException e) {
            PerlDebugPlugin.getDefault().logError("Could not start web browser for CGI debugging.", (Exception)((Object)e));
            throw e;
        }
    }

    private IProcess startBrazil(ILaunch launch, CGIProxy cgiProxy, int brazilPort, RemotePort debugPort) throws CoreException {
        Process brazilProcess;
        try {
            this.createBrazilProps(launch, cgiProxy, brazilPort, debugPort != null ? debugPort.getServerPort() : -1).save();
        }
        catch (CoreException e) {
            PerlDebugPlugin.getDefault().logError("Could not read launch configuration attributes.", (Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "Could not create configuration file for web server.", (Throwable)e));
        }
        try {
            brazilProcess = this.startBrazilProcess();
        }
        catch (CoreException e) {
            PerlDebugPlugin.getDefault().logError("Could not start web server", (Exception)((Object)e));
            throw e;
        }
        return DebugPlugin.newProcess((ILaunch)launch, (Process)brazilProcess, (String)"Web Server");
    }

    private Process startBrazilProcess() throws CoreException {
        String javaExec = String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + "java";
        File workingDir = PerlDebugPlugin.getDefault().getStateLocation().toFile();
        String[] cmdParams = new String[]{javaExec, "-classpath", CGILaunchConfigurationDelegate.makePathString(this.getBrazilJVMClasspath()), "sunlabs.brazil.server.Main", "-c", "brazil.cfg"};
        try {
            return Runtime.getRuntime().exec(cmdParams, null, workingDir);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 0, "Could not start embedded web server: Runtime.exec failed", (Throwable)e));
        }
    }

    private File urlToFile(URL url) {
        String urlString = url.toExternalForm();
        if (urlString.matches("^file:/[A-Za-z]:/.*$")) {
            return new File(urlString.substring(6));
        }
        if (!$assertionsDisabled && !urlString.matches("^file:/[^/].*$")) {
            throw new AssertionError();
        }
        return new File(urlString.substring(5));
    }

    private static class BrazilProps {
        private final Properties props = new Properties();

        public void add(String name, boolean value) {
            this.add(name, String.valueOf(value));
        }

        public void add(String name, int value) {
            this.add(name, String.valueOf(value));
        }

        public void add(String name, List values) {
            int j = 0;
            Iterator i = values.iterator();
            while (i.hasNext()) {
                this.add(String.valueOf(name) + "[" + j + "]", i.next().toString());
                ++j;
            }
        }

        public void add(String name, String value) {
            this.props.put(name, value);
        }

        /*
         * Exception decompiling
         */
        public void save() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 58->62)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public String toString() {
            return this.props.toString();
        }
    }
}

