/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.repository.url;

import fr.jayasoft.ivy.repository.AbstractRepository;
import fr.jayasoft.ivy.repository.RepositoryCopyProgressListener;
import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.repository.url.URLResource;
import fr.jayasoft.ivy.url.ApacheURLLister;
import fr.jayasoft.ivy.util.CopyProgressListener;
import fr.jayasoft.ivy.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class URLRepository
extends AbstractRepository {
    private RepositoryCopyProgressListener _progress = new RepositoryCopyProgressListener(this);
    private Map _resourcesCache = new HashMap();
    private ApacheURLLister _lister = new ApacheURLLister();

    public Resource getResource(String source) throws IOException {
        Resource res = (Resource)this._resourcesCache.get(source);
        if (res == null) {
            res = new URLResource(new URL(source));
            this._resourcesCache.put(source, res);
        }
        return res;
    }

    public void get(String source, File destination) throws IOException {
        this.fireTransferInitiated(this.getResource(source), 5);
        try {
            Resource res = this.getResource(source);
            long totalLength = res.getContentLength();
            if (totalLength > 0L) {
                this._progress.setTotalLength(new Long(totalLength));
            }
            FileUtil.copy(new URL(source), destination, (CopyProgressListener)this._progress);
        }
        catch (IOException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        finally {
            this._progress.setTotalLength(null);
        }
    }

    public void put(File source, String destination, boolean overwrite) throws IOException {
        throw new UnsupportedOperationException("URL repository is not able to put files for the moment");
    }

    public List list(String parent) throws IOException {
        if (parent.startsWith("http")) {
            List urls = this._lister.listAll(new URL(parent));
            if (urls != null) {
                ArrayList<String> ret = new ArrayList<String>(urls.size());
                ListIterator iter = urls.listIterator();
                while (iter.hasNext()) {
                    URL url = (URL)iter.next();
                    ret.add(url.toExternalForm());
                }
                return ret;
            }
        } else if (parent.startsWith("file")) {
            String path = new URL(parent).getPath();
            File file = new File(path);
            if (file.exists() && file.isDirectory()) {
                String[] files = file.list();
                ArrayList<String> ret = new ArrayList<String>(files.length);
                URL context = path.endsWith("/") ? new URL(parent) : new URL(parent + "/");
                for (int i = 0; i < files.length; ++i) {
                    ret.add(new URL(context, files[i]).toExternalForm());
                }
                return ret;
            }
            return Collections.EMPTY_LIST;
        }
        return null;
    }
}

