/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.browsing.RubyBrowsingMessages;
import org.rubypeople.rdt.internal.ui.viewsupport.SourcePositionSorter;
import org.rubypeople.rdt.ui.RubyElementSorter;

public class LexicalSortingAction
extends Action {
    private RubyElementSorter fSorter = new RubyElementSorter();
    private SourcePositionSorter fSourcePositonSorter = new SourcePositionSorter();
    private StructuredViewer fViewer;
    private String fPreferenceKey;

    public LexicalSortingAction(StructuredViewer structuredViewer, String string) {
        this.fViewer = structuredViewer;
        this.fPreferenceKey = "LexicalSortingAction." + string + ".isChecked";
        this.setText(RubyBrowsingMessages.LexicalSortingAction_label);
        RubyPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.gif");
        this.setToolTipText(RubyBrowsingMessages.LexicalSortingAction_tooltip);
        this.setDescription(RubyBrowsingMessages.LexicalSortingAction_description);
        boolean bl = RubyPlugin.getDefault().getPreferenceStore().getBoolean(this.fPreferenceKey);
        this.valueChanged(bl, false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.lexical_sorting_browsing_action");
    }

    public void run() {
        this.valueChanged(this.isChecked(), true);
    }

    private void valueChanged(final boolean bl, boolean bl2) {
        this.setChecked(bl);
        BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (bl) {
                    LexicalSortingAction.this.fViewer.setSorter((ViewerSorter)LexicalSortingAction.this.fSorter);
                } else {
                    LexicalSortingAction.this.fViewer.setSorter((ViewerSorter)LexicalSortingAction.this.fSourcePositonSorter);
                }
            }
        });
        if (bl2) {
            RubyPlugin.getDefault().getPreferenceStore().setValue(this.fPreferenceKey, bl);
        }
    }
}

