/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences.formatter;

import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.preferences.formatter.FormatterMessages;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ProfileManager;

public class RenameProfileDialog
extends StatusDialog {
    private Label fNameLabel;
    private Text fNameText;
    private final StatusInfo fOk;
    private final StatusInfo fEmpty;
    private final StatusInfo fDuplicate;
    private final StatusInfo fNoMessage;
    private final ProfileManager.Profile fProfile;
    private final ProfileManager fManager;
    private ProfileManager.Profile fRenamedProfile;

    public RenameProfileDialog(Shell shell, ProfileManager.Profile profile, ProfileManager profileManager) {
        super(shell);
        this.fManager = profileManager;
        this.setTitle(FormatterMessages.RenameProfileDialog_dialog_title);
        this.fProfile = profile;
        this.fOk = new StatusInfo();
        this.fDuplicate = new StatusInfo(4, FormatterMessages.RenameProfileDialog_status_message_profile_with_this_name_already_exists);
        this.fEmpty = new StatusInfo(4, FormatterMessages.RenameProfileDialog_status_message_profile_name_empty);
        this.fNoMessage = new StatusInfo(4, new String());
    }

    public Control createDialogArea(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        gridLayout.numColumns = 2;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        this.fNameLabel = new Label(composite2, 0);
        this.fNameLabel.setText(FormatterMessages.RenameProfileDialog_dialog_label_enter_a_new_name);
        this.fNameLabel.setLayoutData((Object)gridData);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fNameText = new Text(composite2, 2052);
        if (this.fProfile instanceof ProfileManager.SharedProfile) {
            this.fNameText.setText(this.fProfile.getName());
        }
        this.fNameText.setSelection(0, this.fProfile.getName().length());
        this.fNameText.setLayoutData((Object)gridData);
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RenameProfileDialog.this.doValidation();
            }
        });
        this.fNameText.setText(this.fProfile.getName());
        this.fNameText.selectAll();
        RenameProfileDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void doValidation() {
        String string = this.fNameText.getText().trim();
        if (string.length() == 0) {
            this.updateStatus(this.fEmpty);
            return;
        }
        if (string.equals(this.fProfile.getName())) {
            this.updateStatus(this.fNoMessage);
            return;
        }
        if (this.fManager.containsName(string)) {
            this.updateStatus(this.fDuplicate);
            return;
        }
        this.updateStatus(this.fOk);
    }

    public ProfileManager.Profile getRenamedProfile() {
        return this.fRenamedProfile;
    }

    protected void okPressed() {
        if (!this.getStatus().isOK()) {
            return;
        }
        this.fRenamedProfile = this.fProfile.rename(this.fNameText.getText(), this.fManager);
        super.okPressed();
    }
}

