/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.Assert;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.ScopePart;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.internal.core.symbols.ISymbolTypes;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.search.RubySearchQuery;

public class RubySearchPage
extends DialogPage
implements ISearchPage,
ISymbolTypes {
    private final List fPreviousSearchPatterns;
    private boolean fFirstTime = true;
    private Combo fPattern;
    private ISearchPageContainer fContainer;
    private Button fCaseSensitive;
    private SearchForManager searchForManager = new SearchForManager();

    public RubySearchPage() {
        this.fPreviousSearchPatterns = new ArrayList();
    }

    public boolean performAction() {
        NewSearchUI.runQueryInBackground((ISearchQuery)this.getSearchQuery());
        return true;
    }

    private ISearchQuery getSearchQuery() {
        SearchPatternData searchPatternData = this.getPatternData();
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                break;
            }
            case 2: {
                IWorkingSet[] iWorkingSetArray = this.getContainer().getSelectedWorkingSets();
                Messages.format((String)SearchMessages.WorkingSetScope, (Object)ScopePart.toString((IWorkingSet[])iWorkingSetArray));
            }
        }
        NewSearchUI.activateSearchResultView();
        return new RubySearchQuery(searchPatternData.getPattern(), searchPatternData.getSearchFor());
    }

    private int getLimitTo() {
        return -1;
    }

    private String[] getPreviousSearchPatterns() {
        int n = this.fPreviousSearchPatterns.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ((SearchPatternData)this.fPreviousSearchPatterns.get(n2)).getPattern();
            ++n2;
        }
        return stringArray;
    }

    private String getPattern() {
        return this.fPattern.getText();
    }

    private SearchPatternData findInPrevious(String string) {
        Iterator iterator = this.fPreviousSearchPatterns.iterator();
        while (iterator.hasNext()) {
            SearchPatternData searchPatternData = (SearchPatternData)iterator.next();
            if (!string.equals(searchPatternData.getPattern())) continue;
            return searchPatternData;
        }
        return null;
    }

    private SearchPatternData getPatternData() {
        String string = this.getPattern();
        SearchPatternData searchPatternData = this.findInPrevious(string);
        if (searchPatternData != null) {
            this.fPreviousSearchPatterns.remove(searchPatternData);
        }
        searchPatternData = new SearchPatternData(this.searchForManager.getSelectedSymbolType(), this.getLimitTo(), string, this.fCaseSensitive.getSelection(), this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets());
        this.fPreviousSearchPatterns.add(0, searchPatternData);
        return searchPatternData;
    }

    public void setVisible(boolean bl) {
        if (bl && this.fPattern != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.fPattern.setItems(this.getPreviousSearchPatterns());
            }
            this.fPattern.setFocus();
        }
        super.setVisible(bl);
    }

    public boolean isValid() {
        return true;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        Control control = this.createExpression(composite2);
        control.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label label = new Label(composite2, 0);
        label.setVisible(false);
        GridData gridData = new GridData(4, 4, false, false, 2, 1);
        gridData.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        label.setLayoutData((Object)gridData);
        Control control2 = this.searchForManager.createSearchFor(composite2);
        control2.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Control control3 = this.createLimitTo(composite2);
        control3.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    private Control createExpression(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 16384);
        label.setText("Expression");
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.fPattern = new Combo(composite2, 2052);
        this.fPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        this.fPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                RubySearchPage.this.doPatternModified();
            }
        });
        GridData gridData = new GridData(4, 4, true, false, 1, 1);
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        this.fPattern.setLayoutData((Object)gridData);
        this.fCaseSensitive = new Button(composite2, 32);
        this.fCaseSensitive.setText("CaseSensitive");
        this.fCaseSensitive.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
            }
        });
        this.fCaseSensitive.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        return composite2;
    }

    public void dispose() {
        super.dispose();
    }

    private void doPatternModified() {
    }

    private Control createLimitTo(Composite composite) {
        Group group = new Group(composite, 0);
        return group;
    }

    public void setContainer(ISearchPageContainer iSearchPageContainer) {
        this.fContainer = iSearchPageContainer;
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private static class SearchPatternData {
        private int searchFor;
        private int limitTo;
        private String pattern;
        private boolean isCaseSensitive;
        private int scope;
        private IWorkingSet[] workingSets;

        public SearchPatternData(int n, int n2, boolean bl, String string) {
            this(n, n2, string, bl, 0, null);
        }

        public SearchPatternData(int n, int n2, String string, boolean bl, int n3, IWorkingSet[] iWorkingSetArray) {
            this.searchFor = n;
            this.limitTo = n2;
            this.pattern = string;
            this.isCaseSensitive = bl;
            this.scope = n3;
            this.workingSets = iWorkingSetArray;
        }

        public boolean isCaseSensitive() {
            return this.isCaseSensitive;
        }

        public int getLimitTo() {
            return this.limitTo;
        }

        public String getPattern() {
            return this.pattern;
        }

        public int getScope() {
            return this.scope;
        }

        public int getSearchFor() {
            return this.searchFor;
        }

        public IWorkingSet[] getWorkingSets() {
            return this.workingSets;
        }

        public void store(IDialogSettings iDialogSettings) {
            iDialogSettings.put("searchFor", this.searchFor);
            iDialogSettings.put("scope", this.scope);
            iDialogSettings.put("pattern", this.pattern);
            iDialogSettings.put("limitTo", this.limitTo);
            iDialogSettings.put("isCaseSensitive", this.isCaseSensitive);
            if (this.workingSets != null) {
                String[] stringArray = new String[this.workingSets.length];
                int n = 0;
                while (n < this.workingSets.length) {
                    stringArray[n] = this.workingSets[n].getId();
                    ++n;
                }
                iDialogSettings.put("workingSets", stringArray);
            } else {
                iDialogSettings.put("workingSets", new String[0]);
            }
        }

        public static SearchPatternData create(IDialogSettings iDialogSettings) {
            int n;
            String string = iDialogSettings.get("pattern");
            if (string.length() == 0) {
                return null;
            }
            String[] stringArray = iDialogSettings.getArray("workingSets");
            IWorkingSet[] iWorkingSetArray = null;
            if (stringArray != null && stringArray.length > 0) {
                IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                iWorkingSetArray = new IWorkingSet[stringArray.length];
                n = 0;
                while (iWorkingSetArray != null && n < stringArray.length) {
                    iWorkingSetArray[n] = iWorkingSetManager.getWorkingSet(stringArray[n]);
                    if (iWorkingSetArray[n] == null) {
                        iWorkingSetArray = null;
                    }
                    ++n;
                }
            }
            try {
                int n2 = iDialogSettings.getInt("searchFor");
                n = iDialogSettings.getInt("scope");
                int n3 = iDialogSettings.getInt("limitTo");
                boolean bl = iDialogSettings.getBoolean("isCaseSensitive");
                return new SearchPatternData(n2, n3, string, bl, n, iWorkingSetArray);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    class SearchForManager {
        private Button[] fSearchFor;

        SearchForManager() {
        }

        private Button createButton(Group group, String string, int n) {
            Button button = new Button((Composite)group, 16);
            button.setText(string);
            button.setData((Object)new Integer(n));
            button.setLayoutData((Object)new GridData());
            return button;
        }

        private Control createSearchFor(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(RubyUIMessages.getString("RubySearchPage.SearchForGroupLabel"));
            group.setLayout((Layout)new GridLayout(2, true));
            this.fSearchFor = new Button[2];
            this.fSearchFor[0] = this.createButton(group, RubyUIMessages.getString("RubySearch.SearchForClassSymbol"), 0);
            this.fSearchFor[0].setSelection(true);
            this.fSearchFor[1] = this.createButton(group, RubyUIMessages.getString("RubySearch.SearchForMethodSymbol"), 1);
            return group;
        }

        public int getSelectedSymbolType() {
            int n = 0;
            while (n < this.fSearchFor.length) {
                if (this.fSearchFor[n].getSelection()) {
                    return (Integer)this.fSearchFor[n].getData();
                }
                ++n;
            }
            Assert.isTrue((boolean)false, (String)"Error in RubySearchPage: There should always be a selected symbol type to search for");
            return 0;
        }
    }
}

