/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.launching;

import java.util.ArrayList;
import java.util.List;

public class ArgumentSplitter {
    private List args;
    private StringBuffer currentArg;
    private boolean inQuotedArg;
    private char expectedCloseQuote;

    public static List split(String string) {
        return new ArgumentSplitter().internalSplit(string);
    }

    private ArgumentSplitter() {
    }

    private List internalSplit(String string) {
        this.currentArg = new StringBuffer();
        this.args = new ArrayList();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (this.isEnddingQuote(c)) {
                this.recordArg(true);
            } else if (this.isStartingQuote(c)) {
                this.startQuotedArgument(c);
            } else if (this.isArgumentSeparator(c)) {
                this.recordArg(false);
            } else {
                this.currentArg.append(c);
            }
            ++n;
        }
        this.recordArg(false);
        return this.args;
    }

    private void startQuotedArgument(char c) {
        this.inQuotedArg = true;
        this.expectedCloseQuote = c;
    }

    private boolean isArgumentSeparator(char c) {
        return c == ' ' && !this.inQuotedArg;
    }

    private boolean isStartingQuote(char c) {
        return this.isQuote(c) && !this.inQuotedArg;
    }

    private boolean isEnddingQuote(char c) {
        return this.isQuote(c) && this.inQuotedArg && c == this.expectedCloseQuote;
    }

    private boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    private void recordArg(boolean bl) {
        String string = this.currentArg.toString();
        if (bl || string.length() > 0) {
            this.args.add(string);
        }
        this.currentArg = new StringBuffer();
        this.inQuotedArg = false;
    }
}

