/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.dialogs;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalCompareInput;
import org.tigris.subversion.subclipse.ui.dialogs.AdaptableResourceList;
import org.tigris.subversion.subclipse.ui.dialogs.CompareDialog;
import org.tigris.subversion.subclipse.ui.dialogs.ResourceWithStatusLabelProvider;
import org.tigris.subversion.subclipse.ui.dialogs.ResourceWithStatusSorter;
import org.tigris.subversion.subclipse.ui.util.TableSetter;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class RevertDialog
extends TrayDialog {
    private static final int WIDTH_HINT = 500;
    private static final int SELECTION_HEIGHT_HINT = 250;
    private IResource[] resourcesToRevert;
    private String url;
    private Object[] selectedResources;
    private CheckboxTableViewer listViewer;
    private IDialogSettings settings;
    private TableSetter setter;
    private int sorterColumn = 1;
    private boolean sorterReversed = false;
    protected static final int LABEL_WIDTH_HINT = 400;

    public RevertDialog(Shell parentShell, IResource[] resourcesToRevert, String url) {
        super(parentShell);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10);
        this.resourcesToRevert = resourcesToRevert;
        this.url = url;
        this.settings = SVNUIPlugin.getPlugin().getDialogSettings();
        this.setter = new TableSetter();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Policy.bind("RevertDialog.title"));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label label = this.createWrappingLabel(composite);
        if (this.url == null) {
            label.setText(String.valueOf(Policy.bind("RevertDialog.url")) + " " + Policy.bind("RevertDialog.multiple"));
        } else {
            label.setText(String.valueOf(Policy.bind("RevertDialog.url")) + " " + this.url);
        }
        this.addResourcesArea(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.tigris.subversion.subclipse.ui.revert_dialog_context");
        return composite;
    }

    private void addResourcesArea(Composite composite) {
        Label label = this.createWrappingLabel(composite);
        label.setText(Policy.bind("RevertDialog.resources"));
        Table table = new Table(composite, 68386);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        this.listViewer = new CheckboxTableViewer(table);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 500;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.createColumns(table, layout);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new ResourceWithStatusLabelProvider(this.url));
        int sort = this.setter.getSorterColumn("RevertDialog");
        if (sort != -1) {
            this.sorterColumn = sort;
        }
        ResourceWithStatusSorter sorter = new ResourceWithStatusSorter(this.sorterColumn);
        sorter.setReversed(this.setter.getSorterReversed("RevertDialog"));
        this.listViewer.setSorter((ViewerSorter)sorter);
        this.listViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return RevertDialog.this.resourcesToRevert;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.listViewer.setInput((Object)new AdaptableResourceList(this.resourcesToRevert));
        if (this.selectedResources == null) {
            this.setChecks();
        } else {
            this.listViewer.setCheckedElements(this.selectedResources);
        }
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RevertDialog.this.selectedResources = RevertDialog.this.listViewer.getCheckedElements();
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object sel0 = sel.getFirstElement();
                if (sel0 instanceof IFile) {
                    ISVNLocalResource localResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)((IFile)sel0));
                    try {
                        new CompareDialog(RevertDialog.this.getShell(), new SVNLocalCompareInput(localResource, SVNRevision.BASE, true)).open();
                    }
                    catch (SVNException sVNException) {}
                }
            }
        });
        this.addSelectionButtons(composite);
    }

    private void saveLocation() {
        int x = this.getShell().getLocation().x;
        int y = this.getShell().getLocation().y;
        this.settings.put("RevertDialog.location.x", x);
        this.settings.put("RevertDialog.location.y", y);
        x = this.getShell().getSize().x;
        y = this.getShell().getSize().y;
        this.settings.put("RevertDialog.size.x", x);
        this.settings.put("RevertDialog.size.y", y);
        TableSetter setter = new TableSetter();
        setter.saveColumnWidths(this.listViewer.getTable(), "RevertDialog");
        setter.saveSorterColumn("RevertDialog", this.sorterColumn);
        setter.saveSorterReversed("RevertDialog", this.sorterReversed);
    }

    private void createColumns(Table table, TableLayout layout) {
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = RevertDialog.this.listViewer.getTable().indexOf((TableColumn)e.widget);
                ResourceWithStatusSorter oldSorter = (ResourceWithStatusSorter)RevertDialog.this.listViewer.getSorter();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    RevertDialog.this.sorterReversed = oldSorter.isReversed();
                    RevertDialog.this.listViewer.refresh();
                } else {
                    RevertDialog.this.listViewer.setSorter((ViewerSorter)new ResourceWithStatusSorter(column));
                    RevertDialog.this.sorterColumn = column;
                }
            }
        };
        int[] widths = this.setter.getColumnWidths("RevertDialog", 4);
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(false);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(20, false));
        col.addSelectionListener((SelectionListener)headerListener);
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("PendingOperationsView.resource"));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(widths[1], true));
        col.addSelectionListener((SelectionListener)headerListener);
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("CommitDialog.status"));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(widths[2], true));
        col.addSelectionListener((SelectionListener)headerListener);
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(Policy.bind("CommitDialog.property"));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(widths[3], true));
        col.addSelectionListener((SelectionListener)headerListener);
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(640);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        Button selectButton = this.createButton(buttonComposite, 18, Policy.bind("ReleaseCommentDialog.selectAll"), false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RevertDialog.this.listViewer.setAllChecked(true);
                RevertDialog.this.selectedResources = null;
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, Policy.bind("ReleaseCommentDialog.deselectAll"), false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RevertDialog.this.listViewer.setAllChecked(false);
                RevertDialog.this.selectedResources = new Object[0];
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    protected void cancelPressed() {
        this.saveLocation();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.saveLocation();
        super.okPressed();
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            int x = this.settings.getInt("RevertDialog.location.x");
            int y = this.settings.getInt("RevertDialog.location.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    protected Point getInitialSize() {
        try {
            int x = this.settings.getInt("RevertDialog.size.x");
            int y = this.settings.getInt("RevertDialog.size.y");
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialSize();
        }
    }

    public IResource[] getSelectedResources() {
        if (this.selectedResources == null) {
            return this.resourcesToRevert;
        }
        List<Object> result = Arrays.asList(this.selectedResources);
        return result.toArray(new IResource[result.size()]);
    }

    protected Label createWrappingLabel(Composite parent) {
        Label label = new Label(parent, 16448);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        data.horizontalAlignment = 4;
        data.horizontalIndent = 0;
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 400;
        label.setLayoutData((Object)data);
        return label;
    }

    private void setChecks() {
        this.listViewer.setAllChecked(true);
        this.selectedResources = this.listViewer.getCheckedElements();
    }
}

