/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.creation.ui.command;

import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.xml.WSDLWriter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.creation.ui.AxisCreationUIMessages;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.common.ServerUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.wsdl.internal.impl.wsdl4j.WSDLFactoryImpl;

public class ModifyWSDLEndpointAddressCommand
extends AbstractDataModelOperation {
    private String serverInstanceId;
    private String serverFactoryId;
    private IProject serviceProject;
    private String wsdlURI;
    private WebServicesParser webServicesParser;
    public final String SERVICE_EXT = "/services/";
    private JavaWSDLParameter javaWSDLParam;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        block13: {
            IEnvironment environment = this.getEnvironment();
            try {
                if (!this.javaWSDLParam.isGuessProjectURL()) {
                    return Status.OK_STATUS;
                }
                String projectURL = null;
                IServer server = null;
                if (this.serverInstanceId != null) {
                    server = ServerCore.findServer((String)this.serverInstanceId);
                }
                if ((projectURL = server != null ? ServerUtils.getEncodedWebComponentURL((IProject)this.serviceProject, (String)this.serverFactoryId, (IServer)server) : ServerUtils.getEncodedWebComponentURL((IProject)this.serviceProject, (String)this.serverFactoryId)) == null || projectURL.trim().length() == 0) {
                    IStatus status = StatusUtils.errorStatus((String)NLS.bind((String)AxisCreationUIMessages.MSG_ERROR_PROJECT_URL, (Object[])new String[]{this.serviceProject.getName()}));
                    environment.getStatusHandler().reportError(status);
                    return status;
                }
                if (this.javaWSDLParam.getProjectURL() == projectURL) {
                    return Status.OK_STATUS;
                }
                this.javaWSDLParam.setProjectURL(projectURL);
                if (this.wsdlURI != null) {
                    boolean modified = false;
                    if (this.webServicesParser == null) {
                        this.webServicesParser = new WebServicesParserExt();
                    }
                    Definition definition = this.webServicesParser.getWSDLDefinition(this.wsdlURI);
                    Map services = definition.getServices();
                    Iterator it = services.values().iterator();
                    while (it.hasNext()) {
                        Service ser = (Service)it.next();
                        Map ports = ser.getPorts();
                        Iterator it2 = ports.values().iterator();
                        while (it2.hasNext()) {
                            Port p = (Port)it2.next();
                            Iterator it3 = p.getExtensibilityElements().iterator();
                            while (it3.hasNext()) {
                                SOAPAddress soapAddress;
                                String wsdlSoapAddress;
                                Object obj = it3.next();
                                if (!(obj instanceof SOAPAddress) || (wsdlSoapAddress = (soapAddress = (SOAPAddress)obj).getLocationURI()) == null || wsdlSoapAddress.startsWith(projectURL)) continue;
                                String servicesString = wsdlSoapAddress.substring(wsdlSoapAddress.indexOf("/services/"));
                                soapAddress.setLocationURI(String.valueOf(projectURL) + servicesString);
                                modified = true;
                            }
                        }
                    }
                    if (modified) {
                        WSDLFactoryImpl wsdlFactory = new WSDLFactoryImpl();
                        WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
                        OutputStream os = environment.getURIFactory().newURI(this.wsdlURI.toString()).getOutputStream();
                        wsdlWriter.writeWSDL(definition, os);
                        os.close();
                        URL wsdlURL = new URL(this.wsdlURI);
                        IResource wsdlFile = ResourceUtils.findResourceAtLocation((String)wsdlURL.getPath(), (IProject)this.serviceProject);
                        if (wsdlFile != null) {
                            wsdlFile.refreshLocal(0, monitor);
                        }
                    }
                    break block13;
                }
                IStatus status = StatusUtils.errorStatus((String)NLS.bind((String)AxisCreationUIMessages.MSG_ERROR_MODIFY_ENDPOINT, (Object[])new String[]{this.wsdlURI}));
                environment.getStatusHandler().reportError(status);
                return status;
            }
            catch (Exception exception) {
                IStatus status = StatusUtils.errorStatus((String)NLS.bind((String)AxisCreationUIMessages.MSG_ERROR_MODIFY_ENDPOINT, (Object[])new String[]{this.wsdlURI}));
                environment.getStatusHandler().reportError(status);
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    public void setServerInstanceId(String serverId) {
        this.serverInstanceId = serverId;
    }

    public void setServerFactoryId(String serverFactoryId) {
        this.serverFactoryId = serverFactoryId;
    }

    public void setServiceProject(IProject serviceProject) {
        this.serviceProject = serviceProject;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setWebServicesParser(WebServicesParser parser) {
        this.webServicesParser = parser;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam;
    }
}

