/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.sqleditor.internal.sql;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class SQLCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension {
    private String fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fDocumentOffset = -1;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private int fContextInformationPosition;
    private char[] fTriggerCharacters;
    private String fAdditionalProposalInfo;

    public SQLCompletionProposal(String additionalInfo, String replacementString, int replacementOffset, int documentOffset, int replacementLength, Image image, String displayString, IContextInformation contextInformation) {
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fDocumentOffset = documentOffset;
        this.fReplacementLength = replacementLength;
        this.fImage = image;
        this.fDisplayString = displayString != null ? displayString : replacementString;
        this.fCursorPosition = replacementString.length();
        this.fContextInformation = contextInformation;
        this.fTriggerCharacters = null;
        this.fAdditionalProposalInfo = additionalInfo;
    }

    public SQLCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        this.fReplacementString = replacementString;
        this.fDocumentOffset = this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fCursorPosition = cursorPosition;
        this.fImage = image;
        this.fDisplayString = displayString;
        this.fContextInformation = contextInformation;
        this.fAdditionalProposalInfo = additionalProposalInfo;
    }

    public void setContextInformation(IContextInformation contextInformation) {
        this.fContextInformation = contextInformation;
        this.fContextInformationPosition = this.fContextInformation != null ? this.fCursorPosition : -1;
    }

    public void setTriggerCharacters(char[] triggerCharacters) {
        this.fTriggerCharacters = triggerCharacters;
    }

    public void setCursorPosition(int cursorPosition) {
        if (cursorPosition >= 0) {
            this.fCursorPosition = cursorPosition;
            this.fContextInformationPosition = this.fContextInformation != null ? this.fCursorPosition : -1;
        }
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            int delta = offset - (this.fDocumentOffset + this.fReplacementLength);
            if (delta > 0) {
                this.fReplacementLength += delta;
            }
            if (trigger == '\u0000') {
                this.replace(document, this.fDocumentOffset, this.fReplacementLength, this.fReplacementString);
            } else {
                StringBuffer buffer = new StringBuffer(this.fReplacementString);
                if (this.fReplacementLength < buffer.length() && buffer.charAt(this.fReplacementLength) != trigger) {
                    buffer.insert(this.fCursorPosition, trigger);
                    ++this.fCursorPosition;
                }
                this.replace(document, this.fDocumentOffset, this.fReplacementLength, buffer.toString());
            }
            int oldLen = document.getLength();
            this.fDocumentOffset += document.getLength() - oldLen;
        }
        catch (BadLocationException x) {
            x.printStackTrace();
        }
    }

    private void replace(IDocument document, int offset, int length, String string) throws BadLocationException {
        if (document != null && string != null && offset >= 0 && length >= 0 && !document.get(offset, length).equals(string)) {
            document.replace(offset, length, string);
        }
    }

    public void apply(IDocument document) {
        this.apply(document, '\u0000', this.fDocumentOffset + this.fReplacementLength);
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fDocumentOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public String getAdditionalProposalInfo() {
        return this.fAdditionalProposalInfo;
    }

    public char[] getTriggerCharacters() {
        return this.fTriggerCharacters;
    }

    public int getContextInformationPosition() {
        return this.fReplacementOffset + this.fContextInformationPosition;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public void setReplacementOffset(int replacementOffset) {
        if (replacementOffset >= 0) {
            this.fReplacementOffset = replacementOffset;
        }
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public void setReplacementLength(int replacementLength) {
        if (replacementLength >= 0) {
            this.fReplacementLength = replacementLength;
        }
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public void setReplacementString(String replacementString) {
        this.fReplacementString = replacementString;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public boolean isValidFor(IDocument document, int offset) {
        int replacementLength;
        if (offset < this.fReplacementOffset) {
            return false;
        }
        int n = replacementLength = this.fReplacementString == null ? 0 : this.fReplacementString.length();
        if (offset >= this.fReplacementOffset + replacementLength) {
            return false;
        }
        try {
            int length = offset - this.fReplacementOffset;
            String start = document.get(this.fReplacementOffset, length);
            return this.fReplacementString.substring(0, length).equalsIgnoreCase(start);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

