/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.internal.IInstallableServer;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeComposite;
import org.eclipse.wst.server.ui.internal.viewers.InstallableServerContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.InstallableServerLabelProvider;

public class InstallableServerComposite
extends AbstractTreeComposite {
    protected IInstallableServer selection;
    protected InstallableServerSelectionListener listener;
    protected InstallableServerContentProvider contentProvider;
    protected boolean initialSelection = true;

    public InstallableServerComposite(Composite parent, int style, InstallableServerSelectionListener listener2) {
        super(parent, style);
        this.listener = listener2;
        this.contentProvider = new InstallableServerContentProvider(1);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        InstallableServerLabelProvider labelProvider = new InstallableServerLabelProvider();
        labelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Object[] obj = event.getElements();
                if (obj == null) {
                    InstallableServerComposite.this.treeViewer.refresh(true);
                } else {
                    int size = obj.length;
                    int i = 0;
                    while (i < size) {
                        InstallableServerComposite.this.treeViewer.refresh(obj[i], true);
                        ++i;
                    }
                }
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.treeViewer.setInput((Object)"root");
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = InstallableServerComposite.this.getSelection(event.getSelection());
                if (obj instanceof IInstallableServer) {
                    InstallableServerComposite.this.selection = (IInstallableServer)obj;
                    InstallableServerComposite.this.setDescription(InstallableServerComposite.this.selection.getDescription());
                } else {
                    InstallableServerComposite.this.selection = null;
                    InstallableServerComposite.this.setDescription("");
                }
                InstallableServerComposite.this.listener.installableServerSelected(InstallableServerComposite.this.selection);
            }
        });
        this.treeViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IInstallableServer && !(e2 instanceof IInstallableServer)) {
                    return 1;
                }
                if (!(e1 instanceof IInstallableServer) && e2 instanceof IInstallableServer) {
                    return -1;
                }
                if (!(e1 instanceof IInstallableServer) || !(e2 instanceof IInstallableServer)) {
                    return super.compare(viewer, e1, e2);
                }
                IInstallableServer r1 = (IInstallableServer)e1;
                IInstallableServer r2 = (IInstallableServer)e2;
                return r1.getName().compareToIgnoreCase(r2.getName());
            }
        });
        this.treeViewer.expandToLevel(2);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.initialSelection) {
            this.initialSelection = false;
            if (this.contentProvider.getInitialSelection() != null) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection(this.contentProvider.getInitialSelection()), true);
            }
        }
    }

    protected String getTitleLabel() {
        return Messages.installableServerCompTree;
    }

    protected String getDescriptionLabel() {
        return null;
    }

    protected String[] getComboOptions() {
        return new String[]{Messages.name, Messages.vendor, Messages.version};
    }

    protected void viewOptionSelected(byte option) {
        ISelection sel = this.treeViewer.getSelection();
        this.treeViewer.setContentProvider((IContentProvider)new InstallableServerContentProvider(option));
        this.treeViewer.setSelection(sel);
    }

    public IInstallableServer getSelectedInstallableServer() {
        return this.selection;
    }

    public static interface InstallableServerSelectionListener {
        public void installableServerSelected(IInstallableServer var1);
    }
}

