/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.IPublishTask;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.PublishTaskDelegate;

public class PublishTask
implements IPublishTask {
    private IConfigurationElement element;
    private PublishTaskDelegate delegate;

    public PublishTask(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    protected String[] getTypeIds() {
        try {
            return ServerPlugin.tokenize(this.element.getAttribute("typeIds"), ",");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean supportsType(String id) {
        return ServerPlugin.supportsType(this.getTypeIds(), id);
    }

    public PublishTaskDelegate getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (PublishTaskDelegate)this.element.createExecutableExtension("class");
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "Could not create delegate" + this.toString() + ": " + t.getMessage());
            }
        }
        return this.delegate;
    }

    public PublishOperation[] getTasks(IServer server, List modules) {
        try {
            Trace.trace(Trace.FINEST, "Task.init " + this);
            PublishOperation[] po = this.getDelegate().getTasks(server, modules);
            if (po != null) {
                return po;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate " + this.toString() + ": " + e.getMessage());
        }
        return new PublishOperation[0];
    }

    public PublishOperation[] getTasks(IServer server, int kind, List modules, List kindList) {
        try {
            Trace.trace(Trace.FINEST, "Task.init " + this);
            PublishOperation[] po = this.getDelegate().getTasks(server, kind, modules, kindList);
            if (po != null) {
                return po;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error calling delegate " + this.toString() + ": " + e.getMessage());
        }
        return new PublishOperation[0];
    }

    public String toString() {
        return "PublishTask[" + this.getId() + "]";
    }
}

