/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.actions;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDAdapterFactory;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDBaseAdapter;
import org.eclipse.wst.xsd.ui.internal.common.actions.XSDBaseAction;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddXSDElementCommand;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDSchema;

public class AddXSDElementAction
extends XSDBaseAction {
    public static String ID = "org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDElementAction";
    public static String REF_ID = "org.eclipse.wst.xsd.ui.internal.common.actions.AddXSDElementReferenceAction";
    boolean isReference;

    public AddXSDElementAction(IWorkbenchPart part, String id, String label, boolean isReference) {
        super(part);
        this.setText(label);
        this.setId(id);
        this.isReference = isReference;
        this.doDirectEdit = !isReference;
    }

    public void run() {
        Object selection = ((IStructuredSelection)this.getSelection()).getFirstElement();
        if (selection instanceof XSDBaseAdapter) {
            selection = ((XSDBaseAdapter)selection).getTarget();
        }
        AddXSDElementCommand command = null;
        if (selection instanceof XSDComplexTypeDefinition) {
            command = new AddXSDElementCommand(this.getText(), (XSDComplexTypeDefinition)selection);
            command.setReference(this.isReference);
            this.getCommandStack().execute((Command)command);
        } else if (selection instanceof XSDModelGroupDefinition) {
            command = new AddXSDElementCommand(this.getText(), (XSDModelGroupDefinition)selection);
            command.setReference(this.isReference);
            this.getCommandStack().execute((Command)command);
        } else if (selection instanceof XSDSchema) {
            command = new AddXSDElementCommand(this.getText(), (XSDSchema)selection);
            this.getCommandStack().execute((Command)command);
        } else if (selection instanceof XSDModelGroup) {
            XSDModelGroup modelGroup = (XSDModelGroup)selection;
            XSDConcreteComponent component = modelGroup.getContainer();
            XSDComplexTypeDefinition ct = null;
            while (component != null) {
                if (component instanceof XSDComplexTypeDefinition) {
                    ct = (XSDComplexTypeDefinition)component;
                    break;
                }
                component = component.getContainer();
            }
            command = ct != null ? new AddXSDElementCommand(this.getText(), (XSDModelGroup)selection, ct) : new AddXSDElementCommand(this.getText(), (XSDModelGroup)selection);
            command.setReference(this.isReference);
            this.getCommandStack().execute((Command)command);
        } else if (selection instanceof XSDElementDeclaration || selection instanceof XSDAttributeUse) {
            XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)selection;
            XSDConcreteComponent parent = null;
            XSDComplexTypeDefinition ct = null;
            parent = xsdConcreteComponent.getContainer();
            while (parent != null) {
                if (parent instanceof XSDComplexTypeDefinition) {
                    ct = (XSDComplexTypeDefinition)parent;
                    break;
                }
                parent = parent.getContainer();
            }
            if (ct != null) {
                command = new AddXSDElementCommand(this.getText(), ct);
                command.setReference(this.isReference);
                this.getCommandStack().execute((Command)command);
            }
        }
        if (command != null) {
            this.addedComponent = command.getAddedComponent();
            Adapter adapter = XSDAdapterFactory.getInstance().adapt((Notifier)this.addedComponent);
            this.selectAddedComponent(adapter);
        }
    }
}

