/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.provisional.format;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatContraints;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.ISourceGenerator;
import org.eclipse.wst.xml.core.internal.provisional.format.DocumentNodeFormatter;
import org.eclipse.wst.xml.core.internal.provisional.format.IStructuredFormatPreferencesXML;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.w3c.dom.NamedNodeMap;

public class ElementNodeFormatter
extends DocumentNodeFormatter {
    protected static final char DOUBLE_QUOTE = '\"';
    protected static final String DOUBLE_QUOTES = "\"\"";
    protected static final char EQUAL_CHAR = '=';
    protected static final String PRESERVE = "preserve";
    protected static final String PRESERVE_QUOTED = "\"preserve\"";
    protected static final char SINGLE_QUOTE = '\'';
    protected static final String XML_SPACE = "xml:space";
    static /* synthetic */ Class class$0;

    protected void formatEndTag(IDOMNode node, IStructuredFormatContraints formatContraints) {
        if (!this.isEndTagMissing(node)) {
            IStructuredDocumentRegion endTagStructuredDocumentRegion;
            IStructuredDocument structuredDocument = node.getModel().getStructuredDocument();
            String lineDelimiter = structuredDocument.getLineDelimiter();
            String nodeIndentation = this.getNodeIndent(node);
            IDOMNode lastChild = (IDOMNode)node.getLastChild();
            if (lastChild != null && lastChild.getNodeType() != 3) {
                if (this.isEndTagMissing(lastChild)) {
                    IDOMNode deepestChild = (IDOMNode)lastChild.getLastChild();
                    while (deepestChild != null && deepestChild.getLastChild() != null && this.isEndTagMissing(deepestChild)) {
                        lastChild = deepestChild;
                        deepestChild = (IDOMNode)deepestChild.getLastChild();
                    }
                    if (deepestChild != null) {
                        if (deepestChild.getNodeType() == 3) {
                            String nodeText = deepestChild.getNodeValue();
                            if (!nodeText.endsWith(String.valueOf(lineDelimiter) + nodeIndentation)) {
                                nodeText = StringUtils.appendIfNotEndWith((String)nodeText, (String)lineDelimiter);
                                nodeText = StringUtils.appendIfNotEndWith((String)nodeText, (String)nodeIndentation);
                            }
                            this.replaceNodeValue(deepestChild, nodeText);
                        } else {
                            this.insertAfterNode(lastChild, String.valueOf(lineDelimiter) + nodeIndentation);
                        }
                    }
                } else {
                    this.insertAfterNode(lastChild, String.valueOf(lineDelimiter) + nodeIndentation);
                }
            } else if (lastChild == null && this.firstStructuredDocumentRegionContainsLineDelimiters(node)) {
                this.replace(structuredDocument, node.getFirstStructuredDocumentRegion().getEndOffset(), 0, String.valueOf(lineDelimiter) + nodeIndentation);
            }
            if ((endTagStructuredDocumentRegion = node.getLastStructuredDocumentRegion()).getRegions().size() >= 3) {
                ITextRegion endTagNameRegion = endTagStructuredDocumentRegion.getRegions().get(1);
                this.removeRegionSpaces(node, endTagStructuredDocumentRegion, endTagNameRegion);
            }
        }
    }

    protected void formatNode(IDOMNode node, IStructuredFormatContraints formatContraints) {
        if (node != null) {
            ITextRegionList regions;
            ITextRegion lastRegion;
            this.formatIndentationBeforeNode(node, formatContraints);
            IDOMNode newNode = node;
            int startTagStartOffset = node.getStartOffset();
            IDOMModel structuredModel = node.getModel();
            boolean currentlyInXmlSpacePreserve = formatContraints.getInPreserveSpaceElement();
            this.formatStartTag(node, formatContraints);
            newNode = (IDOMNode)structuredModel.getIndexedRegion(startTagStartOffset);
            IStructuredDocumentRegion flatNode = newNode.getFirstStructuredDocumentRegion();
            if (flatNode != null && (lastRegion = (regions = flatNode.getRegions()).get(regions.size() - 1)).getType() != "XML_EMPTY_TAG_CLOSE") {
                this.formatChildren(newNode, formatContraints);
                newNode = (IDOMNode)structuredModel.getIndexedRegion(startTagStartOffset);
                this.formatEndTag(newNode, formatContraints);
            }
            formatContraints.setInPreserveSpaceElement(currentlyInXmlSpacePreserve);
            if (newNode != null && newNode.getNextSibling() != null) {
                this.formatIndentationAfterNode(newNode, formatContraints);
            }
        }
    }

    protected void formatStartTag(IDOMNode node, IStructuredFormatContraints formatContraints) {
        String singleIndent = this.getFormatPreferences().getIndent();
        String lineIndent = formatContraints.getCurrentIndent();
        String attrIndent = String.valueOf(lineIndent) + singleIndent;
        boolean splitMultiAttrs = ((IStructuredFormatPreferencesXML)this.fFormatPreferences).getSplitMultiAttrs();
        IStructuredDocumentRegion flatNode = node.getFirstStructuredDocumentRegion();
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int currentAvailableLineWidth = 0;
            try {
                int nodeNameOffset = node.getStartOffset() + 1 + node.getNodeName().length();
                int lineOffset = node.getStructuredDocument().getLineInformationOfOffset(nodeNameOffset).getOffset();
                String text = node.getStructuredDocument().get(lineOffset, nodeNameOffset - lineOffset);
                int usedWidth = this.getIndentationLength(text);
                currentAvailableLineWidth = this.getFormatPreferences().getLineWidth() - usedWidth;
            }
            catch (BadLocationException e) {
                Logger.log(1, e.getMessage());
            }
            StringBuffer stringBuffer = new StringBuffer();
            String lineDelimiter = node.getModel().getStructuredDocument().getLineDelimiter();
            int attrLength = attributes.getLength();
            int lastUndefinedRegionOffset = 0;
            boolean sawXmlSpace = false;
            int i = 0;
            while (i < attrLength) {
                AttrImpl attr = (AttrImpl)attributes.item(i);
                ITextRegion nameRegion = attr.getNameRegion();
                ITextRegion equalRegion = attr.getEqualRegion();
                ITextRegion valueRegion = attr.getValueRegion();
                String undefinedRegion = this.getUndefinedRegions(node, lastUndefinedRegionOffset, attr.getStartOffset() - lastUndefinedRegionOffset);
                stringBuffer.append(undefinedRegion);
                lastUndefinedRegionOffset = attr.getStartOffset();
                if (flatNode.getText(nameRegion).compareTo(XML_SPACE) == 0) {
                    if (valueRegion == null) {
                        formatContraints.setInPreserveSpaceElement(true);
                    } else {
                        char firstChar;
                        ISourceGenerator generator = node.getModel().getGenerator();
                        String newAttrValue = generator.generateAttrValue(attr);
                        if (flatNode.getText(valueRegion).length() == 1 && ((firstChar = flatNode.getText(valueRegion).charAt(0)) == '\"' || firstChar == '\'')) {
                            newAttrValue = DOUBLE_QUOTES;
                        }
                        if (newAttrValue.compareTo(PRESERVE_QUOTED) == 0) {
                            formatContraints.setInPreserveSpaceElement(true);
                        } else {
                            formatContraints.setInPreserveSpaceElement(false);
                        }
                        sawXmlSpace = true;
                    }
                }
                if (splitMultiAttrs && attrLength > 1) {
                    stringBuffer.append(String.valueOf(lineDelimiter) + attrIndent);
                    stringBuffer.append(flatNode.getText(nameRegion));
                    if (valueRegion != null) {
                        undefinedRegion = this.getUndefinedRegions(node, lastUndefinedRegionOffset, flatNode.getStartOffset(equalRegion) - lastUndefinedRegionOffset);
                        stringBuffer.append(undefinedRegion);
                        lastUndefinedRegionOffset = flatNode.getStartOffset(equalRegion);
                        stringBuffer.append('=');
                        undefinedRegion = this.getUndefinedRegions(node, lastUndefinedRegionOffset, flatNode.getStartOffset(valueRegion) - lastUndefinedRegionOffset);
                        stringBuffer.append(undefinedRegion);
                        lastUndefinedRegionOffset = flatNode.getStartOffset(valueRegion);
                        stringBuffer.append(flatNode.getText(valueRegion).trim());
                    }
                } else if (valueRegion != null) {
                    int textLength = 1 + flatNode.getText(nameRegion).length() + 1 + flatNode.getText(valueRegion).length();
                    if (i == attrLength - 1 && flatNode != null) {
                        ITextRegionList regions = flatNode.getRegions();
                        ITextRegion lastRegion = regions.get(regions.size() - 1);
                        textLength = lastRegion.getType() != "XML_EMPTY_TAG_CLOSE" ? (textLength += 3) : ++textLength;
                    }
                    if (currentAvailableLineWidth >= textLength) {
                        stringBuffer.append(' ');
                        --currentAvailableLineWidth;
                    } else {
                        stringBuffer.append(String.valueOf(lineDelimiter) + attrIndent);
                        currentAvailableLineWidth = this.getFormatPreferences().getLineWidth() - attrIndent.length();
                    }
                    stringBuffer.append(flatNode.getText(nameRegion));
                    undefinedRegion = this.getUndefinedRegions(node, lastUndefinedRegionOffset, flatNode.getStartOffset(equalRegion) - lastUndefinedRegionOffset);
                    stringBuffer.append(undefinedRegion);
                    lastUndefinedRegionOffset = flatNode.getStartOffset(equalRegion);
                    stringBuffer.append('=');
                    undefinedRegion = this.getUndefinedRegions(node, lastUndefinedRegionOffset, flatNode.getStartOffset(valueRegion) - lastUndefinedRegionOffset);
                    stringBuffer.append(undefinedRegion);
                    lastUndefinedRegionOffset = flatNode.getStartOffset(valueRegion);
                    stringBuffer.append(flatNode.getText(valueRegion).trim());
                    currentAvailableLineWidth -= flatNode.getText(nameRegion).length();
                    --currentAvailableLineWidth;
                    currentAvailableLineWidth -= flatNode.getText(valueRegion).trim().length();
                } else {
                    if (currentAvailableLineWidth >= 1 + flatNode.getText(nameRegion).length()) {
                        stringBuffer.append(' ');
                        --currentAvailableLineWidth;
                    } else {
                        stringBuffer.append(String.valueOf(lineDelimiter) + attrIndent);
                        currentAvailableLineWidth = this.getFormatPreferences().getLineWidth() - attrIndent.length();
                    }
                    stringBuffer.append(flatNode.getText(nameRegion));
                    currentAvailableLineWidth -= flatNode.getText(nameRegion).length();
                }
                ++i;
            }
            String undefinedRegion = this.getUndefinedRegions(node, lastUndefinedRegionOffset, node.getEndOffset() - lastUndefinedRegionOffset);
            stringBuffer.append(undefinedRegion);
            IDOMModel structuredModel = node.getModel();
            IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
            int offset = node.getStartOffset() + 1 + node.getNodeName().length();
            int length = node.getFirstStructuredDocumentRegion().getTextLength() - 1 - node.getNodeName().length();
            if (flatNode != null) {
                ITextRegionList regions = flatNode.getRegions();
                ITextRegion firstRegion = regions.get(0);
                ITextRegion lastRegion = regions.get(regions.size() - 1);
                if (firstRegion.getType() == "XML_END_TAG_OPEN") {
                    return;
                }
                if (lastRegion.getType() == "XML_TAG_CLOSE" || lastRegion.getType() == "XML_EMPTY_TAG_CLOSE") {
                    length -= lastRegion.getLength();
                }
                if (lastRegion.getType() == "XML_EMPTY_TAG_CLOSE") {
                    stringBuffer.append(' ');
                }
            }
            this.replace(structuredDocument, offset, length, stringBuffer.toString());
            if (!sawXmlSpace) {
                CMNamedNodeMap cmAttributes;
                CMAttributeDeclaration attributeDeclaration;
                ModelQueryAdapter adapter;
                CMElementDeclaration elementDeclaration;
                IDOMDocument iDOMDocument = (IDOMDocument)node.getOwnerDocument();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((elementDeclaration = (CMElementDeclaration)(adapter = (ModelQueryAdapter)iDOMDocument.getAdapterFor(clazz)).getModelQuery().getCMNode(node)) != null && (attributeDeclaration = (CMAttributeDeclaration)(cmAttributes = elementDeclaration.getAttributes()).getNamedItem(XML_SPACE)) != null) {
                    String defaultValue = attributeDeclaration.getAttrType().getImpliedValue();
                    if (defaultValue.compareTo(PRESERVE) == 0) {
                        formatContraints.setInPreserveSpaceElement(true);
                    } else {
                        formatContraints.setInPreserveSpaceElement(false);
                    }
                }
            }
        }
    }

    protected String getUndefinedRegions(IDOMNode node, int startOffset, int length) {
        String result = new String();
        IStructuredDocumentRegion flatNode = node.getFirstStructuredDocumentRegion();
        ITextRegionList regions = flatNode.getRegions();
        int i = 0;
        while (i < regions.size()) {
            ITextRegion region = regions.get(i);
            String regionType = region.getType();
            int regionStartOffset = flatNode.getStartOffset(region);
            if (regionType.compareTo("UNDEFINED") == 0 && regionStartOffset >= startOffset && regionStartOffset < startOffset + length) {
                result = String.valueOf(result) + flatNode.getFullText(region);
            }
            ++i;
        }
        if (result.length() > 0) {
            return " " + result.trim();
        }
        return result;
    }
}

