/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.metamodel.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.css.core.internal.contentproperties.CSSContentProperties;
import org.eclipse.wst.css.core.internal.metamodel.CSSProfile;
import org.eclipse.wst.css.core.internal.metamodel.CSSProfileRegistry;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class CSSProfileFinder {
    private static CSSProfileFinder fInstance = null;

    private CSSProfileFinder() {
    }

    public static synchronized CSSProfileFinder getInstance() {
        if (fInstance == null) {
            fInstance = new CSSProfileFinder();
        }
        return fInstance;
    }

    public CSSProfile findProfileFor(ICSSNode node) {
        ICSSDocument doc;
        ICSSModel model = null;
        if (node != null && (doc = node.getOwnerDocument()) != null) {
            model = doc.getModel();
        }
        return this.findProfileFor(model);
    }

    public CSSProfile findProfileFor(IStructuredModel model) {
        String baseLocation = null;
        if (model instanceof ICSSModel) {
            Object modelType = ((ICSSModel)model).getStyleSheetType();
            if (modelType == "externalCSS") {
                baseLocation = model.getBaseLocation();
            } else if (modelType == "embeddedCSS" || modelType == "inlineCSS") {
                baseLocation = model.getBaseLocation();
            }
        } else if (model != null) {
            baseLocation = model.getBaseLocation();
        }
        return this.findProfileFor(baseLocation);
    }

    public CSSProfile findProfileFor(String baseLocation) {
        CSSProfileRegistry reg = CSSProfileRegistry.getInstance();
        CSSProfile profile = null;
        if (baseLocation != null) {
            String profileID;
            Path path = new Path(baseLocation);
            IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            if (resource == null && path.segmentCount() > 1) {
                resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
            if (resource != null && (profileID = CSSContentProperties.getProperty("css-profile", (IResource)resource, true)) != null && profileID.length() > 0) {
                profile = reg.getProfile(profileID);
            }
        }
        return profile != null ? profile : reg.getDefaultProfile();
    }
}

