/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.weblogic;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.server.generic.core.internal.CorePlugin;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.jst.server.generic.core.internal.publishers.AbstractModuleAssembler;
import org.eclipse.jst.server.generic.core.internal.publishers.AntPublisher;
import org.eclipse.jst.server.generic.weblogic.GenericWebLogicEarAssembler;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.util.ProjectModule;

public class GenericWebLogicPublisher
extends AntPublisher {
    static /* synthetic */ Class class$0;

    public IStatus[] publish(IModuleArtifact[] resource, IProgressMonitor monitor) {
        IModule[] module = this.getModule();
        GenericServer server = this.getServer();
        if (module.length > 1) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        ArrayList<IModule> modulePath = new ArrayList<IModule>();
        modulePath.add(module[0]);
        if (!this.needToPublish(modulePath, module[0], server)) {
            Trace.trace((byte)Trace.FINER, (String)"GenericWebLogicAntPublisher: no module changes, publish not necessary");
            return null;
        }
        IStatus[] status = super.publish(resource, monitor);
        if (status == null) {
            this.updateChildModulePublishState(modulePath, module[0], 1, server);
        } else {
            this.updateChildModulePublishState(modulePath, module[0], 0, server);
        }
        return status;
    }

    protected void assembleModule(IProgressMonitor monitor) throws CoreException {
        IModule[] module = this.getModule();
        GenericServer server = this.getServer();
        if (GenericWebLogicPublisher.isModuleType(module[0], "jst.ear")) {
            GenericWebLogicEarAssembler assembler = new GenericWebLogicEarAssembler(module[0], server, AbstractModuleAssembler.Factory.getDefaultAssembleRoot((IModule)module[0], (GenericServer)server));
            assembler.assemble(monitor);
        } else {
            super.assembleModule(monitor);
        }
    }

    private static boolean isModuleType(IModule module, String moduleTypeId) {
        return module.getModuleType() != null && moduleTypeId.equals(module.getModuleType().getId());
    }

    private boolean needToPublish(List modulePath, IModule module, GenericServer genericServer) {
        IModule[] modules;
        Server server = (Server)genericServer.getServer();
        IModuleResourceDelta[] delta = server.getPublishedResourceDelta(modules = modulePath.toArray(new IModule[0]));
        if (delta.length > 0) {
            if (CorePlugin.getDefault().isDebugging()) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ProjectModule pm = (ProjectModule)module.loadAdapter((Class)clazz, (IProgressMonitor)new NullProgressMonitor());
                Trace.trace((byte)Trace.FINER, (String)("GenericWebLogicPublisher: Module " + pm.getId() + " has changes, path length: " + modulePath.size()));
            }
            return true;
        }
        if (GenericWebLogicPublisher.isModuleType(module, "jst.ear")) {
            IModule[] childModules = genericServer.getChildModules(new IModule[]{module});
            int i = 0;
            while (i < childModules.length) {
                modulePath.add(childModules[i]);
                boolean publish = this.needToPublish(modulePath, childModules[i], genericServer);
                modulePath.remove(modulePath.size() - 1);
                if (publish) {
                    return true;
                }
                ++i;
            }
        }
        if (CorePlugin.getDefault().isDebugging()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ProjectModule pm = (ProjectModule)module.loadAdapter((Class)clazz, (IProgressMonitor)new NullProgressMonitor());
            Trace.trace((byte)Trace.FINER, (String)("GenericWebLogicPublisher: Module " + pm.getId() + " does not have changes"));
        }
        return false;
    }

    private void updateChildModulePublishState(List modulePath, IModule module, int publishState, GenericServer genericServer) {
        Server server = (Server)genericServer.getServer();
        IModuleType moduleType = module.getModuleType();
        if (moduleType == null || !"jst.ear".equals(moduleType.getId())) {
            return;
        }
        IModule[] childModules = genericServer.getChildModules(new IModule[]{module});
        int i = 0;
        while (i < childModules.length) {
            modulePath.add(childModules[i]);
            if (CorePlugin.getDefault().isDebugging()) {
                IModule iModule = childModules[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ProjectModule pm = (ProjectModule)iModule.loadAdapter((Class)clazz, (IProgressMonitor)new NullProgressMonitor());
                Trace.trace((byte)Trace.FINER, (String)("GenericWebLogicPublisher: Updating module publish state for child module" + pm.getId() + " to " + publishState));
            }
            server.setModulePublishState(modulePath.toArray(new IModule[0]), publishState);
            this.updateChildModulePublishState(modulePath, childModules[i], publishState, genericServer);
            modulePath.remove(modulePath.size() - 1);
            ++i;
        }
    }
}

