/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.PrintWriter;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.pde.internal.core.itarget.ITargetJRE;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.core.target.TargetObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TargetJRE
extends TargetObject
implements ITargetJRE {
    private static final long serialVersionUID = 1L;
    private int fType;
    private String fName;

    public TargetJRE(ITargetModel model) {
        super(model);
    }

    public int getJREType() {
        return this.fType;
    }

    public String getJREName() {
        return this.fName;
    }

    public void setNamedJRE(String name) {
        int oldType = this.fType;
        String oldName = this.fName;
        this.fName = name == null ? "" : name;
        this.fType = 1;
        if (oldType != this.fType) {
            this.firePropertyChanged("targetJRE", new Integer(oldType), new Integer(this.fType));
        } else {
            this.firePropertyChanged("targetJRE", oldName, this.fName);
        }
    }

    public void setExecutionEnvJRE(String name) {
        int oldType = this.fType;
        String oldName = this.fName;
        this.fName = name == null ? "" : name;
        this.fType = 2;
        if (oldType != this.fType) {
            this.firePropertyChanged("targetJRE", new Integer(oldType), new Integer(this.fType));
        } else {
            this.firePropertyChanged("targetJRE", oldName, this.fName);
        }
    }

    public void setDefaultJRE() {
        int oldType = this.fType;
        this.fName = "";
        this.fType = 0;
        if (oldType != this.fType) {
            this.firePropertyChanged("targetJRE", new Integer(oldType), new Integer(this.fType));
        }
    }

    public void parse(Node node) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("jreName")) {
                    this.fType = 1;
                    this.fName = this.getText(child);
                } else if (child.getNodeName().equals("execEnv")) {
                    this.fType = 2;
                    this.fName = this.getText(child);
                }
            }
            ++i;
        }
        if (list.getLength() == 0) {
            this.fType = 0;
            this.fName = "";
        }
    }

    private String getText(Node node) {
        node.normalize();
        Node text = node.getFirstChild();
        if (text != null && text.getNodeType() == 3) {
            return text.getNodeValue();
        }
        return "";
    }

    public void write(String indent, PrintWriter writer) {
        if (this.fType == 0) {
            return;
        }
        writer.println();
        writer.println(String.valueOf(indent) + "<targetJRE>");
        if (this.fType == 1) {
            writer.println(String.valueOf(indent) + "   <jreName>" + this.getWritableString(this.fName) + "</jreName>");
        } else if (this.fType == 2) {
            writer.println(String.valueOf(indent) + "   <execEnv>" + this.getWritableString(this.fName) + "</execEnv>");
        }
        writer.println(String.valueOf(indent) + "</targetJRE>");
    }

    public String getCompatibleJRE() {
        int jreType = this.getJREType();
        switch (jreType) {
            case 0: {
                return JavaRuntime.getDefaultVMInstall().getName();
            }
            case 1: {
                return this.getJREName();
            }
            case 2: {
                IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
                IExecutionEnvironment environment = manager.getEnvironment(this.getJREName());
                IVMInstall vm = null;
                if (environment == null) break;
                vm = environment.getDefaultVM();
                if (vm == null) {
                    IVMInstall[] installs = environment.getCompatibleVMs();
                    int i = 0;
                    while (i < installs.length) {
                        IVMInstall install = installs[i];
                        if (environment.isStrictlyCompatible(install)) {
                            return install.getName();
                        }
                        ++i;
                    }
                    if (vm == null && installs.length > 0) {
                        return installs[0].getName();
                    }
                }
                return vm.getName();
            }
        }
        return JavaRuntime.getDefaultVMInstall().getName();
    }
}

