/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringTickProvider;
import org.eclipse.ltk.internal.core.refactoring.NotCancelableProgressMonitor;
import org.eclipse.ltk.internal.core.refactoring.history.UnknownRefactoringDescriptor;

public class CreateChangeOperation
implements IWorkspaceRunnable {
    private Refactoring fRefactoring;
    private CheckConditionsOperation fCheckConditionOperation;
    private int fConditionCheckingFailedSeverity;
    private Change fChange;

    public CreateChangeOperation(Refactoring refactoring) {
        Assert.isNotNull((Object)((Object)refactoring));
        this.fRefactoring = refactoring;
    }

    public CreateChangeOperation(CheckConditionsOperation operation, int checkFailedSeverity) {
        Assert.isNotNull((Object)operation);
        this.fCheckConditionOperation = operation;
        this.fRefactoring = operation.getRefactoring();
        Assert.isTrue((checkFailedSeverity > 0 && checkFailedSeverity <= 4 ? 1 : 0) != 0);
        this.fConditionCheckingFailedSeverity = checkFailedSeverity;
    }

    public int getConditionCheckingFailedSeverity() {
        return this.fConditionCheckingFailedSeverity;
    }

    public void run(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        this.fChange = null;
        try {
            this.fChange = null;
            RefactoringTickProvider rtp = this.fRefactoring.getRefactoringTickProvider();
            if (this.fCheckConditionOperation != null) {
                int conditionTicks = this.fCheckConditionOperation.getTicks(rtp);
                int allTicks = conditionTicks + rtp.getCreateChangeTicks() + rtp.getInitializeChangeTicks();
                pm.beginTask("", allTicks);
                pm.subTask("");
                this.fCheckConditionOperation.run((IProgressMonitor)new SubProgressMonitor(pm, conditionTicks));
                RefactoringStatus status = this.fCheckConditionOperation.getStatus();
                if (status != null && status.getSeverity() < this.fConditionCheckingFailedSeverity) {
                    this.fChange = this.fRefactoring.createChange((IProgressMonitor)new SubProgressMonitor(pm, rtp.getCreateChangeTicks()));
                    this.fChange.initializeValidationData((IProgressMonitor)new NotCancelableProgressMonitor((IProgressMonitor)new SubProgressMonitor(pm, rtp.getInitializeChangeTicks())));
                } else {
                    pm.worked(rtp.getCreateChangeTicks() + rtp.getInitializeChangeTicks());
                }
            } else {
                pm.beginTask("", rtp.getCreateChangeTicks() + rtp.getInitializeChangeTicks());
                this.fChange = this.fRefactoring.createChange((IProgressMonitor)new SubProgressMonitor(pm, rtp.getCreateChangeTicks()));
                this.fChange.initializeValidationData((IProgressMonitor)new NotCancelableProgressMonitor((IProgressMonitor)new SubProgressMonitor(pm, rtp.getInitializeChangeTicks())));
            }
        }
        finally {
            pm.done();
        }
    }

    public Change getChange() {
        ChangeDescriptor descriptor;
        if (this.fChange != null && (descriptor = this.fChange.getDescriptor()) == null) {
            CompositeChange composite = new CompositeChange(this.fChange.getName()){

                public final ChangeDescriptor getDescriptor() {
                    return new RefactoringChangeDescriptor(new UnknownRefactoringDescriptor(CreateChangeOperation.this.fChange.getName()));
                }
            };
            composite.markAsSynthetic();
            composite.add(this.fChange);
            this.fChange = composite;
        }
        return this.fChange;
    }

    public RefactoringStatus getConditionCheckingStatus() {
        if (this.fCheckConditionOperation != null) {
            return this.fCheckConditionOperation.getStatus();
        }
        return null;
    }

    public int getConditionCheckingStyle() {
        if (this.fCheckConditionOperation != null) {
            return this.fCheckConditionOperation.getStyle();
        }
        return 0;
    }
}

