/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Stack;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.UnavailableException;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.HttpRequestBase;
import org.apache.catalina.connector.HttpResponseBase;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapperFacade;
import org.apache.catalina.core.StandardWrapperValve;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.InstanceSupport;
import org.apache.tomcat.util.log.SystemLogHandler;

public final class StandardWrapper
extends ContainerBase
implements ServletConfig,
Wrapper {
    private long available = 0L;
    private int countAllocated = 0;
    private int debug = 0;
    private StandardWrapperFacade facade = new StandardWrapperFacade(this);
    private static final String info = "org.apache.catalina.core.StandardWrapper/1.0";
    private Servlet instance = null;
    private StandardWrapperValve swValve;
    private InstanceSupport instanceSupport = new InstanceSupport(this);
    private String jspFile = null;
    private int loadOnStartup = -1;
    private HashMap parameters = new HashMap();
    private HashMap references = new HashMap();
    private String runAs = null;
    private String servletClass = null;
    private boolean singleThreadModel = false;
    private boolean unloading = false;
    private int maxInstances = 20;
    private int nInstances = 0;
    private Stack instancePool = null;
    private boolean swallowOutput = false;
    static /* synthetic */ Class class$org$apache$catalina$ContainerServlet;

    public StandardWrapper() {
        this.swValve = new StandardWrapperValve();
        this.pipeline.setBasic(this.swValve);
    }

    public long getAvailable() {
        return this.available;
    }

    public void setAvailable(long available) {
        long oldAvailable = this.available;
        this.available = available > System.currentTimeMillis() ? available : 0L;
        this.support.firePropertyChange("available", new Long(oldAvailable), new Long(this.available));
    }

    public int getCountAllocated() {
        return this.countAllocated;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        int oldDebug = this.debug;
        this.debug = debug;
        this.support.firePropertyChange("debug", new Integer(oldDebug), new Long(this.debug));
    }

    public String getInfo() {
        return info;
    }

    public InstanceSupport getInstanceSupport() {
        return this.instanceSupport;
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public void setJspFile(String jspFile) {
        String oldJspFile = this.jspFile;
        this.jspFile = jspFile;
        this.support.firePropertyChange("jspFile", oldJspFile, this.jspFile);
    }

    public int getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(int value) {
        int oldLoadOnStartup = this.loadOnStartup;
        this.loadOnStartup = value;
        this.support.firePropertyChange("loadOnStartup", new Integer(oldLoadOnStartup), new Integer(this.loadOnStartup));
    }

    public void setLoadOnStartupString(String value) {
        try {
            this.setLoadOnStartup(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            this.setLoadOnStartup(0);
        }
    }

    public int getMaxInstances() {
        return this.maxInstances;
    }

    public void setMaxInstances(int maxInstances) {
        int oldMaxInstances = this.maxInstances;
        this.maxInstances = maxInstances;
        this.support.firePropertyChange("maxInstances", oldMaxInstances, this.maxInstances);
    }

    public void setParent(Container container) {
        if (container != null && !(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("standardWrapper.notContext"));
        }
        if (container instanceof StandardContext) {
            this.swallowOutput = ((StandardContext)container).getSwallowOutput();
        }
        super.setParent(container);
    }

    public String getRunAs() {
        return this.runAs;
    }

    public void setRunAs(String runAs) {
        String oldRunAs = this.runAs;
        this.runAs = runAs;
        this.support.firePropertyChange("runAs", oldRunAs, this.runAs);
    }

    public String getServletClass() {
        return this.servletClass;
    }

    public void setServletClass(String servletClass) {
        String oldServletClass = this.servletClass;
        this.servletClass = servletClass;
        this.support.firePropertyChange("servletClass", oldServletClass, this.servletClass);
    }

    public void setServletName(String name) {
        this.setName(name);
    }

    public boolean isSingleThreadModel() {
        try {
            this.loadServlet();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.singleThreadModel;
    }

    public boolean isUnavailable() {
        if (this.available == 0L) {
            return false;
        }
        if (this.available <= System.currentTimeMillis()) {
            this.available = 0L;
            return false;
        }
        return true;
    }

    public void addChild(Container child) {
        throw new IllegalStateException(sm.getString("standardWrapper.notChild"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInitParameter(String name, String value) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.put(name, value);
        }
        this.fireContainerEvent("addInitParameter", name);
    }

    public void addInstanceListener(InstanceListener listener) {
        this.instanceSupport.addInstanceListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecurityReference(String name, String link) {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            this.references.put(name, link);
        }
        this.fireContainerEvent("addSecurityReference", name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet allocate() throws ServletException {
        Object object;
        if (this.debug >= 1) {
            this.log("Allocating an instance");
        }
        if (this.unloading) {
            throw new ServletException(sm.getString("standardWrapper.unloading", this.getName()));
        }
        if (!this.singleThreadModel) {
            if (this.instance == null) {
                object = this;
                synchronized (object) {
                    if (this.instance == null) {
                        try {
                            this.instance = this.loadServlet();
                        }
                        catch (ServletException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            throw new ServletException(sm.getString("standardWrapper.allocate"), e);
                        }
                    }
                }
            }
            if (!this.singleThreadModel) {
                if (this.debug >= 2) {
                    this.log("  Returning non-STM instance");
                }
                ++this.countAllocated;
                return this.instance;
            }
        }
        object = this.instancePool;
        synchronized (object) {
            while (this.countAllocated >= this.nInstances) {
                if (this.nInstances < this.maxInstances) {
                    try {
                        this.instancePool.push(this.loadServlet());
                        ++this.nInstances;
                        continue;
                    }
                    catch (ServletException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new ServletException(sm.getString("standardWrapper.allocate"), e);
                    }
                }
                try {
                    this.instancePool.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.debug >= 2) {
                this.log("  Returning allocated STM instance");
            }
            ++this.countAllocated;
            return (Servlet)this.instancePool.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate(Servlet servlet) throws ServletException {
        if (!this.singleThreadModel) {
            --this.countAllocated;
            return;
        }
        Stack stack = this.instancePool;
        synchronized (stack) {
            --this.countAllocated;
            this.instancePool.push(servlet);
            this.instancePool.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findInitParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return (String)this.parameters.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findInitParameters() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            String[] results = new String[this.parameters.size()];
            return this.parameters.keySet().toArray(results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findSecurityReference(String name) {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            return (String)this.references.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] findSecurityReferences() {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            String[] results = new String[this.references.size()];
            return this.references.keySet().toArray(results);
        }
    }

    public synchronized void load() throws ServletException {
        this.instance = this.loadServlet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Servlet loadServlet() throws ServletException {
        if (!this.singleThreadModel && this.instance != null) {
            return this.instance;
        }
        PrintStream out = System.out;
        if (this.swallowOutput) {
            SystemLogHandler.startCapture();
        }
        Servlet servlet = null;
        try {
            Wrapper jspWrapper;
            String actualClass = this.servletClass;
            if (actualClass == null && this.jspFile != null && (jspWrapper = (Wrapper)((Context)this.getParent()).findChild("jsp")) != null) {
                actualClass = jspWrapper.getServletClass();
            }
            if (actualClass == null) {
                this.unavailable(null);
                throw new ServletException(sm.getString("standardWrapper.notClass", this.getName()));
            }
            Loader loader = this.getLoader();
            if (loader == null) {
                this.unavailable(null);
                throw new ServletException(sm.getString("standardWrapper.missingLoader", this.getName()));
            }
            ClassLoader classLoader = loader.getClassLoader();
            if (this.isContainerProvidedServlet(actualClass)) {
                classLoader = this.getClass().getClassLoader();
                this.log(sm.getString("standardWrapper.containerServlet", this.getName()));
            }
            Class<?> classClass = null;
            try {
                classClass = classLoader != null ? classLoader.loadClass(actualClass) : Class.forName(actualClass);
            }
            catch (ClassNotFoundException e) {
                this.unavailable(null);
                throw new ServletException(sm.getString("standardWrapper.missingClass", actualClass), (Throwable)e);
            }
            if (classClass == null) {
                this.unavailable(null);
                throw new ServletException(sm.getString("standardWrapper.missingClass", actualClass));
            }
            try {
                servlet = (Servlet)classClass.newInstance();
            }
            catch (ClassCastException e) {
                this.unavailable(null);
                throw new ServletException(sm.getString("standardWrapper.notServlet", actualClass), (Throwable)e);
            }
            catch (Throwable e) {
                this.unavailable(null);
                throw new ServletException(sm.getString("standardWrapper.instantiate", actualClass), e);
            }
            if (!this.isServletAllowed(servlet)) {
                throw new SecurityException(sm.getString("standardWrapper.privilegedServlet", actualClass));
            }
            if (servlet instanceof ContainerServlet && this.isContainerProvidedServlet(actualClass)) {
                ((ContainerServlet)servlet).setWrapper(this);
            }
            try {
                this.instanceSupport.fireInstanceEvent("beforeInit", servlet);
                servlet.init((ServletConfig)this.facade);
                if (this.loadOnStartup >= 0 && this.jspFile != null) {
                    HttpRequestBase req = new HttpRequestBase();
                    HttpResponseBase res = new HttpResponseBase();
                    req.setServletPath(this.jspFile);
                    req.setQueryString("jsp_precompile=true");
                    servlet.service((ServletRequest)req, (ServletResponse)res);
                }
                this.instanceSupport.fireInstanceEvent("afterInit", servlet);
            }
            catch (UnavailableException f) {
                this.instanceSupport.fireInstanceEvent("afterInit", servlet, (Throwable)f);
                this.unavailable(f);
                throw f;
            }
            catch (ServletException f) {
                this.instanceSupport.fireInstanceEvent("afterInit", servlet, (Throwable)f);
                throw f;
            }
            catch (Throwable f) {
                this.instanceSupport.fireInstanceEvent("afterInit", servlet, f);
                throw new ServletException(sm.getString("standardWrapper.initException", this.getName()), f);
            }
            this.singleThreadModel = servlet instanceof SingleThreadModel;
            if (this.singleThreadModel && this.instancePool == null) {
                this.instancePool = new Stack();
            }
            this.fireContainerEvent("load", this);
            Object var10_15 = null;
            if (!this.swallowOutput) return servlet;
        }
        catch (Throwable throwable) {
            String log22;
            Object var10_16 = null;
            if (!this.swallowOutput || (log22 = SystemLogHandler.stopCapture()) == null || log22.length() <= 0) throw throwable;
            if (this.getServletContext() != null) {
                this.getServletContext().log(log22);
                throw throwable;
            } else {
                out.println(log22);
            }
            throw throwable;
        }
        String log22 = SystemLogHandler.stopCapture();
        if (log22 == null || log22.length() <= 0) return servlet;
        if (this.getServletContext() != null) {
            this.getServletContext().log(log22);
            return servlet;
        }
        out.println(log22);
        return servlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInitParameter(String name) {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            this.parameters.remove(name);
        }
        this.fireContainerEvent("removeInitParameter", name);
    }

    public void removeInstanceListener(InstanceListener listener) {
        this.instanceSupport.removeInstanceListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityReference(String name) {
        HashMap hashMap = this.references;
        synchronized (hashMap) {
            this.references.remove(name);
        }
        this.fireContainerEvent("removeSecurityReference", name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getParent() != null) {
            sb.append(this.getParent().toString());
            sb.append(".");
        }
        sb.append("StandardWrapper[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    public void unavailable(UnavailableException unavailable) {
        this.log(sm.getString("standardWrapper.unavailable", this.getName()));
        if (unavailable == null) {
            this.setAvailable(Long.MAX_VALUE);
        } else if (unavailable.isPermanent()) {
            this.setAvailable(Long.MAX_VALUE);
        } else {
            int unavailableSeconds = unavailable.getUnavailableSeconds();
            if (unavailableSeconds <= 0) {
                unavailableSeconds = 60;
            }
            this.setAvailable(System.currentTimeMillis() + (long)unavailableSeconds * 1000L);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void unload() throws ServletException {
        ClassLoader classLoader;
        ClassLoader oldCtxClassLoader;
        block22: {
            if (!this.singleThreadModel && this.instance == null) {
                return;
            }
            this.unloading = true;
            if (this.countAllocated > 0) {
                for (int nRetries = 0; nRetries < 10; ++nRetries) {
                    if (nRetries == 0) {
                        this.log("Waiting for " + this.countAllocated + " instance(s) to be deallocated");
                    }
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            oldCtxClassLoader = Thread.currentThread().getContextClassLoader();
            classLoader = this.instance.getClass().getClassLoader();
            PrintStream out = System.out;
            if (this.swallowOutput) {
                SystemLogHandler.startCapture();
            }
            try {
                try {
                    this.instanceSupport.fireInstanceEvent("beforeDestroy", this.instance);
                    Thread.currentThread().setContextClassLoader(classLoader);
                    this.instance.destroy();
                    this.instanceSupport.fireInstanceEvent("afterDestroy", this.instance);
                }
                catch (Throwable t) {
                    this.instanceSupport.fireInstanceEvent("afterDestroy", this.instance, t);
                    this.instance = null;
                    this.instancePool = null;
                    this.nInstances = 0;
                    this.fireContainerEvent("unload", this);
                    this.unloading = false;
                    throw new ServletException(sm.getString("standardWrapper.destroyException", this.getName()), t);
                }
                Object var6_6 = null;
                Thread.currentThread().setContextClassLoader(oldCtxClassLoader);
                if (!this.swallowOutput) break block22;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                Thread.currentThread().setContextClassLoader(oldCtxClassLoader);
                if (!this.swallowOutput) throw throwable;
                String log = SystemLogHandler.stopCapture();
                if (log == null) throw throwable;
                if (log.length() <= 0) throw throwable;
                if (this.getServletContext() != null) {
                    this.getServletContext().log(log);
                    throw throwable;
                }
                out.println(log);
                throw throwable;
            }
            String log = SystemLogHandler.stopCapture();
            if (log != null && log.length() > 0) {
                if (this.getServletContext() != null) {
                    this.getServletContext().log(log);
                } else {
                    out.println(log);
                }
            }
        }
        this.instance = null;
        if (this.singleThreadModel && this.instancePool != null) {
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                while (!this.instancePool.isEmpty()) {
                    ((Servlet)this.instancePool.pop()).destroy();
                }
            }
            catch (Throwable t) {
                this.instancePool = null;
                this.nInstances = 0;
                this.unloading = false;
                this.fireContainerEvent("unload", this);
                throw new ServletException(sm.getString("standardWrapper.destroyException", this.getName()), t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCtxClassLoader);
            }
            this.instancePool = null;
            this.nInstances = 0;
        }
        this.singleThreadModel = false;
        this.unloading = false;
        this.fireContainerEvent("unload", this);
    }

    public String getInitParameter(String name) {
        return this.findInitParameter(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getInitParameterNames() {
        HashMap hashMap = this.parameters;
        synchronized (hashMap) {
            return new Enumerator(this.parameters.keySet());
        }
    }

    public ServletContext getServletContext() {
        if (this.parent == null) {
            return null;
        }
        if (!(this.parent instanceof Context)) {
            return null;
        }
        return ((Context)this.parent).getServletContext();
    }

    public String getServletName() {
        return this.getName();
    }

    protected void addDefaultMapper(String mapperClass) {
    }

    private boolean isContainerProvidedServlet(String classname) {
        if (classname.startsWith("org.apache.catalina.")) {
            return true;
        }
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(classname);
            return (class$org$apache$catalina$ContainerServlet == null ? (class$org$apache$catalina$ContainerServlet = StandardWrapper.class$("org.apache.catalina.ContainerServlet")) : class$org$apache$catalina$ContainerServlet).isAssignableFrom(clazz);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean isServletAllowed(Object servlet) {
        if (servlet instanceof ContainerServlet) {
            return ((Context)this.getParent()).getPrivileged() || servlet.getClass().getName().equals("org.apache.catalina.servlets.InvokerServlet");
        }
        return true;
    }

    protected String logName() {
        StringBuffer sb = new StringBuffer("StandardWrapper[");
        if (this.getParent() != null) {
            sb.append(this.getParent().getName());
        } else {
            sb.append("null");
        }
        sb.append(':');
        sb.append(this.getName());
        sb.append(']');
        return sb.toString();
    }

    public void start() throws LifecycleException {
        super.start();
        this.setAvailable(0L);
    }

    public void stop() throws LifecycleException {
        this.setAvailable(Long.MAX_VALUE);
        try {
            this.unload();
        }
        catch (ServletException e) {
            this.log(sm.getString("standardWrapper.unloadException", this.getName()), e);
        }
        super.stop();
    }

    public long getProcessingTime() {
        return this.swValve.getProcessingTime();
    }

    public void setProcessingTime(long processingTime) {
        this.swValve.setProcessingTime(processingTime);
    }

    public long getMaxTime() {
        return this.swValve.getMaxTime();
    }

    public void setMaxTime(long maxTime) {
        this.swValve.setMaxTime(maxTime);
    }

    public int getRequestCount() {
        return this.swValve.getRequestCount();
    }

    public void setRequestCount(int requestCount) {
        this.swValve.setRequestCount(requestCount);
    }

    public int getErrorCount() {
        return this.swValve.getErrorCount();
    }

    public void setErrorCount(int errorCount) {
        this.swValve.setErrorCount(errorCount);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

